/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.Rect;
import java.util.Optional;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class JeiLootSlotWidget
implements ISlottedRecipeWidget {
    private final Rect rect;
    private final IRecipeSlotDrawable slotDrawable;
    @Nullable
    private Component count;
    private boolean isRange = false;

    public JeiLootSlotWidget(IRecipeSlotDrawable slotDrawable, int x, int y, RangeValue count) {
        this.slotDrawable = slotDrawable;
        this.rect = new Rect(x, y, 18, 18);
        this.setCount(count);
    }

    @NotNull
    public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double mouseX, double mouseY) {
        if (this.slotDrawable.isMouseOver(mouseX, mouseY)) {
            return Optional.of(new RecipeSlotUnderMouse(this.slotDrawable, 0, 0));
        }
        return Optional.empty();
    }

    @NotNull
    public ScreenPosition getPosition() {
        return new ScreenPosition(this.rect.x(), this.rect.y());
    }

    public void drawWidget(GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Matrix3x2fStack stack = guiGraphics.pose();
        stack.translate(1.0f, 1.0f);
        this.slotDrawable.draw(guiGraphics);
        stack.translate(-1.0f, -1.0f);
        if (this.count != null) {
            Font font = Minecraft.getInstance().font;
            stack.pushMatrix();
            stack.translate((float)this.rect.x(), (float)this.rect.y());
            if (this.isRange) {
                stack.translate(17.0f, 13.0f);
                stack.pushMatrix();
                stack.scale(0.5f);
                guiGraphics.drawString(font, this.count, -font.width((FormattedText)this.count), 0, -1, false);
                stack.popMatrix();
            } else {
                stack.translate(18.0f, 10.0f);
                guiGraphics.drawString(font, this.count, -font.width((FormattedText)this.count), 0, -1, true);
            }
            stack.popMatrix();
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, double mouseX, double mouseY) {
        if (this.slotDrawable.isMouseOver(mouseX, mouseY)) {
            this.slotDrawable.getTooltip(tooltip);
        }
    }

    private void setCount(RangeValue count) {
        if (count.isRange() || count.min() > 1.0f) {
            this.count = Component.literal((String)count.toIntString());
            this.isRange = count.isRange();
        }
    }
}

