/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.yanny.ali.network.AbstractClient;
import com.yanny.ali.network.AbstractServer;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.Client;
import com.yanny.ali.network.DistHolder;
import com.yanny.ali.network.DoneMessage;
import com.yanny.ali.network.Server;
import com.yanny.ali.network.SyncLootTableMessage;
import com.yanny.ali.network.SyncTradeMessage;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public class NetworkUtils {
    public static DistHolder<AbstractClient, AbstractServer> registerLootInfoPropagator(PayloadRegistrar registrar) {
        if (FMLEnvironment.getDist() == Dist.CLIENT) {
            return NetworkUtils.registerClientLootInfoPropagator(registrar);
        }
        return NetworkUtils.registerServerLootInfoPropagator(registrar);
    }

    @NotNull
    private static DistHolder<AbstractClient, AbstractServer> registerClientLootInfoPropagator(PayloadRegistrar registrar) {
        Client client = new Client();
        Server server = new Server();
        registrar.executesOn(HandlerThread.NETWORK).playToClient(SyncLootTableMessage.TYPE, SyncLootTableMessage.CODEC, client::onLootInfo);
        registrar.executesOn(HandlerThread.NETWORK).playToClient(SyncTradeMessage.TYPE, SyncTradeMessage.CODEC, client::onTradeInfo);
        registrar.executesOn(HandlerThread.NETWORK).playToClient(ClearMessage.TYPE, ClearMessage.CODEC, client::onClear);
        registrar.executesOn(HandlerThread.NETWORK).playToClient(DoneMessage.TYPE, DoneMessage.CODEC, client::onDone);
        return new DistHolder<AbstractClient, AbstractServer>(client, server);
    }

    @NotNull
    private static DistHolder<AbstractClient, AbstractServer> registerServerLootInfoPropagator(PayloadRegistrar registrar) {
        Server server = new Server();
        registrar.playToClient(SyncLootTableMessage.TYPE, SyncLootTableMessage.CODEC, (a, b) -> {});
        registrar.playToClient(SyncTradeMessage.TYPE, SyncTradeMessage.CODEC, (a, b) -> {});
        registrar.playToClient(ClearMessage.TYPE, ClearMessage.CODEC, (a, b) -> {});
        registrar.playToClient(DoneMessage.TYPE, DoneMessage.CODEC, (a, b) -> {});
        return new DistHolder<Object, Server>(null, server);
    }
}

