/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.trades;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerTrades;

public class TradeLevelNode
extends ListNode {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"ali", (String)"trade_level");
    public final int level;

    public TradeLevelNode(IServerUtils utils, int level, VillagerTrades.ItemListing[] itemListings) {
        this.level = level;
        for (VillagerTrades.ItemListing itemListing : itemListings) {
            if (itemListing == null) continue;
            this.addChildren(utils.getItemListing(utils, itemListing, Collections.emptyList()));
        }
    }

    public TradeLevelNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        super(utils, buf);
        this.level = buf.readInt();
    }

    @Override
    public void encodeNode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.level);
    }

    @Override
    public List<ITooltipNode> getTooltip() {
        return List.of(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.level", GenericTooltipUtils.value(this.level))));
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

