/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.common;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.QuadConsumer;
import com.yanny.ali.compatibility.common.TriConsumer;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.trades.TradeNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import oshi.util.tuples.Pair;

public class GenericUtils {
    private static final ResourceLocation TEXTURE_LOC = Utils.modLoc("textures/gui/gui.png");
    private static final int WIDGET_SIZE = 36;
    private static final int DOTS_WIDTH = Minecraft.m_91087_().f_91062_.m_92895_("...");

    public static void renderEntity(Entity entity, Rect bounds, int fullWidth, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        Window window = minecraft.m_91268_();
        PoseStack poseStack = guiGraphics.m_280168_();
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        Matrix4f projectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Matrix4f mvpMatrix = projectionMatrix.mul((Matrix4fc)modelViewMatrix);
        Vector4f topLeftWorld = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        Vector4f topLeftClip = mvpMatrix.transform(topLeftWorld);
        Vector4f topLeftNDC = new Vector4f(topLeftClip.x / topLeftClip.w, topLeftClip.y / topLeftClip.w, 0.0f, 1.0f);
        int screenX = Math.round((topLeftNDC.x + 1.0f) / 2.0f * (float)window.m_85445_());
        int screenY = Math.round((1.0f - topLeftNDC.y) / 2.0f * (float)window.m_85446_());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280411_(TEXTURE_LOC, bounds.x(), bounds.y(), bounds.width(), bounds.height(), 0.0f, 36.0f, 36, 36, 256, 256);
            guiGraphics.m_280588_(screenX + bounds.x() + 1, screenY + bounds.y() + 1, screenX + bounds.right() - 1, screenY + bounds.bottom() - 1);
            EntityDimensions dimensions = entity.m_6095_().m_20680_();
            InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)(-screenX + bounds.x()), (int)(-screenY + bounds.y()), (int)(screenX + bounds.right()), (int)(screenY + bounds.bottom()), (int)((int)Math.min(20.0f / dimensions.f_20378_(), 20.0f / dimensions.f_20377_())), (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)livingEntity);
            guiGraphics.m_280618_();
            guiGraphics.m_280168_().m_85849_();
        }
    }

    @NotNull
    public static Component ellipsis(String text, String fallback, int maxWidth) {
        Font font = Minecraft.m_91087_().f_91062_;
        text = Language.m_128107_().m_118919_(text, GenericUtils.getFallbackText(fallback));
        if (font.m_92895_(text) > maxWidth) {
            int index = 20;
            while (font.m_92895_(text.substring(0, index + 1) + DOTS_WIDTH) <= maxWidth) {
                ++index;
            }
            return Component.m_237113_((String)(text.substring(0, index) + "..."));
        }
        return Component.m_237113_((String)text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Map<ResourceLocation, LootData>, Map<ResourceLocation, TradeData>> decompressLootData(byte[] fullCompressedData, RegistryAccess registryAccess) {
        HashMap<ResourceLocation, LootData> lootData = new HashMap<ResourceLocation, LootData>();
        HashMap<ResourceLocation, TradeData> tradeData = new HashMap<ResourceLocation, TradeData>();
        ByteArrayInputStream bis = new ByteArrayInputStream(fullCompressedData);
        ByteBuf decompressedBuf = Unpooled.buffer();
        try (GZIPInputStream gzip = new GZIPInputStream(bis);){
            decompressedBuf.writeBytes(gzip.readAllBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RegistryFriendlyByteBuf readerBuf = new RegistryFriendlyByteBuf(decompressedBuf, registryAccess);
        try {
            AliClientRegistry utils = PluginManager.CLIENT_REGISTRY;
            lootData.putAll(((ArrayList)readerBuf.m_236838_(ArrayList::new, b -> {
                ResourceLocation location = b.m_130281_();
                Object dataNode = utils.getDataNodeFactory(LootTableNode.ID).create(utils, (RegistryFriendlyByteBuf)b);
                List items = (List)ItemStack.f_315592_.m_318688_((Object)((RegistryFriendlyByteBuf)b));
                return new AbstractMap.SimpleEntry<ResourceLocation, LootData>(location, new LootData((IDataNode)dataNode, items));
            })).stream().collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
            tradeData.putAll(((ArrayList)readerBuf.m_236838_(ArrayList::new, b -> {
                ResourceLocation location = b.m_130281_();
                Object dataNode = utils.getDataNodeFactory(TradeNode.ID).create(utils, (RegistryFriendlyByteBuf)b);
                List<Item> inputs = ((ArrayList)b.m_236838_(ArrayList::new, FriendlyByteBuf::m_130281_)).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_7745_(arg_0)).toList();
                List<Item> outputs = ((ArrayList)b.m_236838_(ArrayList::new, FriendlyByteBuf::m_130281_)).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_7745_(arg_0)).toList();
                return new AbstractMap.SimpleEntry<ResourceLocation, TradeData>(location, new TradeData((IDataNode)dataNode, inputs, outputs));
            })).stream().collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
        }
        finally {
            readerBuf.release();
        }
        return new Pair(lootData, tradeData);
    }

    public static void processData(ClientLevel level, AliClientRegistry clientRegistry, AliConfig config, byte[] fullCompressedData, QuadConsumer<IDataNode, ResourceLocation, Block, List<ItemStack>> blockConsumer, QuadConsumer<IDataNode, ResourceLocation, EntityType<?>, List<ItemStack>> entityConsumer, TriConsumer<IDataNode, ResourceLocation, List<ItemStack>> gameplayConsumer, QuadConsumer<IDataNode, ResourceLocation, List<ItemStack>, List<ItemStack>> traderConsumer, QuadConsumer<IDataNode, ResourceLocation, List<ItemStack>, List<ItemStack>> wanderingTraderConsumer) {
        List<ItemStack> outputs;
        List<ItemStack> inputs;
        TradeData tradeEntry;
        Object location;
        Pair<Map<ResourceLocation, LootData>, Map<ResourceLocation, TradeData>> pair = GenericUtils.decompressLootData(fullCompressedData, level.m_9598_());
        Map lootData = (Map)pair.getA();
        Map tradeData = (Map)pair.getB();
        for (Block block : BuiltInRegistries.f_256975_) {
            LootData data;
            ResourceKey resourceKey = block.m_60589_();
            if (resourceKey == null || (data = (LootData)lootData.get(location = resourceKey.m_135782_())) == null) continue;
            blockConsumer.accept(data.node, (ResourceLocation)location, block, data.items);
            lootData.remove(location);
        }
        for (EntityType entityType : BuiltInRegistries.f_256780_) {
            if (config.disabledEntities.stream().anyMatch(f -> f.equals((Object)BuiltInRegistries.f_256780_.m_7981_((Object)entityType)))) {
                lootData.remove(entityType.m_20677_().m_135782_());
                continue;
            }
            List<Entity> list = clientRegistry.createEntities(entityType, (Level)level);
            for (Entity entity : list) {
                Mob mob;
                ResourceKey resourceKey;
                if (!(entity instanceof Mob) || (resourceKey = (mob = (Mob)entity).m_5743_()) == null) continue;
                ResourceLocation location2 = resourceKey.m_135782_();
                LootData data = (LootData)lootData.get(location2);
                if (data != null) {
                    entityConsumer.accept(data.node, location2, entityType, data.items);
                }
                lootData.remove(location2);
            }
        }
        for (Map.Entry entry : lootData.entrySet()) {
            gameplayConsumer.accept(((LootData)entry.getValue()).node, (ResourceLocation)entry.getKey(), ((LootData)entry.getValue()).items());
        }
        lootData.clear();
        List<Map.Entry> entries = BuiltInRegistries.f_256735_.m_6579_().stream().sorted(Comparator.comparing(a -> ((ResourceKey)a.getKey()).m_135782_().m_135815_())).toList();
        for (Map.Entry entry : entries) {
            location = ((ResourceKey)entry.getKey()).m_135782_();
            tradeEntry = (TradeData)tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = tradeEntry.inputs.stream().map(Item::m_7968_).toList();
            outputs = tradeEntry.outputs.stream().map(Item::m_7968_).toList();
            traderConsumer.accept(tradeEntry.node, (ResourceLocation)location, inputs, outputs);
            tradeData.remove(location);
        }
        for (Map.Entry entry : tradeData.entrySet()) {
            location = (ResourceLocation)entry.getKey();
            tradeEntry = (TradeData)tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = tradeEntry.inputs.stream().map(Item::m_7968_).toList();
            outputs = tradeEntry.outputs.stream().map(Item::m_7968_).toList();
            wanderingTraderConsumer.accept(tradeEntry.node, (ResourceLocation)location, inputs, outputs);
        }
        tradeData.clear();
    }

    private static String getFallbackText(String fallback) {
        List pathSegments = Pattern.compile("/").splitAsStream(fallback).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        Collections.reverse(pathSegments);
        return pathSegments.stream().flatMap(segment -> Arrays.stream(segment.split("_"))).filter(s -> !s.isEmpty()).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining(" "));
    }

    public record LootData(IDataNode node, List<ItemStack> items) {
    }

    public record TradeData(IDataNode node, List<Item> inputs, List<Item> outputs) {
    }
}

