/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class TagNode
implements IDataNode,
IItemNode {
    public static final ResourceLocation ID = ResourceLocation.m_339182_((String)"ali", (String)"tag");
    private final ITooltipNode tooltip;
    private final List<LootItemCondition> conditions;
    private final List<LootItemFunction> functions;
    private final TagKey<? extends ItemLike> tag;
    private final RangeValue count;
    private final float chance;

    public TagNode(IServerUtils utils, TagKey<? extends ItemLike> tag, RangeValue count) {
        this(utils, tag, count, EmptyTooltipNode.EMPTY);
    }

    public TagNode(IServerUtils ignoredUtils, TagKey<? extends ItemLike> tag, RangeValue count, ITooltipNode tooltip) {
        this.tag = tag;
        this.tooltip = tooltip;
        this.count = count;
        this.conditions = Collections.emptyList();
        this.functions = Collections.emptyList();
        this.chance = 1.0f;
    }

    public TagNode(IServerUtils utils, TagEntry entry, float chance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        this.conditions = Stream.concat(conditions.stream(), entry.f_79636_.stream()).toList();
        this.functions = Stream.concat(functions.stream(), entry.f_79677_.stream()).toList();
        this.chance = chance * (float)entry.f_79675_ / (float)sumWeight;
        this.tag = entry.f_79821_;
        this.tooltip = EntryTooltipUtils.getSingletonTooltip(utils, (LootPoolSingletonContainer)entry, chance, sumWeight, functions, conditions);
        this.count = TooltipUtils.getCount(utils, this.functions).get(null).get(0);
    }

    public TagNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        this.tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)buf.m_130281_());
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
        this.count = new RangeValue((FriendlyByteBuf)buf);
        this.chance = buf.readFloat();
        this.conditions = Collections.emptyList();
        this.functions = Collections.emptyList();
    }

    @Override
    public Either<ItemStack, TagKey<? extends ItemLike>> getModifiedItem() {
        return Either.right(this.tag);
    }

    @Override
    public List<LootItemCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public List<LootItemFunction> getFunctions() {
        return this.functions;
    }

    @Override
    @NotNull
    public RangeValue getCount() {
        return this.count;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public void encode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        buf.m_130085_(this.tag.f_203868_());
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
        this.count.encode((FriendlyByteBuf)buf);
        buf.writeFloat(this.chance);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

