/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.yanny.ali.network.AbstractClient;
import com.yanny.ali.network.AbstractServer;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.Client;
import com.yanny.ali.network.DistHolder;
import com.yanny.ali.network.DoneMessage;
import com.yanny.ali.network.Server;
import com.yanny.ali.network.SyncLootTableMessage;
import com.yanny.ali.network.SyncTradeMessage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.SimpleChannel;
import org.jetbrains.annotations.NotNull;

public class NetworkUtils {
    private static int messageId = 0;

    public static DistHolder<AbstractClient, AbstractServer> registerLootInfoPropagator(SimpleChannel channel) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return NetworkUtils.registerClientLootInfoPropagator(channel);
        }
        return NetworkUtils.registerServerLootInfoPropagator(channel);
    }

    @NotNull
    private static DistHolder<AbstractClient, AbstractServer> registerClientLootInfoPropagator(SimpleChannel channel) {
        Client client = new Client();
        Server server = new Server(channel);
        channel.messageBuilder(SyncLootTableMessage.class, NetworkUtils.getMessageId()).codec(SyncLootTableMessage.CODEC).consumerNetworkThread(client::onLootInfo).add();
        channel.messageBuilder(SyncTradeMessage.class, NetworkUtils.getMessageId()).codec(SyncTradeMessage.CODEC).consumerNetworkThread(client::onTradeInfo).add();
        channel.messageBuilder(ClearMessage.class, NetworkUtils.getMessageId()).codec(ClearMessage.CODEC).consumerNetworkThread(client::onClear).add();
        channel.messageBuilder(DoneMessage.class, NetworkUtils.getMessageId()).codec(DoneMessage.CODEC).consumerNetworkThread(client::onDone).add();
        return new DistHolder<AbstractClient, AbstractServer>(client, server);
    }

    @NotNull
    private static DistHolder<AbstractClient, AbstractServer> registerServerLootInfoPropagator(SimpleChannel channel) {
        Server server = new Server(channel);
        channel.messageBuilder(SyncLootTableMessage.class, NetworkUtils.getMessageId()).codec(SyncLootTableMessage.CODEC).add();
        channel.messageBuilder(SyncTradeMessage.class, NetworkUtils.getMessageId()).codec(SyncTradeMessage.CODEC).add();
        channel.messageBuilder(ClearMessage.class, NetworkUtils.getMessageId()).codec(ClearMessage.CODEC).add();
        channel.messageBuilder(DoneMessage.class, NetworkUtils.getMessageId()).codec(DoneMessage.CODEC).decoder(DoneMessage::new).add();
        return new DistHolder<Object, Server>(null, server);
    }

    private static int getMessageId() {
        return ++messageId;
    }
}

