/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionReference;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.EnchantmentActiveCheck;
import net.minecraft.world.level.storage.loot.predicates.EntityHasScoreCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.predicates.TimeCheck;
import net.minecraft.world.level.storage.loot.predicates.ValueCheckCondition;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ConditionTooltipUtils {
    private static final DecimalFormat FLOAT_FORMAT = new DecimalFormat("0.####");

    @NotNull
    public static ITooltipNode getAllOfTooltip(IServerUtils utils, AllOfCondition cond) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.type.condition.all_of", cond.f_285609_, utils::getConditionTooltip);
    }

    @NotNull
    public static ITooltipNode getAnyOfTooltip(IServerUtils utils, AnyOfCondition cond) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.type.condition.any_of", cond.f_285609_, utils::getConditionTooltip);
    }

    @NotNull
    public static ITooltipNode getBlockStatePropertyTooltip(IServerUtils utils, LootItemBlockStatePropertyCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.block_state_property", new Object[0]));
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.block", cond.f_81759_(), RegistriesTooltipUtils::getBlockTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.properties", cond.f_81760_(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getDamageSourcePropertiesTooltip(IServerUtils utils, DamageSourceCondition cond) {
        return GenericTooltipUtils.getOptionalTooltip(utils, "ali.type.condition.damage_source_properties", cond.f_81582_(), GenericTooltipUtils::getDamageSourcePredicateTooltip);
    }

    @NotNull
    public static ITooltipNode getEnchantActiveCheckTooltip(IServerUtils utils, EnchantmentActiveCheck cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.enchantment_active_check", new Object[0]));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.active", cond.f_336813_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEntityPropertiesTooltip(IServerUtils utils, LootItemEntityPropertyCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.entity_properties", new Object[0]));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.target", cond.f_81847_()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.predicate", cond.f_81846_(), GenericTooltipUtils::getEntityPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEntityScoresTooltip(IServerUtils utils, EntityHasScoreCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.entity_scores", new Object[0]));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.target", cond.f_81616_()));
        tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.scores", cond.f_81615_(), GenericTooltipUtils::getIntRangeEntryTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getInvertedTooltip(IServerUtils utils, InvertedLootItemCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.inverted", new Object[0]));
        tooltip.add(utils.getConditionTooltip(utils, cond.f_81681_()));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getKilledByPlayerTooltip(IServerUtils ignoredUtils, LootItemKilledByPlayerCondition ignoredCond) {
        return new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.killed_by_player", new Object[0]));
    }

    @NotNull
    public static ITooltipNode getLocationCheckTooltip(IServerUtils utils, LocationCheck cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.location_check", new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.location", cond.f_81716_(), GenericTooltipUtils::getLocationPredicateTooltip));
        if (!cond.f_81717_().equals((Object)BlockPos.f_121853_)) {
            tooltip.add(GenericTooltipUtils.getBlockPosTooltip(utils, "ali.property.multi.offset", cond.f_81717_()));
        }
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMatchToolTooltip(IServerUtils utils, MatchTool cond) {
        return GenericTooltipUtils.getOptionalTooltip(utils, "ali.type.condition.match_tool", cond.f_81993_(), GenericTooltipUtils::getItemPredicateTooltip);
    }

    @NotNull
    public static ITooltipNode getRandomChanceTooltip(IServerUtils utils, LootItemRandomChanceCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.random_chance", new Object[0]), true);
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.chance", cond.f_337409_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getRandomChanceWithEnchantedBonusTooltip(IServerUtils utils, LootItemRandomChanceWithEnchantedBonusCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.random_chance_with_enchanted_bonus", new Object[0]), true);
        tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.unenchanted_chance", Float.valueOf(cond.f_336942_())));
        tooltip.add(GenericTooltipUtils.getLevelBasedValueTooltip(utils, "ali.property.branch.enchanted_chance", cond.f_336885_()));
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.enchantment", cond.f_337283_(), RegistriesTooltipUtils::getEnchantmentTooltip));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getReferenceTooltip(IServerUtils utils, ConditionReference cond) {
        return GenericTooltipUtils.getResourceKeyTooltip(utils, "ali.type.condition.reference", cond.f_81550_());
    }

    public static @Unmodifiable @NotNull ITooltipNode getSurvivesExplosionTooltip(IServerUtils ignoredUtils, ExplosionCondition ignoredCond) {
        return new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.survives_explosion", new Object[0]));
    }

    @NotNull
    public static ITooltipNode getTableBonusTooltip(IServerUtils utils, BonusLevelTableCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.table_bonus", new Object[0]), true);
        List<String> list = cond.f_81508_().stream().mapToDouble(aFloat -> aFloat.floatValue()).mapToObj(FLOAT_FORMAT::format).toList();
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.enchantment", cond.f_81507_(), RegistriesTooltipUtils::getEnchantmentTooltip));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.values", list.toString()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getTimeCheckTooltip(IServerUtils utils, TimeCheck cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.time_check", new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.period", cond.f_82023_(), GenericTooltipUtils::getLongTooltip));
        tooltip.add(GenericTooltipUtils.getIntRangeTooltip(utils, "ali.property.value.value", cond.f_82024_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getValueCheckTooltip(IServerUtils utils, ValueCheckCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.value_check", new Object[0]));
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.provider", cond.f_165520_()));
        tooltip.add(GenericTooltipUtils.getIntRangeTooltip(utils, "ali.property.value.range", cond.f_165521_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getWeatherCheckTooltip(IServerUtils utils, WeatherCheck cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.weather_check", new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_raining", cond.f_82056_(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_thundering", cond.f_82057_(), GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }
}

