/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.CollectionContentsPredicate;
import net.minecraft.advancements.critereon.CollectionCountsPredicate;
import net.minecraft.advancements.critereon.CollectionPredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.GameTypePredicate;
import net.minecraft.advancements.critereon.ItemAttributeModifiersPredicate;
import net.minecraft.advancements.critereon.ItemFireworkExplosionPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemWritableBookPredicate;
import net.minecraft.advancements.critereon.ItemWrittenBookPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.MovementPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.SlotsPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.Filterable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.SlotRange;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.storage.loot.ContainerComponentManipulator;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyCustomDataFunction;
import net.minecraft.world.level.storage.loot.functions.ListOperation;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.functions.SetStewEffectFunction;
import net.minecraft.world.level.storage.loot.functions.ToggleTooltips;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class GenericTooltipUtils {
    private static final ChatFormatting TEXT_STYLE = ChatFormatting.GOLD;
    private static final ChatFormatting PARAM_STYLE = ChatFormatting.AQUA;

    public static @Unmodifiable @NotNull ITooltipNode getMissingFunction(IServerUtils utils, LootItemFunction function) {
        return RegistriesTooltipUtils.getFunctionTypeTooltip(utils, "ali.util.advanced_loot_info.missing", function.m_7162_());
    }

    public static @Unmodifiable @NotNull ITooltipNode getMissingCondition(IServerUtils utils, LootItemCondition condition) {
        return RegistriesTooltipUtils.getConditionTypeTooltip(utils, "ali.util.advanced_loot_info.missing", condition.m_7940_());
    }

    @NotNull
    public static List<ITooltipNode> getConditionListTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        return conditions.stream().map(condition -> utils.getConditionTooltip(utils, condition)).toList();
    }

    @NotNull
    public static List<ITooltipNode> getConditionsTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        if (!conditions.isEmpty()) {
            ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.util.advanced_loot_info.delimiter.conditions", new Object[0])));
            tooltip.addAll(GenericTooltipUtils.getConditionListTooltip(utils, conditions));
            return tooltip;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static ITooltipNode getSubConditionsTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        if (!conditions.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.property.branch.conditions", new Object[0]));
            for (ITooltipNode node : GenericTooltipUtils.getConditionListTooltip(utils, conditions)) {
                tooltip.add(node);
            }
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static List<ITooltipNode> getFunctionListTooltip(IServerUtils utils, List<LootItemFunction> functions) {
        return functions.stream().map(function -> utils.getFunctionTooltip(utils, function)).toList();
    }

    @NotNull
    public static List<ITooltipNode> getFunctionsTooltip(IServerUtils utils, List<LootItemFunction> functions) {
        if (!functions.isEmpty()) {
            ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.util.advanced_loot_info.delimiter.functions", new Object[0])));
            tooltip.addAll(GenericTooltipUtils.getFunctionListTooltip(utils, functions));
            return tooltip;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Unmodifiable @NotNull ITooltipNode getFormulaTooltip(IServerUtils utils, String key, ApplyBonusCount.Formula formula) {
        ITooltipNode tooltip = GenericTooltipUtils.getResourceLocationTooltip(utils, key, formula.m_5713_().f_291058_());
        if (formula instanceof ApplyBonusCount.BinomialWithBonusCount) {
            ApplyBonusCount.BinomialWithBonusCount binomialWithBonusCount = (ApplyBonusCount.BinomialWithBonusCount)formula;
            try {
                float f;
                int n;
                int extraRounds = n = binomialWithBonusCount.f_79948_();
                float probability = f = binomialWithBonusCount.f_79949_();
                tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.extra_rounds", extraRounds));
                tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.probability", Float.valueOf(probability)));
                return tooltip;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (!(formula instanceof ApplyBonusCount.UniformBonusCount)) return tooltip;
        ApplyBonusCount.UniformBonusCount uniformBonusCount = (ApplyBonusCount.UniformBonusCount)formula;
        {
            int n;
            int bonusMultiplier = n = uniformBonusCount.f_80013_();
            tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.bonus_multiplier", bonusMultiplier));
        }
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getPropertyTooltip(IServerUtils utils, String key, net.minecraft.world.level.block.state.properties.Property<?> property) {
        return GenericTooltipUtils.getStringTooltip(utils, key, property.m_61708_());
    }

    @NotNull
    public static ITooltipNode getModifierTooltip(IServerUtils utils, String key, SetAttributesFunction.Modifier modifier) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.attribute", modifier.f_80848_(), RegistriesTooltipUtils::getAttributeTooltip));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.operation", modifier.f_80849_()));
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.amount", modifier.f_80850_()));
        tooltip.add(GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.property.value.id", modifier.f_80851_()));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.equipment_slots", "ali.property.value.null", modifier.f_80852_(), GenericTooltipUtils::getEnumTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getUUIDTooltip(IServerUtils utils, String key, UUID uuid) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(uuid)));
    }

    @NotNull
    public static ITooltipNode getBannerPatternLayersTooltip(IServerUtils utils, String key, BannerPatternLayers bannerPatternLayers) {
        return GenericTooltipUtils.getCollectionTooltip(utils, key, "ali.property.value.null", bannerPatternLayers.f_315710_(), GenericTooltipUtils::getBannerPatternLayerTooltip);
    }

    @NotNull
    public static ITooltipNode getBannerPatternLayerTooltip(IServerUtils utils, String key, BannerPatternLayers.Layer layer) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, key, layer.f_316420_(), RegistriesTooltipUtils::getBannerPatternTooltip);
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.color", layer.f_316009_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getStatePropertiesPredicateTooltip(IServerUtils utils, String key, StatePropertiesPredicate propertiesPredicate) {
        return GenericTooltipUtils.getCollectionTooltip(utils, key, propertiesPredicate.f_67659_(), GenericTooltipUtils::getPropertyMatcherTooltip);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static ITooltipNode getPropertyMatcherTooltip(IServerUtils ignoredUtils, StatePropertiesPredicate.PropertyMatcher propertyMatcher) {
        Optional min;
        Optional optional;
        StatePropertiesPredicate.ExactMatcher exactMatcher;
        String name = propertyMatcher.f_67715_();
        StatePropertiesPredicate.ValueMatcher valueMatcher = propertyMatcher.f_291902_();
        if (valueMatcher instanceof StatePropertiesPredicate.ExactMatcher) {
            String string;
            exactMatcher = (StatePropertiesPredicate.ExactMatcher)valueMatcher;
            String value = string = exactMatcher.f_290506_();
            return new TooltipNode(GenericTooltipUtils.keyValue(name, value));
        }
        StatePropertiesPredicate.ValueMatcher valueMatcher2 = propertyMatcher.f_291902_();
        if (!(valueMatcher2 instanceof StatePropertiesPredicate.RangedMatcher)) return new TooltipNode();
        exactMatcher = (StatePropertiesPredicate.RangedMatcher)valueMatcher2;
        try {
            min = optional = exactMatcher.f_291542_();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Optional max = optional = exactMatcher.f_291806_();
        return min.map(s -> max.map(string -> new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_both", name, s, string)))).orElseGet(() -> new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_gte", name, s))))).orElseGet(() -> max.map(string -> new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_lte", name, string)))).orElseGet(() -> new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_any", name)))));
    }

    @NotNull
    public static ITooltipNode getDamageSourcePredicateTooltip(IServerUtils utils, String key, DamageSourcePredicate damagePredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.tags", "ali.property.value.null", damagePredicate.f_268608_(), GenericTooltipUtils::getTagPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.direct_entity", damagePredicate.f_25429_(), GenericTooltipUtils::getEntityPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.source_entity", damagePredicate.f_25430_(), GenericTooltipUtils::getEntityPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_direct", damagePredicate.f_337324_(), GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }

    public static <T> @Unmodifiable @NotNull ITooltipNode getTagPredicateTooltip(IServerUtils utils, String key, TagPredicate<T> tagPredicate) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.keyValue(tagPredicate.f_268479_().f_203868_().toString(), tagPredicate.f_268414_())));
    }

    @NotNull
    public static ITooltipNode getEntityPredicateTooltip(IServerUtils utils, String key, EntityPredicate entityPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.entity_types", entityPredicate.f_36551_(), GenericTooltipUtils::getEntityTypePredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.distance_to_player", entityPredicate.f_36552_(), GenericTooltipUtils::getDistancePredicateTooltip));
        tooltip.add(GenericTooltipUtils.getLocationWrapperTooltip(utils, "ali.property.branch.location", entityPredicate.f_36553_()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.movement", entityPredicate.f_336844_(), GenericTooltipUtils::getMovementPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.periodic_tick", entityPredicate.f_337247_(), GenericTooltipUtils::getIntegerTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.mob_effects", entityPredicate.f_36554_(), GenericTooltipUtils::getMobEffectPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.nbt", entityPredicate.f_36555_(), GenericTooltipUtils::getNbtPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.entity_flags", entityPredicate.f_36556_(), GenericTooltipUtils::getEntityFlagsPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.entity_equipment", entityPredicate.f_36557_(), GenericTooltipUtils::getEntityEquipmentPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.entity_sub_predicate", entityPredicate.f_218773_(), GenericTooltipUtils::getEntitySubPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.vehicle", entityPredicate.f_36560_(), GenericTooltipUtils::getEntityPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.passenger", entityPredicate.f_150287_(), GenericTooltipUtils::getEntityPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.targeted_entity", entityPredicate.f_36561_(), GenericTooltipUtils::getEntityPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.team", entityPredicate.f_36562_(), GenericTooltipUtils::getStringTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.slots", entityPredicate.f_315910_(), GenericTooltipUtils::getSlotPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEntityTypePredicateTooltip(IServerUtils utils, String key, EntityTypePredicate entityTypePredicate) {
        return GenericTooltipUtils.getHolderSetTooltip(utils, key, "ali.property.value.null", entityTypePredicate.f_290696_(), RegistriesTooltipUtils::getEntityTypeTooltip);
    }

    @NotNull
    public static ITooltipNode getDistancePredicateTooltip(IServerUtils utils, String key, DistancePredicate distancePredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.x", distancePredicate.f_26242_()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.y", distancePredicate.f_26243_()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.z", distancePredicate.f_26244_()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.horizontal", distancePredicate.f_26245_()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.absolute", distancePredicate.f_26246_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getLocationPredicateTooltip(IServerUtils utils, String key, LocationPredicate locationPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.position", locationPredicate.f_290578_(), GenericTooltipUtils::getPositionPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, "ali.property.branch.biomes", "ali.property.value.null", locationPredicate.f_314588_(), RegistriesTooltipUtils::getBiomeTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, "ali.property.branch.structures", "ali.property.value.null", locationPredicate.f_316568_(), RegistriesTooltipUtils::getStructureTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.dimension", locationPredicate.f_52599_(), GenericTooltipUtils::getResourceKeyTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.smokey", locationPredicate.f_52600_(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.light", locationPredicate.f_52601_(), GenericTooltipUtils::getLightPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.block_predicate", locationPredicate.f_52602_(), GenericTooltipUtils::getBlockPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.fluid_predicate", locationPredicate.f_52603_(), GenericTooltipUtils::getFluidPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.can_see_sky", locationPredicate.f_336725_(), GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getPositionPredicateTooltip(IServerUtils utils, String key, LocationPredicate.PositionPredicate positionPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.x", positionPredicate.f_291501_()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.y", positionPredicate.f_291292_()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.z", positionPredicate.f_290699_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getLightPredicateTooltip(IServerUtils utils, String key, LightPredicate lightPredicate) {
        return GenericTooltipUtils.getMinMaxBoundsTooltip(utils, key, lightPredicate.f_51336_());
    }

    @NotNull
    public static ITooltipNode getBlockPredicateTooltip(IServerUtils utils, String key, BlockPredicate blockPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, "ali.property.branch.blocks", "ali.property.value.null", blockPredicate.f_146710_(), RegistriesTooltipUtils::getBlockTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.properties", blockPredicate.f_17905_(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.nbt", blockPredicate.f_17906_(), GenericTooltipUtils::getNbtPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getNbtPredicateTooltip(IServerUtils utils, String key, NbtPredicate nbtPredicate) {
        return GenericTooltipUtils.getCompoundTagTooltip(utils, key, nbtPredicate.f_57472_());
    }

    @NotNull
    public static ITooltipNode getFluidPredicateTooltip(IServerUtils utils, String key, FluidPredicate fluidPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, "ali.property.branch.fluids", "ali.property.value.null", fluidPredicate.f_315771_(), RegistriesTooltipUtils::getFluidTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.properties", fluidPredicate.f_41097_(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMobEffectPredicateTooltip(IServerUtils utils, String key, MobEffectsPredicate mobEffectsPredicate) {
        return GenericTooltipUtils.getMapTooltip(utils, key, mobEffectsPredicate.f_290320_(), GenericTooltipUtils::getMobEffectPredicateEntryTooltip);
    }

    @NotNull
    public static ITooltipNode getEntityFlagsPredicateTooltip(IServerUtils utils, String key, EntityFlagsPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_on_ground", predicate.f_337406_(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_on_fire", predicate.f_33683_(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_baby", predicate.f_33687_(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_crouching", predicate.f_33684_(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_sprinting", predicate.f_33685_(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_swimming", predicate.f_33686_(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_flying", predicate.f_336930_(), GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEntityEquipmentPredicateTooltip(IServerUtils utils, String key, EntityEquipmentPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.head", predicate.f_32178_(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.chest", predicate.f_32179_(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.legs", predicate.f_32180_(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.feet", predicate.f_32181_(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.body", predicate.f_314360_(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.mainhand", predicate.f_32182_(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.offhand", predicate.f_32183_(), GenericTooltipUtils::getItemPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getItemPredicateTooltip(IServerUtils utils, String key, ItemPredicate itemPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, "ali.property.branch.items", "ali.property.value.null", itemPredicate.f_151427_(), RegistriesTooltipUtils::getItemTooltip));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.count", itemPredicate.f_45031_()));
        tooltip.add(GenericTooltipUtils.getDataComponentPredicateTooltip(utils, "ali.property.branch.components", itemPredicate.f_316810_()));
        tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.item_predicates", itemPredicate.f_315090_(), GenericTooltipUtils::getItemSubPredicateEntryTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEnchantmentPredicateTooltip(IServerUtils utils, String key, EnchantmentPredicate enchantmentPredicate) {
        ITooltipNode tooltip = enchantmentPredicate.f_337714_().isPresent() ? GenericTooltipUtils.getHolderSetTooltip(utils, key, "ali.property.value.null", (HolderSet)enchantmentPredicate.f_337714_().get(), RegistriesTooltipUtils::getEnchantmentTooltip) : new TooltipNode();
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.level", enchantmentPredicate.f_30467_()));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getGameTypePredicateTooltip(IServerUtils utils, String key, GameTypePredicate gameType) {
        return GenericTooltipUtils.getCollectionTooltip(utils, key, "ali.property.value.null", gameType.f_337709_(), GenericTooltipUtils::getEnumTooltip);
    }

    @NotNull
    public static ITooltipNode getStatMatcherTooltip(IServerUtils utils, PlayerPredicate.StatMatcher<?> stat) {
        ITooltipNode tooltip;
        Holder value = stat.f_291891_();
        Object object = value.m_203334_();
        if (object instanceof Item) {
            Item item = (Item)object;
            tooltip = RegistriesTooltipUtils.getItemTooltip(utils, "ali.property.value.item", item);
            tooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(stat.f_290937_().m_12905_(), GenericTooltipUtils.toString(stat.f_291204_()))));
        } else {
            object = value.m_203334_();
            if (object instanceof Block) {
                Block block = (Block)object;
                tooltip = RegistriesTooltipUtils.getBlockTooltip(utils, "ali.property.value.block", block);
                tooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(stat.f_290937_().m_12905_(), GenericTooltipUtils.toString(stat.f_291204_()))));
            } else {
                object = value.m_203334_();
                if (object instanceof EntityType) {
                    EntityType entityType = (EntityType)object;
                    tooltip = RegistriesTooltipUtils.getEntityTypeTooltip(utils, "ali.property.value.entity_type", entityType);
                    tooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(stat.f_290937_().m_12905_(), GenericTooltipUtils.toString(stat.f_291204_()))));
                } else {
                    object = value.m_203334_();
                    if (object instanceof ResourceLocation) {
                        ResourceLocation resourceLocation = (ResourceLocation)object;
                        tooltip = GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.property.value.id", resourceLocation);
                        tooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(GenericTooltipUtils.translatable(GenericTooltipUtils.getTranslationKey(resourceLocation), new Object[0]), GenericTooltipUtils.toString(stat.f_291204_()))));
                    } else {
                        tooltip = new TooltipNode();
                    }
                }
            }
        }
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getBlockPosTooltip(IServerUtils ignoredUtils, String key, BlockPos pos) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(pos.m_123341_()), GenericTooltipUtils.value(pos.m_123342_()), GenericTooltipUtils.value(pos.m_123343_())));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static ITooltipNode getListOperationTooltip(IServerUtils utils, String key, ListOperation operation) {
        ITooltipNode tooltip = GenericTooltipUtils.getEnumTooltip(utils, key, operation.m_320900_());
        if (operation instanceof ListOperation.Insert) {
            ListOperation.Insert insert = (ListOperation.Insert)operation;
            try {
                int n;
                int offset = n = insert.f_315739_();
                tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.offset", offset));
                return tooltip;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (!(operation instanceof ListOperation.ReplaceSection)) return tooltip;
        ListOperation.ReplaceSection replaceSection = (ListOperation.ReplaceSection)operation;
        {
            Optional optional;
            int n;
            int offset = n = replaceSection.f_316975_();
            Optional size = optional = replaceSection.f_317088_();
            tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.offset", offset));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.size", size, GenericTooltipUtils::getIntegerTooltip));
        }
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getContainerComponentManipulatorTooltip(IServerUtils utils, String key, ContainerComponentManipulator<?> component) {
        return RegistriesTooltipUtils.getDataComponentTypeTooltip(utils, key, component.m_319799_());
    }

    @NotNull
    public static ITooltipNode getCopyOperationTooltip(IServerUtils utils, String key, CopyCustomDataFunction.CopyOperation copyOperation) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getNbtPathTooltip(utils, "ali.property.value.source_path", copyOperation.f_316253_()));
        tooltip.add(GenericTooltipUtils.getNbtPathTooltip(utils, "ali.property.value.target_path", copyOperation.f_315689_()));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.merge_strategy", copyOperation.f_314952_()));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getNbtPathTooltip(IServerUtils utils, String key, NbtPathArgument.NbtPath provider) {
        return GenericTooltipUtils.getStringTooltip(utils, key, provider.m_306879_());
    }

    @NotNull
    public static ITooltipNode getDataComponentPredicateTooltip(IServerUtils utils, String key, DataComponentPredicate dataComponentPredicate) {
        if (dataComponentPredicate != DataComponentPredicate.f_314891_) {
            return GenericTooltipUtils.getCollectionTooltip(utils, key, "ali.property.value.null", dataComponentPredicate.f_316555_, GenericTooltipUtils::getTypedDataComponentTooltip);
        }
        return new TooltipNode();
    }

    public static @Unmodifiable @NotNull ITooltipNode getTypedDataComponentTooltip(IServerUtils utils, String key, TypedDataComponent<?> typedDataComponent) {
        ITooltipNode tooltip = RegistriesTooltipUtils.getDataComponentTypeTooltip(utils, key, typedDataComponent.f_316611_());
        tooltip.add(utils.getDataComponentTypeTooltip(utils, typedDataComponent.f_316611_(), typedDataComponent.f_314804_()));
        return tooltip;
    }

    @NotNull
    public static <A, B extends Predicate<A>> ITooltipNode getCollectionPredicateTooltip(IServerUtils utils, String key, String value, Optional<CollectionPredicate<A, B>> optional, TriFunction<IServerUtils, String, B, ITooltipNode> subPredicate) {
        if (optional.isPresent()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            CollectionPredicate<A, B> predicate = optional.get();
            tooltip.add(GenericTooltipUtils.getCollectionContentsPredicateTooltip(utils, "ali.property.branch.contains", value, predicate.f_315792_(), subPredicate));
            tooltip.add(GenericTooltipUtils.getCollectionCountsPredicateTooltip(utils, "ali.property.branch.counts", value, predicate.f_314648_(), (u1, v1, s1) -> {
                ITooltipNode comps = (ITooltipNode)subPredicate.apply(u1, v1, (Object)s1.f_313895_());
                comps.add(GenericTooltipUtils.getMinMaxBoundsTooltip(u1, "ali.property.value.count", s1.f_315065_()));
                return comps;
            }));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.size", predicate.f_316667_(), GenericTooltipUtils::getMinMaxBoundsTooltip));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <A, B extends Predicate<A>> ITooltipNode getCollectionContentsPredicateTooltip(IServerUtils utils, String key, String value, Optional<CollectionContentsPredicate<A, B>> predicate, TriFunction<IServerUtils, String, B, ITooltipNode> mapper) {
        return predicate.map(p -> GenericTooltipUtils.getCollectionTooltip(utils, key, value, p.m_319415_(), mapper)).orElse(new TooltipNode());
    }

    @NotNull
    public static <A, B extends Predicate<A>> ITooltipNode getCollectionCountsPredicateTooltip(IServerUtils utils, String key, String value, Optional<CollectionCountsPredicate<A, B>> predicate, TriFunction<IServerUtils, String, CollectionCountsPredicate.Entry<A, B>, ITooltipNode> mapper) {
        return predicate.map(p -> GenericTooltipUtils.getCollectionTooltip(utils, key, value, p.m_319753_(), mapper)).orElse(new TooltipNode());
    }

    @NotNull
    public static ITooltipNode getFireworkPredicateTooltip(IServerUtils utils, String key, ItemFireworkExplosionPredicate.FireworkPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.shape", predicate.f_315216_(), GenericTooltipUtils::getEnumTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.trail", predicate.f_316972_(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.twinkle", predicate.f_315735_(), GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getPagePredicateTooltip(IServerUtils ignoredUtils, String key, ItemWritableBookPredicate.PagePredicate predicate) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(predicate.f_316074_())));
    }

    public static @Unmodifiable @NotNull ITooltipNode getPagePredicateTooltip(IServerUtils ignoredUtils, String key, ItemWrittenBookPredicate.PagePredicate predicate) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(predicate.f_316602_())));
    }

    @NotNull
    public static ITooltipNode getEntryPredicateTooltip(IServerUtils utils, String key, ItemAttributeModifiersPredicate.EntryPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, "ali.property.branch.attributes", "ali.property.value.null", predicate.f_315176_(), RegistriesTooltipUtils::getAttributeTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.id", predicate.f_315360_(), GenericTooltipUtils::getResourceLocationTooltip));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.amount", predicate.f_316857_()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.operation", predicate.f_315016_(), GenericTooltipUtils::getEnumTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.slot", predicate.f_314217_(), GenericTooltipUtils::getEnumTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getDataComponentPatchTooltip(IServerUtils utils, String key, DataComponentPatch data) {
        return GenericTooltipUtils.getMapTooltip(utils, key, data.f_314958_, GenericTooltipUtils::getDataComponentPatchEntryTooltip);
    }

    @NotNull
    public static ITooltipNode getFireworkExplosionTooltip(IServerUtils utils, String key, FireworkExplosion data) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.shape", data.f_316547_()));
        tooltip.add(GenericTooltipUtils.getIntListTooltip(utils, "ali.property.value.colors", data.f_316201_()));
        tooltip.add(GenericTooltipUtils.getIntListTooltip(utils, "ali.property.value.fade_colors", data.f_314743_()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.has_trail", data.f_316522_()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.has_twinkle", data.f_316285_()));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getIntListTooltip(IServerUtils utils, String key, IntList data) {
        return GenericTooltipUtils.getStringTooltip(utils, key, data.toString());
    }

    @NotNull
    public static <T> ITooltipNode getFilterableTooltip(IServerUtils utils, String key, Filterable<T> data, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add((ITooltipNode)mapper.apply((Object)utils, (Object)"ali.property.value.raw", data.f_315590_()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.filtered", data.f_316433_(), mapper));
        return tooltip;
    }

    @NotNull
    public static <T> ITooltipNode getFilterableTooltip(IServerUtils utils, String key, Optional<Filterable<T>> data, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        if (data.isPresent()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            Filterable<T> d = data.get();
            tooltip.add((ITooltipNode)mapper.apply((Object)utils, (Object)"ali.property.value.raw", d.f_315590_()));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.filtered", d.f_316433_(), mapper));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <T> ITooltipNode getFilterableTooltip(IServerUtils utils, String key, String value, Collection<Filterable<T>> data, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        TooltipNode tooltips = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        for (Filterable<T> d : data) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(value, new Object[0]));
            tooltip.add((ITooltipNode)mapper.apply((Object)utils, (Object)"ali.property.value.raw", d.f_315590_()));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.filtered", d.f_316433_(), mapper));
            tooltips.add(tooltip);
        }
        return tooltips;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static ITooltipNode getLevelBasedValueTooltip(IServerUtils utils, String key, LevelBasedValue levelBasedValue) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        LevelBasedValue levelBasedValue2 = levelBasedValue;
        Objects.requireNonNull(levelBasedValue2);
        LevelBasedValue levelBasedValue3 = levelBasedValue2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LevelBasedValue.Constant.class, LevelBasedValue.Clamped.class, LevelBasedValue.Fraction.class, LevelBasedValue.Linear.class, LevelBasedValue.LevelsSquared.class, LevelBasedValue.Lookup.class}, (Object)levelBasedValue3, n)) {
            case 0: {
                LevelBasedValue.Constant constant = (LevelBasedValue.Constant)levelBasedValue3;
                try {
                    float f;
                    float value = f = constant.f_336981_();
                    tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.constant", Float.valueOf(value)));
                    return tooltip;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                LevelBasedValue.Clamped clamped = (LevelBasedValue.Clamped)levelBasedValue3;
                {
                    float f;
                    LevelBasedValue levelBasedValue4;
                    LevelBasedValue value = levelBasedValue4 = clamped.f_336702_();
                    float min = f = clamped.f_336751_();
                    float max = f = clamped.f_337031_();
                    TooltipNode t = new TooltipNode(GenericTooltipUtils.translatable("ali.property.branch.clamped", new Object[0]));
                    t.add(GenericTooltipUtils.getLevelBasedValueTooltip(utils, "ali.property.branch.value", value));
                    t.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.min", Float.valueOf(min)));
                    t.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.max", Float.valueOf(max)));
                    tooltip.add(t);
                    return tooltip;
                }
            }
            case 2: {
                LevelBasedValue.Fraction fraction = (LevelBasedValue.Fraction)levelBasedValue3;
                {
                    LevelBasedValue levelBasedValue5;
                    LevelBasedValue numerator = levelBasedValue5 = fraction.f_337089_();
                    LevelBasedValue denominator = levelBasedValue5 = fraction.f_337310_();
                    TooltipNode t = new TooltipNode(GenericTooltipUtils.translatable("ali.property.branch.fraction", new Object[0]));
                    t.add(GenericTooltipUtils.getLevelBasedValueTooltip(utils, "ali.property.branch.numerator", numerator));
                    t.add(GenericTooltipUtils.getLevelBasedValueTooltip(utils, "ali.property.branch.denominator", denominator));
                    tooltip.add(t);
                    return tooltip;
                }
            }
            case 3: {
                LevelBasedValue.Linear linear = (LevelBasedValue.Linear)levelBasedValue3;
                {
                    float f;
                    float base = f = linear.f_337076_();
                    float perLevelAboveFirst = f = linear.f_336969_();
                    TooltipNode t = new TooltipNode(GenericTooltipUtils.translatable("ali.property.branch.linear", new Object[0]));
                    t.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.base", Float.valueOf(base)));
                    t.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.per_level", Float.valueOf(perLevelAboveFirst)));
                    tooltip.add(t);
                    return tooltip;
                }
            }
            case 4: {
                LevelBasedValue.LevelsSquared levelsSquared = (LevelBasedValue.LevelsSquared)levelBasedValue3;
                {
                    float f;
                    float added = f = levelsSquared.f_337001_();
                    TooltipNode t = new TooltipNode(GenericTooltipUtils.translatable("ali.property.branch.level_squared", new Object[0]));
                    t.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.added", Float.valueOf(added)));
                    tooltip.add(t);
                    return tooltip;
                }
            }
            case 5: {
                LevelBasedValue.Lookup lookup = (LevelBasedValue.Lookup)levelBasedValue3;
                {
                    List list;
                    List values = list = lookup.f_337520_();
                    List fallback = list = lookup.f_337128_();
                    TooltipNode t = new TooltipNode(GenericTooltipUtils.translatable("ali.property.branch.lookup", new Object[0]));
                    t.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.values", values.toString()));
                    t.add(GenericTooltipUtils.getLevelBasedValueTooltip(utils, "ali.property.branch.fallback", (LevelBasedValue)fallback));
                    tooltip.add(t);
                    return tooltip;
                }
            }
        }
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getLocationWrapperTooltip(IServerUtils utils, String key, EntityPredicate.LocationWrapper locationWrapper) {
        if (locationWrapper.f_337136_().isPresent() || locationWrapper.f_337291_().isPresent() || locationWrapper.f_337432_().isPresent()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.located", locationWrapper.f_337136_(), GenericTooltipUtils::getLocationPredicateTooltip));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.stepping_on_location", locationWrapper.f_337432_(), GenericTooltipUtils::getLocationPredicateTooltip));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.affects_movement", locationWrapper.f_337291_(), GenericTooltipUtils::getLocationPredicateTooltip));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getMovementPredicateTooltip(IServerUtils utils, String key, MovementPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.x", predicate.f_337025_()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.y", predicate.f_337404_()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.z", predicate.f_337000_()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.speed", predicate.f_336675_()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.horizontal_speed", predicate.f_337632_()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.vertical_speed", predicate.f_336606_()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.fall_distance", predicate.f_336746_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getItemAttributeModifiersEntryTooltip(IServerUtils utils, String key, ItemAttributeModifiers.Entry entry) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.attribute", entry.f_316116_(), RegistriesTooltipUtils::getAttributeTooltip));
        tooltip.add(GenericTooltipUtils.getAttributeModifierTooltip(utils, "ali.property.branch.modifier", entry.f_316263_()));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.slot", entry.f_317045_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getAttributeModifierTooltip(IServerUtils utils, String key, AttributeModifier modifier) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.property.value.id", modifier.f_22193_()));
        tooltip.add(GenericTooltipUtils.getDoubleTooltip(utils, "ali.property.value.amount", modifier.f_22190_()));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.operation", modifier.f_22191_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getPossibleEffectTooltip(IServerUtils utils, String key, FoodProperties.PossibleEffect effect) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getMobEffectInstanceTooltip(utils, "ali.property.value.effect", effect.m_319029_()));
        tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.probability", Float.valueOf(effect.f_314917_())));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMobEffectInstanceTooltip(IServerUtils utils, String key, MobEffectInstance effect) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, key, effect.m_19544_(), RegistriesTooltipUtils::getMobEffectTooltip);
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.duration", effect.m_19557_()));
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.amplifier", effect.m_19564_()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.ambient", effect.m_19571_()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.is_visible", effect.m_19572_()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.show_icon", effect.m_19575_()));
        if (effect.f_19510_ != null) {
            tooltip.add(GenericTooltipUtils.getMobEffectInstanceTooltip(utils, "ali.property.value.hidden_effect", effect.f_19510_));
        }
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getRuleTooltip(IServerUtils utils, String key, Tool.Rule rule) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getHolderSetTooltip(utils, "ali.property.branch.blocks", "ali.property.value.null", rule.f_316953_(), RegistriesTooltipUtils::getBlockTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.correct_for_drops", rule.f_315140_(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.speed", rule.f_314550_(), GenericTooltipUtils::getFloatTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMapDecorationEntryTooltip(IServerUtils utils, String key, MapDecorations.Entry entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, key, entry.f_315480_(), RegistriesTooltipUtils::getMapDecorationTypeTooltip);
        tooltip.add(GenericTooltipUtils.getDoubleTooltip(utils, "ali.property.value.x", entry.f_316470_()));
        tooltip.add(GenericTooltipUtils.getDoubleTooltip(utils, "ali.property.value.z", entry.f_314992_()));
        tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.rotation", Float.valueOf(entry.f_315365_())));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getItemStackTooltip(IServerUtils utils, String key, ItemStack item) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(RegistriesTooltipUtils.getItemTooltip(utils, "ali.property.value.item", item.m_41720_()));
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.count", item.m_41613_()));
        tooltip.add(GenericTooltipUtils.getDataComponentMapTooltip(utils, "ali.property.branch.components", item.m_318732_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getDataComponentMapTooltip(IServerUtils utils, String key, DataComponentMap map) {
        if (!map.m_323714_()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            map.forEach(action -> {
                ITooltipNode t = RegistriesTooltipUtils.getDataComponentTypeTooltip(utils, "ali.property.value.null", action.f_316611_());
                t.add(utils.getDataComponentTypeTooltip(utils, action.f_316611_(), action.f_314804_()));
                tooltip.add(t);
            });
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getSuspiciousStewEffectEntryTooltip(IServerUtils utils, SuspiciousStewEffects.Entry entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.null", entry.f_315280_(), RegistriesTooltipUtils::getMobEffectTooltip);
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.duration", entry.f_316640_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getGlobalPosTooltip(IServerUtils utils, String key, GlobalPos globalPos) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getResourceKeyTooltip(utils, "ali.property.value.dimension", globalPos.f_122634_()));
        tooltip.add(GenericTooltipUtils.getBlockPosTooltip(utils, "ali.property.multi.position", globalPos.f_122635_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getBeehiveBlockEntityOccupantTooltip(IServerUtils utils, String key, BeehiveBlockEntity.Occupant occupant) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.entity_data", occupant.f_316778_().m_323330_().m_7916_()));
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.ticks_in_hive", occupant.f_314644_()));
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.min_ticks_in_hive", occupant.f_314650_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEffectEntryTooltip(IServerUtils utils, String key, SetStewEffectFunction.EffectEntry entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, key, entry.f_291245_(), RegistriesTooltipUtils::getMobEffectTooltip);
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.duration", entry.f_290866_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getAuthPropertyTooltip(IServerUtils utils, Property property) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.name", property.name()));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.value", property.value()));
        if (property.signature() != null) {
            tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.signature", property.signature()));
        }
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getCompoundTagTooltip(IServerUtils ignoredUtils, String key, CompoundTag tag) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(tag.toString())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static ITooltipNode getAdvancementPredicateTooltip(IServerUtils utils, String key, PlayerPredicate.AdvancementPredicate predicate) {
        Object2BooleanMap criterions;
        if (predicate instanceof PlayerPredicate.AdvancementDonePredicate) {
            boolean bl;
            PlayerPredicate.AdvancementDonePredicate advancementDonePredicate = (PlayerPredicate.AdvancementDonePredicate)predicate;
            boolean state = bl = advancementDonePredicate.f_62299_();
            return new TooltipNode(GenericTooltipUtils.translatable(key, state));
        }
        if (!(predicate instanceof PlayerPredicate.AdvancementCriterionsPredicate)) return new TooltipNode();
        PlayerPredicate.AdvancementCriterionsPredicate advancementCriterionsPredicate = (PlayerPredicate.AdvancementCriterionsPredicate)predicate;
        try {
            Object2BooleanMap object2BooleanMap;
            criterions = object2BooleanMap = advancementCriterionsPredicate.f_62291_();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return GenericTooltipUtils.getMapTooltip(utils, criterions, GenericTooltipUtils::getCriterionEntryTooltip);
    }

    public static <T> @Unmodifiable @NotNull ITooltipNode getStandaloneTooltip(IServerUtils utils, String key, String value, Optional<ListOperation.StandAlone<T>> standalone, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        if (standalone.isPresent()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            ListOperation.StandAlone<T> s = standalone.get();
            tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.values", value, s.f_316147_(), mapper));
            tooltip.add(GenericTooltipUtils.getListOperationTooltip(utils, "ali.property.value.list_operation", s.f_317032_()));
            return tooltip;
        }
        return new TooltipNode();
    }

    public static @Unmodifiable @NotNull ITooltipNode getEntitySubPredicateTooltip(IServerUtils utils, String key, EntitySubPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(utils.getEntitySubPredicateTooltip(utils, predicate));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSlotPredicateTooltip(IServerUtils utils, String key, SlotsPredicate predicate) {
        return GenericTooltipUtils.getMapTooltip(utils, key, predicate.f_316411_(), GenericTooltipUtils::getSlotRangePredicateEntryTooltip);
    }

    @NotNull
    public static Component translatable(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])Arrays.stream(args).map(GenericTooltipUtils::convertObject).toArray()).m_130940_(TEXT_STYLE);
    }

    @NotNull
    public static Component value(Object value) {
        return GenericTooltipUtils.convertObject(value).m_130944_(new ChatFormatting[]{PARAM_STYLE, ChatFormatting.BOLD});
    }

    @NotNull
    public static Component value(Object value, String unit) {
        return Component.m_237110_((String)"ali.util.advanced_loot_info.two_values", (Object[])new Object[]{GenericTooltipUtils.convertObject(value), unit}).m_130944_(new ChatFormatting[]{PARAM_STYLE, ChatFormatting.BOLD});
    }

    @NotNull
    public static Component pair(Object value1, Object value2) {
        return Component.m_237110_((String)"ali.util.advanced_loot_info.two_values_with_space", (Object[])new Object[]{GenericTooltipUtils.convertObject(value1), GenericTooltipUtils.convertObject(value2)});
    }

    @NotNull
    public static Component pad(int count, Object arg) {
        if (count > 0) {
            return GenericTooltipUtils.pair(Component.m_237115_((String)("ali.util.advanced_loot_info.pad." + count)), GenericTooltipUtils.convertObject(arg));
        }
        return GenericTooltipUtils.convertObject(arg);
    }

    @NotNull
    public static Component keyValue(Object key, Object value) {
        return GenericTooltipUtils.translatable("ali.util.advanced_loot_info.key_value", GenericTooltipUtils.convertObject(key), GenericTooltipUtils.value(value));
    }

    public static @Unmodifiable @NotNull ITooltipNode getNumberProviderTooltip(IServerUtils utils, String key, NumberProvider value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(utils.convertNumber(utils, value))));
    }

    public static @Unmodifiable @NotNull ITooltipNode getIntRangeTooltip(IServerUtils utils, String key, IntRange range) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(RangeValue.rangeToString(utils.convertNumber(utils, range.f_165001_), utils.convertNumber(utils, range.f_165002_)))));
    }

    public static @Unmodifiable @NotNull ITooltipNode getBooleanTooltip(IServerUtils utils, String key, Boolean value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getIntegerTooltip(IServerUtils ignoredUtils, String key, int value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getLongTooltip(IServerUtils ignoredUtils, String key, Long value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getStringTooltip(IServerUtils utils, String key, String value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getFloatTooltip(IServerUtils ignoredUtils, String key, Float value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getDoubleTooltip(IServerUtils ignoredUtils, String key, Double value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getEnumTooltip(IServerUtils ignoredUtils, String key, Enum<?> value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value.name())));
    }

    public static @Unmodifiable @NotNull ITooltipNode getResourceLocationTooltip(IServerUtils ignoredUtils, String key, ResourceLocation value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static <T> @Unmodifiable @NotNull ITooltipNode getBuiltInRegistryTooltip(IServerUtils utils, String key, Registry<T> registry, T value) {
        return GenericTooltipUtils.getOptionalTooltip(utils, key, Optional.ofNullable(registry.m_7981_(value)), GenericTooltipUtils::getResourceLocationTooltip);
    }

    public static <V, T extends Registry<V>> @Unmodifiable @NotNull ITooltipNode getRegistryTooltip(IServerUtils utils, String key, ResourceKey<T> registry, V value) {
        Optional<Holder.Reference> first;
        Optional lookup;
        HolderLookup.Provider provider = utils.lookupProvider();
        if (provider != null && (lookup = provider.m_254861_(registry)).isPresent() && (first = ((HolderLookup.RegistryLookup)lookup.get()).m_214062_().filter(l -> l.m_203334_() == value).findFirst()).isPresent()) {
            return GenericTooltipUtils.getResourceKeyTooltip(utils, key, Objects.requireNonNull(first.get().m_205785_()));
        }
        return new TooltipNode();
    }

    public static <T> @Unmodifiable @NotNull ITooltipNode getResourceKeyTooltip(IServerUtils utils, String key, ResourceKey<T> value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value.m_135782_())));
    }

    public static @Unmodifiable @NotNull ITooltipNode getTagKeyTooltip(IServerUtils utils, String key, TagKey<?> value) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, key, value.f_203868_());
    }

    public static @Unmodifiable @NotNull ITooltipNode getComponentTooltip(IServerUtils ignoredUtils, String key, Component component) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(component.m_6881_())));
    }

    @NotNull
    public static ITooltipNode getMinMaxBoundsTooltip(IServerUtils ignoredUtils, String key, MinMaxBounds.Ints ints) {
        if (ints != MinMaxBounds.Ints.f_55364_) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(GenericTooltipUtils.toString(ints))));
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getMinMaxBoundsTooltip(IServerUtils ignoredUtils, String key, MinMaxBounds.Doubles doubles) {
        if (doubles != MinMaxBounds.Doubles.f_154779_) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(GenericTooltipUtils.toString(doubles))));
        }
        return new TooltipNode();
    }

    @NotNull
    public static <T> ITooltipNode getOptionalTooltip(IServerUtils utils, Optional<T> optional, BiFunction<IServerUtils, T, ITooltipNode> mapper) {
        return optional.map(value -> (ITooltipNode)mapper.apply(utils, value)).orElse(new TooltipNode());
    }

    @NotNull
    public static <T> ITooltipNode getOptionalTooltip(IServerUtils utils, String key, Optional<T> optional, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        return optional.map(value -> (ITooltipNode)mapper.apply((Object)utils, (Object)key, value)).orElse(new TooltipNode());
    }

    @NotNull
    public static <T> ITooltipNode getOptionalHolderTooltip(IServerUtils utils, String key, Optional<Holder<T>> optional, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        return optional.map(holder -> GenericTooltipUtils.getHolderTooltip(utils, key, holder, mapper)).orElse(new TooltipNode());
    }

    @NotNull
    public static <T> ITooltipNode getOptionalHolderSetTooltip(IServerUtils utils, String key, String value, Optional<HolderSet<T>> optional, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        return optional.map(holderSet -> GenericTooltipUtils.getHolderSetTooltip(utils, key, value, holderSet, mapper)).orElse(new TooltipNode());
    }

    @NotNull
    public static <T> ITooltipNode getHolderTooltip(IServerUtils utils, String key, Holder<T> holder, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        return (ITooltipNode)mapper.apply((Object)utils, (Object)key, holder.m_203334_());
    }

    @NotNull
    public static <T> ITooltipNode getHolderSetTooltip(IServerUtils utils, String key, String value, HolderSet<T> holderSet, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        Either either = holderSet.m_203440_();
        Optional left = either.left();
        Optional right = either.right();
        TooltipNode tooltip = left.isPresent() || !right.orElse(List.of()).isEmpty() ? new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0])) : new TooltipNode();
        left.ifPresent(tagKey -> tooltip.add(GenericTooltipUtils.getTagKeyTooltip(utils, "ali.property.value.tag", tagKey)));
        right.ifPresent(list -> {
            if (!list.isEmpty()) {
                holderSet.forEach(holder -> tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, value, holder, mapper)));
            }
        });
        return tooltip;
    }

    @NotNull
    public static <T> ITooltipNode getCollectionTooltip(IServerUtils utils, Collection<T> values, BiFunction<IServerUtils, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode();
            values.forEach(value -> tooltip.add((ITooltipNode)mapper.apply(utils, value)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <T> ITooltipNode getCollectionTooltip(IServerUtils utils, String key, Collection<T> values, BiFunction<IServerUtils, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            values.forEach(value -> tooltip.add((ITooltipNode)mapper.apply(utils, value)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <T> ITooltipNode getCollectionTooltip(IServerUtils utils, String key, String value, Collection<T> values, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            values.forEach(v -> tooltip.add((ITooltipNode)mapper.apply((Object)utils, (Object)value, v)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <T, P extends Collection<T>> ITooltipNode getCollectionTooltip(IServerUtils utils, String key, String value, Optional<P> values, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        Collection v;
        if (values.isPresent() && !(v = (Collection)values.get()).isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            v.forEach(val -> tooltip.add((ITooltipNode)mapper.apply((Object)utils, (Object)value, val)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <K, V> ITooltipNode getMapTooltip(IServerUtils utils, Map<K, V> values, BiFunction<IServerUtils, Map.Entry<K, V>, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode();
            values.entrySet().forEach(e -> tooltip.add((ITooltipNode)mapper.apply(utils, (Map.Entry)e)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <K, V> ITooltipNode getMapTooltip(IServerUtils utils, String key, Map<K, V> values, BiFunction<IServerUtils, Map.Entry<K, V>, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            values.entrySet().forEach(e -> tooltip.add((ITooltipNode)mapper.apply(utils, (Map.Entry)e)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <T> ITooltipNode getEitherHolderTooltip(IServerUtils utils, String key, EitherHolder<T> holder, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        return (ITooltipNode)holder.m_340003_().map(v -> (ITooltipNode)mapper.apply((Object)utils, (Object)key, v.m_203334_()), k -> GenericTooltipUtils.getResourceKeyTooltip(utils, key, k));
    }

    public static @Unmodifiable @NotNull ITooltipNode getRecipeEntryTooltip(IServerUtils ignoredUtils, Map.Entry<ResourceLocation, Boolean> entry) {
        return new TooltipNode(GenericTooltipUtils.keyValue(entry.getKey(), entry.getValue()));
    }

    public static @Unmodifiable @NotNull ITooltipNode getCriterionEntryTooltip(IServerUtils ignoredUtils, Map.Entry<String, Boolean> entry) {
        return new TooltipNode(GenericTooltipUtils.keyValue(entry.getKey(), entry.getValue()));
    }

    public static @Unmodifiable @NotNull ITooltipNode getStringEntryTooltip(IServerUtils ignoredUtils, Map.Entry<String, String> entry) {
        return new TooltipNode(GenericTooltipUtils.keyValue(entry.getKey(), entry.getValue()));
    }

    @NotNull
    public static ITooltipNode getIntRangeEntryTooltip(IServerUtils utils, Map.Entry<String, IntRange> entry) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.value(entry.getKey()));
        tooltip.add(GenericTooltipUtils.getIntRangeTooltip(utils, "ali.property.value.limit", entry.getValue()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMobEffectPredicateEntryTooltip(IServerUtils utils, Map.Entry<Holder<MobEffect>, MobEffectsPredicate.MobEffectInstancePredicate> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.null", entry.getKey(), RegistriesTooltipUtils::getMobEffectTooltip);
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.amplifier", entry.getValue().f_56566_()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.duration", entry.getValue().f_56567_()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_ambient", entry.getValue().f_56568_(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_visible", entry.getValue().f_56569_(), GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEnchantmentLevelsEntryTooltip(IServerUtils utils, Map.Entry<Holder<Enchantment>, NumberProvider> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.null", entry.getKey(), RegistriesTooltipUtils::getEnchantmentTooltip);
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.levels", entry.getValue()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getAdvancementEntryTooltip(IServerUtils utils, Map.Entry<ResourceLocation, PlayerPredicate.AdvancementPredicate> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.property.value.null", entry.getKey());
        tooltip.add(GenericTooltipUtils.getAdvancementPredicateTooltip(utils, "ali.property.value.done", entry.getValue()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMapDecorationEntryTooltip(IServerUtils utils, Map.Entry<String, MapDecorations.Entry> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.decoration", entry.getKey());
        tooltip.add(GenericTooltipUtils.getMapDecorationEntryTooltip(utils, "ali.property.value.null", entry.getValue()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getBlockPropertyEntryTooltip(IServerUtils utils, Map.Entry<Holder<Block>, net.minecraft.world.level.block.state.properties.Property<?>> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.block", entry.getKey(), RegistriesTooltipUtils::getBlockTooltip);
        tooltip.add(GenericTooltipUtils.getPropertyTooltip(utils, "ali.property.value.property", entry.getValue()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getPropertiesEntryTooltip(IServerUtils utils, Map.Entry<String, Collection<Property>> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.null", entry.getKey());
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, entry.getValue(), GenericTooltipUtils::getAuthPropertyTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEnchantmentLevelEntryTooltip(IServerUtils utils, Map.Entry<Holder<Enchantment>, Integer> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.null", entry.getKey(), RegistriesTooltipUtils::getEnchantmentTooltip);
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.level", entry.getValue()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getToggleEntryTooltip(IServerUtils utils, Map.Entry<ToggleTooltips.ComponentToggle<?>, Boolean> entry) {
        ITooltipNode tooltip = RegistriesTooltipUtils.getDataComponentTypeTooltip(utils, "ali.property.value.null", entry.getKey().f_316853_());
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.value", entry.getValue()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getDataComponentPatchEntryTooltip(IServerUtils utils, Map.Entry<DataComponentType<?>, Optional<?>> entry) {
        ITooltipNode tooltip = RegistriesTooltipUtils.getDataComponentTypeTooltip(utils, "ali.property.value.null", entry.getKey());
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, entry.getValue(), (u, v) -> u.getDataComponentTypeTooltip((IServerUtils)u, (DataComponentType<?>)((DataComponentType)entry.getKey()), v)));
        if (entry.getValue().isEmpty()) {
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.util.advanced_loot_info.removed", new Object[0])));
        }
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getItemSubPredicateEntryTooltip(IServerUtils utils, Map.Entry<ItemSubPredicate.Type<?>, ItemSubPredicate> entry) {
        return utils.getItemSubPredicateTooltip(utils, entry.getValue());
    }

    @NotNull
    public static ITooltipNode getSlotRangePredicateEntryTooltip(IServerUtils utils, Map.Entry<SlotRange, ItemPredicate> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getIntListTooltip(utils, "ali.property.value.null", entry.getKey().m_319501_());
        tooltip.add(GenericTooltipUtils.getItemPredicateTooltip(utils, "ali.property.branch.predicate", entry.getValue()));
        return tooltip;
    }

    @NotNull
    private static String toString(MinMaxBounds.Doubles doubles) {
        Optional min = doubles.m_293284_();
        Optional max = doubles.m_294019_();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min, max)) {
                    return String.format("%.1f-%.1f", min.get(), max.get());
                }
                return String.format("=%.1f", min.get());
            }
            return String.format("\u2265%.1f", min.get());
        }
        return max.map(aDouble -> String.format("\u2264%.1f", aDouble)).orElse("???");
    }

    @NotNull
    private static String toString(MinMaxBounds.Ints ints) {
        Optional min = ints.m_293284_();
        Optional max = ints.m_294019_();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min, max)) {
                    return String.format("%d-%d", min.get(), max.get());
                }
                return String.format("=%d", min.get());
            }
            return String.format("\u2265%d", min.get());
        }
        return max.map(integer -> String.format("\u2264%d", integer)).orElse("???");
    }

    @NotNull
    private static MutableComponent convertObject(@Nullable Object object) {
        if (object instanceof MutableComponent) {
            MutableComponent component = (MutableComponent)object;
            return component;
        }
        if (object != null) {
            return Component.m_237113_((String)object.toString());
        }
        return Component.m_237113_((String)"null");
    }

    @NotNull
    private static String getTranslationKey(ResourceLocation location) {
        return "stat." + location.toString().replace(':', '.');
    }
}

