/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IServerUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.SetItemFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import oshi.util.tuples.Pair;

public class ItemCollectorUtils {
    @NotNull
    public static List<Item> collectLootTable(IServerUtils utils, LootTable lootTable) {
        LinkedList<Item> result = new LinkedList<Item>();
        for (LootPool pool : lootTable.f_79109_) {
            result.addAll(ItemCollectorUtils.collectLootPool(utils, pool));
        }
        result.addAll(lootTable.f_79110_.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    @NotNull
    public static List<Item> collectLootPool(IServerUtils utils, LootPool pool) {
        LinkedList<Item> result = new LinkedList<Item>();
        for (LootPoolEntryContainer entry : pool.f_79023_) {
            result.addAll(utils.collectItems(utils, entry));
        }
        result.addAll(pool.f_79026_.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    public static @Unmodifiable @NotNull List<Item> collectItems(IServerUtils utils, LootItem entry) {
        LinkedList<Item> result = new LinkedList<Item>(List.of((Item)entry.f_79564_.m_203334_()));
        result.addAll(entry.f_79677_.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    public static @Unmodifiable @NotNull List<Item> collectTags(IServerUtils utils, TagEntry entry) {
        LinkedList<Item> result = new LinkedList<Item>(BuiltInRegistries.f_257033_.m_203431_(entry.f_79821_).map(tag -> tag.m_203614_().map(Holder::m_203334_).toList()).orElse(List.of()));
        result.addAll(entry.f_79677_.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    @NotNull
    public static List<Item> collectComposite(IServerUtils utils, CompositeEntryBase entry) {
        LinkedList<Item> result = new LinkedList<Item>();
        for (LootPoolEntryContainer child : entry.f_79428_) {
            result.addAll(utils.collectItems(utils, child));
        }
        return result;
    }

    public static @Unmodifiable @NotNull List<Item> collectSingleton(IServerUtils utils, LootPoolSingletonContainer entry) {
        return entry.f_79677_.stream().map(f -> utils.collectItems(utils, List.of(), f)).flatMap(Collection::stream).toList();
    }

    @NotNull
    public static List<Item> collectReference(IServerUtils utils, NestedLootTable entry) {
        LinkedList<Item> result = new LinkedList<Item>();
        LootTable lootTable = utils.getLootTable((Either<ResourceLocation, LootTable>)entry.f_314988_.mapLeft(ResourceKey::m_135782_));
        if (lootTable != null) {
            result.addAll(ItemCollectorUtils.collectLootTable(utils, lootTable));
            result.addAll(entry.f_79677_.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        }
        return result;
    }

    @NotNull
    public static List<Item> collectFurnaceSmelt(IServerUtils utils, List<Item> items, SmeltItemFunction ignoredFunction) {
        ServerLevel level = utils.getServerLevel();
        if (level != null) {
            return items.stream().map(i -> level.m_7465_().m_44015_(RecipeType.f_44108_, (RecipeInput)new SingleRecipeInput(i.m_7968_()), (Level)level).map(l -> List.of(((SmeltingRecipe)l.f_291008_()).m_8043_((HolderLookup.Provider)utils.getServerLevel().m_9598_()).m_41720_())).orElse(List.of())).flatMap(Collection::stream).toList();
        }
        return List.of();
    }

    public static @Unmodifiable @NotNull List<Item> collectSetItem(IServerUtils ignoredUtils, List<Item> ignoredItems, SetItemFunction function) {
        return List.of((Item)function.f_313907_.m_203334_());
    }

    @NotNull
    public static Pair<List<Item>, List<Item>> collectTradeItems(IServerUtils utils, Int2ObjectMap<VillagerTrades.ItemListing[]> itemLists) {
        ArrayList inputs = new ArrayList();
        ArrayList outputs = new ArrayList();
        ObjectIterator objectIterator = itemLists.values().iterator();
        while (objectIterator.hasNext()) {
            VillagerTrades.ItemListing[] itemListings;
            for (VillagerTrades.ItemListing itemListing : itemListings = (VillagerTrades.ItemListing[])objectIterator.next()) {
                Pair<List<Item>, List<Item>> pair = utils.collectItems(utils, itemListing);
                inputs.addAll((Collection)pair.getA());
                outputs.addAll((Collection)pair.getB());
            }
        }
        return new Pair(inputs, outputs);
    }
}

