/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.emi;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.common.EntityStorage;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.emi.EmiBaseLoot;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_638;

public class EmiEntityLoot
extends EmiBaseLoot {
    private final class_1299<?> entityType;
    private final class_2960 variant;

    public EmiEntityLoot(EmiRecipeCategory category, class_2960 id, class_1299<?> entityType, IDataNode lootTable, List<class_1799> outputs) {
        super(category, id, lootTable, 0, 48, Collections.emptyList(), outputs);
        this.entityType = entityType;
        this.variant = id;
        class_1826 spawnEgg = class_1826.method_8019(entityType);
        if (spawnEgg != null) {
            this.catalysts = List.of(EmiStack.of((class_1935)spawnEgg));
        }
    }

    public int getDisplayHeight() {
        return 48 + this.getItemsHeight();
    }

    @Override
    protected List<Widget> getAdditionalWidgets(final WidgetHolder widgetHolder) {
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            int length = class_310.method_1551().field_1772.method_27525((class_5348)this.entityType.method_5897());
            widgets.add(new Widget(){
                private static final int WIDGET_SIZE = 36;
                final Bounds bounds;
                final Rect rect;
                {
                    this.bounds = new Bounds((widgetHolder.getWidth() - 36) / 2, 10, 36, 36);
                    this.rect = new Rect(this.bounds.x(), this.bounds.y(), this.bounds.width(), this.bounds.height());
                }

                public Bounds getBounds() {
                    return this.bounds;
                }

                public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
                    class_638 level = class_310.method_1551().field_1687;
                    if (level != null) {
                        class_1297 entity = EntityStorage.getEntity(PluginManager.COMMON_REGISTRY, EmiEntityLoot.this.entityType, (class_1937)level, EmiEntityLoot.this.variant);
                        GenericUtils.renderEntity(entity, this.rect, widgetHolder.getWidth(), guiGraphics, mouseX, mouseY);
                    }
                }
            });
            widgets.add((Widget)new TextWidget(this.entityType.method_5897().method_30937(), (widgetHolder.getWidth() - length) / 2, 0, 0, false));
        }
        this.catalysts.forEach(catalyst -> widgets.add((Widget)new SlotWidget(catalyst, 0, 0)));
        return widgets;
    }

    @Override
    IWidget getRootWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth) {
        return new LootTableWidget(utils, entry, rect, maxWidth);
    }
}

