/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class EntityUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    @NotNull
    public static List<Entity> getSheepVariants(Level level) {
        Sheep sheep;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (DyeColor color : DyeColor.values()) {
            Sheep sheep2;
            try {
                sheep2 = (Sheep)EntityType.SHEEP.create(level, EntitySpawnReason.LOAD);
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to create colored sheep with color {}: {}", (Object)color.getSerializedName(), (Object)e.getMessage());
                continue;
            }
            if (sheep2 == null) continue;
            sheep2.setColor(color);
            entities.add((Entity)sheep2);
        }
        try {
            sheep = (Sheep)EntityType.SHEEP.create(level, EntitySpawnReason.LOAD);
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to create sheep: {}", (Object)e.getMessage());
            return entities;
        }
        if (sheep != null) {
            sheep.setSheared(true);
            entities.add((Entity)sheep);
        }
        return entities;
    }
}

