/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.api;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public abstract class ListNode
implements IDataNode {
    @Nullable
    private List<IDataNode> nodes;

    public ListNode() {
    }

    public ListNode(IClientUtils utils, class_2540 buf) {
        int count = buf.readInt();
        if (count == 0) {
            this.nodes = Collections.emptyList();
        } else if (count == 1) {
            this.nodes = Collections.singletonList(utils.getDataNodeFactory(buf.method_10810()).create(utils, buf));
        } else {
            this.nodes = new ArrayList<IDataNode>(count);
            for (int i = 0; i < count; ++i) {
                this.nodes.add((IDataNode)utils.getDataNodeFactory(buf.method_10810()).create(utils, buf));
            }
            Collections.sort(this.nodes);
            this.nodes = Collections.unmodifiableList(this.nodes);
        }
    }

    public List<IDataNode> nodes() {
        return Objects.requireNonNullElse(this.nodes, Collections.emptyList());
    }

    public void addChildren(IDataNode node) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<IDataNode>();
        }
        this.nodes.add(node);
    }

    public abstract void encodeNode(IServerUtils var1, class_2540 var2);

    @Override
    public final void encode(IServerUtils utils, class_2540 buf) {
        List<IDataNode> nodes = this.nodes();
        buf.method_53002(nodes.size());
        for (IDataNode node : nodes) {
            buf.method_10812(node.getId());
            node.encode(utils, buf);
        }
        this.encodeNode(utils, buf);
    }
}

