/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.tooltip;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public abstract class ListTooltipNode
implements ITooltipNode {
    @Nullable
    private List<ITooltipNode> children;

    public ListTooltipNode(List<ITooltipNode> children) {
        this.children = children;
    }

    abstract void encodeNode(class_2540 var1);

    public void addNode(ITooltipNode node) {
        if (this.children == null) {
            this.children = new ArrayList<ITooltipNode>();
        }
        this.children.add(node);
    }

    public List<ITooltipNode> getChildren() {
        return Objects.requireNonNullElse(this.children, Collections.emptyList());
    }

    @Override
    public List<class_2561> getComponents(int pad, boolean showAdvancedTooltip) {
        List<class_2561> components;
        List<ITooltipNode> children = this.getChildren();
        int count = children.size();
        if (count == 0) {
            components = Collections.emptyList();
        } else if (count == 1) {
            components = children.get(0).getComponents(pad, showAdvancedTooltip);
        } else {
            components = new ArrayList<class_2561>(count);
            for (ITooltipNode child : children) {
                components.addAll(child.getComponents(pad, showAdvancedTooltip));
            }
        }
        return components;
    }

    @Override
    public void encode(IServerUtils utils, class_2540 buf) {
        List<ITooltipNode> children = this.getChildren();
        buf.method_53002(children.size());
        for (ITooltipNode child : children) {
            ITooltipNode.encodeNode(utils, child, buf);
        }
        this.encodeNode(buf);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTooltipNode that = (ListTooltipNode)o;
        return Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hashCode(this.children);
    }

    public static List<ITooltipNode> decodeChildren(IClientUtils utils, class_2540 buf) {
        int count = buf.readInt();
        if (count == 0) {
            return Collections.emptyList();
        }
        if (count == 1) {
            return Collections.singletonList(ITooltipNode.decodeNode(utils, buf));
        }
        ArrayList<ITooltipNode> children = new ArrayList<ITooltipNode>(count);
        for (int i = 0; i < count; ++i) {
            children.add(ITooltipNode.decodeNode(utils, buf));
        }
        return children;
    }

    public static abstract class Builder
    implements IKeyTooltipNode {
        protected final List<ITooltipNode> children = new ArrayList<ITooltipNode>();

        @Override
        public Builder add(ITooltipNode node) {
            this.children.add(node);
            return this;
        }
    }
}

