/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.rei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yanny.ali.compatibility.rei.ReiBaseCategory;
import com.yanny.ali.compatibility.rei.ReiBlockDisplay;
import com.yanny.ali.mixin.MixinBushBlock;
import com.yanny.ali.registries.LootCategory;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;

public class ReiBlockCategory
extends ReiBaseCategory<ReiBlockDisplay, Block> {
    private final CategoryIdentifier<ReiBlockDisplay> identifier;
    private final Component title;
    private final ItemStack icon;

    public ReiBlockCategory(CategoryIdentifier<ReiBlockDisplay> identifier, Component title, LootCategory<Block> lootCategory) {
        super(lootCategory);
        this.identifier = identifier;
        this.title = title;
        this.icon = lootCategory.getIcon();
    }

    @Override
    public List<Widget> setupDisplay(ReiBlockDisplay display, Rectangle bounds) {
        boolean isSpecial = display.getBlock() instanceof BushBlock || display.getBlock().m_5456_() == Items.f_41852_;
        int offset = isSpecial ? 30 : 22;
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        ReiBaseCategory.WidgetHolder holder = this.getBaseWidget(display, new Rectangle(0, 0, bounds.width, bounds.height), offset);
        int width = holder.bounds().width % 2 == 0 ? holder.bounds().width : holder.bounds().width + 1;
        Rectangle innerBounds = new Rectangle(0, 0, width, holder.bounds().height + offset);
        int height = Math.min(innerBounds.height + 8, bounds.height - 8);
        Rectangle fullBounds = new Rectangle(0, 0, innerBounds.width + 8, height);
        LinkedList<Widget> innerWidgets = new LinkedList<Widget>(holder.widgets());
        if (isSpecial) {
            innerWidgets.add(Widgets.createResultSlotBackground((Point)new Point(innerBounds.getCenterX() - 8, innerBounds.getY() + 5)));
            innerWidgets.add((Widget)Widgets.wrapRenderer((Rectangle)new Rectangle(innerBounds.getCenterX() - 8, innerBounds.getY(), 26, 26), (Renderer)new BlockSlotRenderer(display.getBlock())));
        } else {
            innerWidgets.add((Widget)Widgets.createSlot((Point)new Point(innerBounds.getCenterX() - 8, innerBounds.getY() + 1)).entry(EntryStacks.of((ItemLike)display.getBlock())).markInput());
        }
        fullBounds.move(bounds.getCenterX() - fullBounds.width / 2, bounds.y + 4);
        widgets.add((Widget)Widgets.createCategoryBase((Rectangle)fullBounds));
        if (bounds.height >= innerBounds.height + 8) {
            innerBounds.move(bounds.getCenterX() - innerBounds.width / 2, bounds.y + 8);
            widgets.add((Widget)Widgets.withTranslate((Widget)Widgets.concat(innerWidgets), (double)(bounds.getCenterX() - Math.round((float)innerBounds.width / 2.0f)), (double)(bounds.y + 8), (double)0.0));
        } else {
            Rectangle overflowBounds = new Rectangle(fullBounds.x + 4, fullBounds.y + 4, fullBounds.width - 8, fullBounds.height - 8);
            widgets.add((Widget)Widgets.overflowed((Rectangle)overflowBounds, (WidgetWithBounds)Widgets.concatWithBounds((Rectangle)innerBounds, innerWidgets)));
        }
        return widgets;
    }

    public CategoryIdentifier<ReiBlockDisplay> getCategoryIdentifier() {
        return this.identifier;
    }

    public Component getTitle() {
        return this.title;
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemStack)this.icon);
    }

    private static class BlockSlotRenderer
    implements Renderer {
        private final BlockState blockState;
        private final Block block;
        private final boolean isPlant;
        private final ClientLevel level;

        public BlockSlotRenderer(Block block) {
            this.block = block;
            this.blockState = block.m_49966_();
            this.isPlant = block instanceof BushBlock;
            this.level = Minecraft.m_91087_().f_91073_;
        }

        public void render(GuiGraphics guiGraphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
            BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)bounds.getX(), (float)bounds.getY(), 100.0f);
            if (this.isPlant) {
                MixinBushBlock bushBlock;
                poseStack.m_252880_(14.0f, 8.0f, 100.0f);
                poseStack.m_85841_(9.0f, -9.0f, 9.0f);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(225.0f));
                blockRenderer.m_110912_(this.blockState, poseStack, (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_);
                BlockState farmland = Blocks.f_50093_.m_49966_();
                Block block = this.block;
                BlockState base = block instanceof MixinBushBlock && (bushBlock = (MixinBushBlock)block).invokeMayPlaceOn(farmland, (BlockGetter)this.level, BlockPos.f_121853_) ? farmland : Blocks.f_50440_.m_49966_();
                poseStack.m_252880_(0.0f, -1.0f, 0.0f);
                blockRenderer.m_110912_(base, poseStack, (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_);
            } else {
                poseStack.m_85837_(25.5, 21.0, 100.0);
                poseStack.m_85841_(18.0f, -18.0f, 18.0f);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(225.0f));
                blockRenderer.m_110912_(this.blockState, poseStack, (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_);
                poseStack.m_252880_(0.0f, -1.0f, 0.0f);
            }
            poseStack.m_85849_();
        }
    }
}

