/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.common;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.QuadConsumer;
import com.yanny.ali.compatibility.common.TriConsumer;
import com.yanny.ali.manager.AliClientRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class GenericUtils {
    private static final ResourceLocation TEXTURE_LOC = Utils.modLoc("textures/gui/gui.png");
    private static final int WIDGET_SIZE = 36;
    private static final int DOTS_WIDTH = Minecraft.getInstance().font.width("...");

    public static void renderEntity(Entity entity, Rect bounds, int fullWidth, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        PoseStack poseStack = guiGraphics.pose();
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)poseStack.last().pose());
        Matrix4f projectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Matrix4f mvpMatrix = projectionMatrix.mul((Matrix4fc)modelViewMatrix);
        Vector4f topLeftWorld = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        Vector4f topLeftClip = mvpMatrix.transform(topLeftWorld);
        Vector4f topLeftNDC = new Vector4f(topLeftClip.x / topLeftClip.w, topLeftClip.y / topLeftClip.w, 0.0f, 1.0f);
        int screenX = Math.round((topLeftNDC.x + 1.0f) / 2.0f * (float)window.getGuiScaledWidth());
        int screenY = Math.round((1.0f - topLeftNDC.y) / 2.0f * (float)window.getGuiScaledHeight());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            guiGraphics.pose().pushPose();
            guiGraphics.blit(TEXTURE_LOC, bounds.x(), bounds.y(), bounds.width(), bounds.height(), 0.0f, 36.0f, 36, 36, 256, 256);
            guiGraphics.enableScissor(screenX + bounds.x() + 1, screenY + bounds.y() + 1, screenX + bounds.right() - 1, screenY + bounds.bottom() - 1);
            EntityDimensions dimensions = entity.getType().getDimensions();
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(-screenX + bounds.x()), (int)(-screenY + bounds.y()), (int)(screenX + bounds.right()), (int)(screenY + bounds.bottom()), (int)((int)Math.min(20.0f / dimensions.height(), 20.0f / dimensions.width())), (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)livingEntity);
            guiGraphics.disableScissor();
            guiGraphics.pose().popPose();
        }
    }

    @NotNull
    public static Component ellipsis(String text, String fallback, int maxWidth) {
        Font font = Minecraft.getInstance().font;
        text = Language.getInstance().getOrDefault(text, GenericUtils.getFallbackText(fallback));
        if (font.width(text) > maxWidth) {
            int index = 20;
            while (font.width(text.substring(0, index + 1) + DOTS_WIDTH) <= maxWidth) {
                ++index;
            }
            return Component.literal((String)(text.substring(0, index) + "..."));
        }
        return Component.literal((String)text);
    }

    public static void processData(ClientLevel level, AliClientRegistry clientRegistry, Map<ResourceLocation, IDataNode> lootData, Map<ResourceLocation, IDataNode> tradeData, QuadConsumer<IDataNode, ResourceLocation, Block, List<ItemStack>> blockConsumer, QuadConsumer<IDataNode, ResourceLocation, EntityType<?>, List<ItemStack>> entityConsumer, TriConsumer<IDataNode, ResourceLocation, List<ItemStack>> gameplayConsumer, QuadConsumer<IDataNode, ResourceLocation, List<ItemStack>, List<ItemStack>> traderConsumer, QuadConsumer<IDataNode, ResourceLocation, List<ItemStack>, List<ItemStack>> wanderingTraderConsumer) {
        List<ItemStack> outputs;
        List<ItemStack> inputs;
        IDataNode tradeEntry;
        Object location;
        for (Block block : BuiltInRegistries.BLOCK) {
            ResourceKey resourceKey = block.getLootTable();
            if (resourceKey == null) continue;
            location = resourceKey.location();
            IDataNode lootEntry = lootData.get(location);
            List<ItemStack> outputs2 = clientRegistry.getLootItems((ResourceLocation)location);
            if (lootEntry == null || outputs2 == null) continue;
            blockConsumer.accept(lootEntry, (ResourceLocation)location, block, outputs2);
            lootData.remove(location);
        }
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            List<Entity> list = clientRegistry.createEntities(entityType, (Level)level);
            for (Entity entity : list) {
                Mob mob;
                ResourceKey resourceKey;
                if (!(entity instanceof Mob) || (resourceKey = (mob = (Mob)entity).getLootTable()) == null) continue;
                ResourceLocation location2 = resourceKey.location();
                IDataNode lootEntry = lootData.get(location2);
                List<ItemStack> outputs3 = clientRegistry.getLootItems(location2);
                if (lootEntry != null && outputs3 != null) {
                    entityConsumer.accept(lootEntry, location2, entityType, outputs3);
                }
                lootData.remove(location2);
            }
        }
        for (Map.Entry<ResourceLocation, IDataNode> entry : lootData.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            List<ItemStack> outputs4 = clientRegistry.getLootItems(resourceLocation);
            if (outputs4 == null) continue;
            gameplayConsumer.accept(entry.getValue(), entry.getKey(), outputs4);
        }
        lootData.clear();
        List<Map.Entry> entries = BuiltInRegistries.VILLAGER_PROFESSION.entrySet().stream().sorted(Comparator.comparing(a -> ((ResourceKey)a.getKey()).location().getPath())).toList();
        for (Map.Entry entry : entries) {
            location = ((ResourceKey)entry.getKey()).location();
            tradeEntry = tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = clientRegistry.getTradeInputItems((ResourceLocation)location).stream().map(Item::getDefaultInstance).toList();
            outputs = clientRegistry.getTradeOutputItems((ResourceLocation)location).stream().map(Item::getDefaultInstance).toList();
            traderConsumer.accept(tradeEntry, (ResourceLocation)location, inputs, outputs);
            tradeData.remove(location);
        }
        for (Map.Entry entry : tradeData.entrySet()) {
            location = (ResourceLocation)entry.getKey();
            tradeEntry = tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = clientRegistry.getTradeInputItems((ResourceLocation)location).stream().map(Item::getDefaultInstance).toList();
            outputs = clientRegistry.getTradeOutputItems((ResourceLocation)location).stream().map(Item::getDefaultInstance).toList();
            wanderingTraderConsumer.accept(tradeEntry, (ResourceLocation)location, inputs, outputs);
        }
        tradeData.clear();
    }

    private static String getFallbackText(String fallback) {
        List pathSegments = Pattern.compile("/").splitAsStream(fallback).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        Collections.reverse(pathSegments);
        return pathSegments.stream().flatMap(segment -> Arrays.stream(segment.split("_"))).filter(s -> !s.isEmpty()).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining(" "));
    }
}

