/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.mods.immersive_engineering.trades;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.common.trades.ItemsToItemsNode;
import com.yanny.ali.plugin.mods.BaseAccessor;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.FieldAccessor;
import com.yanny.ali.plugin.mods.IItemListing;
import com.yanny.ali.plugin.mods.PluginUtils;
import com.yanny.ali.plugin.mods.immersive_engineering.trades.LazyItemStack;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3853;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

@ClassAccessor(value="blusunrize.immersiveengineering.common.world.Villages$TradeListing")
public class TradeListing
extends BaseAccessor<class_3853.class_1652>
implements IItemListing {
    private static final Logger LOGGER;
    private static final Object SELL_FOR_ONE_EMERALD;
    private static final Object SELL_FOR_MANY_EMERALDS;
    private static final Object BUY_FOR_ONE_EMERALD;
    private static final Object BUY_FOR_MANY_EMERALDS;
    @FieldAccessor
    private int price;
    @FieldAccessor
    private Object outline;
    @FieldAccessor(clazz=LazyItemStack.class)
    private LazyItemStack lazyItem;
    @FieldAccessor
    private int maxUses;
    @FieldAccessor
    private int xp;
    @FieldAccessor
    private float priceMultiplier;

    public TradeListing(class_3853.class_1652 parent) {
        super(parent);
    }

    @Override
    @NotNull
    public IDataNode getNode(IServerUtils utils, ITooltipNode condition) {
        Either<class_1799, class_6862<? extends class_1935>> item = this.lazyItem.getItem();
        if (this.outline == SELL_FOR_ONE_EMERALD) {
            return new ItemsToItemsNode(utils, item, new RangeValue(this.price), (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)class_1802.field_8687.method_7854()), new RangeValue(1.0f), this.maxUses, this.xp, this.priceMultiplier, condition);
        }
        if (this.outline == SELL_FOR_MANY_EMERALDS) {
            return new ItemsToItemsNode(utils, item, new RangeValue(1.0f), (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)class_1802.field_8687.method_7854()), new RangeValue(this.price), this.maxUses, this.xp, this.priceMultiplier, condition);
        }
        if (this.outline == BUY_FOR_ONE_EMERALD) {
            return new ItemsToItemsNode(utils, (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)class_1802.field_8687.method_7854()), new RangeValue(1.0f), item, new RangeValue(this.price), this.maxUses, this.xp, this.priceMultiplier, condition);
        }
        if (this.outline == BUY_FOR_MANY_EMERALDS) {
            return new ItemsToItemsNode(utils, (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)class_1802.field_8687.method_7854()), new RangeValue(this.price), item, new RangeValue(1.0f), this.maxUses, this.xp, this.priceMultiplier, condition);
        }
        return new MissingNode();
    }

    @Override
    public Pair<List<class_1792>, List<class_1792>> collectItems(IServerUtils utils) {
        List<class_1792> items = PluginUtils.getItems(utils, this.lazyItem.getItem());
        if (this.outline == SELL_FOR_ONE_EMERALD || this.outline == SELL_FOR_MANY_EMERALDS) {
            return new Pair(items, List.of(class_1802.field_8687));
        }
        if (this.outline == BUY_FOR_ONE_EMERALD || this.outline == BUY_FOR_MANY_EMERALDS) {
            return new Pair(List.of(class_1802.field_8687), items);
        }
        return new Pair(List.of(), List.of());
    }

    static {
        Field typeMapField;
        Class<?> tradesClass;
        LOGGER = LogUtils.getLogger();
        Object sellForOneEmerald = null;
        Object sellForManyEmeralds = null;
        Object buyForOneEmerald = null;
        Object buyForManyEmeralds = null;
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages");
            typeMapField = tradesClass.getDeclaredField("SELL_FOR_ONE_EMERALD");
            typeMapField.setAccessible(true);
            sellForOneEmerald = typeMapField.get(null);
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to obtain trade outline SELL_FOR_ONE_EMERALD: {}", (Object)e.getMessage());
        }
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages");
            typeMapField = tradesClass.getDeclaredField("SELL_FOR_MANY_EMERALDS");
            typeMapField.setAccessible(true);
            sellForManyEmeralds = typeMapField.get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.warn("Unable to obtain trade outline SELL_FOR_MANY_EMERALDS: {}", (Object)e.getMessage());
        }
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages");
            typeMapField = tradesClass.getDeclaredField("BUY_FOR_ONE_EMERALD");
            typeMapField.setAccessible(true);
            buyForOneEmerald = typeMapField.get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.warn("Unable to obtain trade outline BUY_FOR_ONE_EMERALD: {}", (Object)e.getMessage());
        }
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages");
            typeMapField = tradesClass.getDeclaredField("BUY_FOR_MANY_EMERALDS");
            typeMapField.setAccessible(true);
            buyForOneEmerald = typeMapField.get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.warn("Unable to obtain trade outline BUY_FOR_MANY_EMERALDS: {}", (Object)e.getMessage());
        }
        SELL_FOR_ONE_EMERALD = sellForOneEmerald;
        SELL_FOR_MANY_EMERALDS = sellForManyEmeralds;
        BUY_FOR_ONE_EMERALD = buyForOneEmerald;
        BUY_FOR_MANY_EMERALDS = buyForManyEmeralds;
    }
}

