/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.api.WidgetDirection;
import com.yanny.ali.plugin.client.widget.TextureWidget;
import com.yanny.ali.plugin.common.NodeUtils;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class WidgetUtils {
    public static final class_2960 TEXTURE_LOC = Utils.modLoc("textures/gui/gui.png");
    private static final int GROUP_WIDGET_WIDTH = 7;
    private static final int GROUP_WIDGET_HEIGHT = 18;

    @NotNull
    public static IWidget getAllWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 0, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getRandomWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 7, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getSequentialWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 14, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getAlternativesWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 21, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getDynamicWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 28, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getUnknownWidget(RelativeRect rect, IDataNode node) {
        return new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 18, 18, rect), 30, 0);
    }

    @NotNull
    public static IWidget getMissingWidget(RelativeRect rect) {
        return new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 18, 18, rect), 48, 0);
    }

    @NotNull
    public static IWidget getEmptyWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 18, 18, rect), 66, 0);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getArrowWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 24, 18, rect), 53, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getLevelWidget(RelativeRect rect, IDataNode node, int level) {
        final RelativeRect r = new RelativeRect(0, 0, 18, 18, rect);
        final List<class_2561> components = NodeUtils.toComponents(node.getTooltip(), 0, class_310.method_1551().field_1690.field_1827);
        final String txt = Integer.toString(level);
        final int txtWidth = class_310.method_1551().field_1772.method_1727(txt);
        return new IWidget(){

            @Override
            public RelativeRect getRect() {
                return r;
            }

            @Override
            public WidgetDirection getDirection() {
                return WidgetDirection.VERTICAL;
            }

            @Override
            public List<class_2561> getTooltipComponents(int mouseX, int mouseY) {
                return components;
            }

            @Override
            public void render(class_332 guiGraphics, int mouseX, int mouseY) {
                guiGraphics.method_48587(TEXTURE_LOC, r.getX(), r.getY(), r.width, r.height, 2, 2, 2, 2, 18, 18, 35, 18);
                guiGraphics.method_51433(class_310.method_1551().field_1772, txt, r.getX() + (r.width - txtWidth) / 2, r.getY() + 9, 0, false);
            }
        };
    }
}

