/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_165;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3853;
import net.minecraft.class_3956;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_6880;
import net.minecraft.class_69;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_83;
import net.minecraft.class_85;
import net.minecraft.class_91;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import oshi.util.tuples.Pair;

public class ItemCollectorUtils {
    @NotNull
    public static List<class_1792> collectLootTable(IServerUtils utils, class_52 lootTable) {
        LinkedList<class_1792> result = new LinkedList<class_1792>();
        for (class_55 pool : utils.getLootPools(lootTable)) {
            result.addAll(ItemCollectorUtils.collectLootPool(utils, pool));
        }
        result.addAll(Arrays.stream(lootTable.field_944).map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    @NotNull
    public static List<class_1792> collectLootPool(IServerUtils utils, class_55 pool) {
        LinkedList<class_1792> result = new LinkedList<class_1792>();
        for (class_79 entry : pool.field_953) {
            result.addAll(utils.collectItems(utils, entry));
        }
        result.addAll(Arrays.stream(pool.field_956).map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    @NotNull
    public static List<class_1792> collectItems(IServerUtils utils, class_77 entry) {
        LinkedList<class_1792> result = new LinkedList<class_1792>(List.of(entry.field_987));
        result.addAll(Arrays.stream(entry.field_996).map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    @NotNull
    public static List<class_1792> collectTags(IServerUtils utils, class_91 entry) {
        LinkedList<class_1792> result = new LinkedList<class_1792>(class_7923.field_41178.method_40266(entry.field_1005).map(tag -> tag.method_40239().map(class_6880::comp_349).toList()).orElse(List.of()));
        result.addAll(Arrays.stream(entry.field_996).map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    @NotNull
    public static List<class_1792> collectComposite(IServerUtils utils, class_69 entry) {
        LinkedList<class_1792> result = new LinkedList<class_1792>();
        for (class_79 child : entry.field_982) {
            result.addAll(utils.collectItems(utils, child));
        }
        return result;
    }

    public static @Unmodifiable @NotNull List<class_1792> collectSingleton(IServerUtils utils, class_85 entry) {
        return Arrays.stream(entry.field_996).map(f -> utils.collectItems(utils, List.of(), f)).flatMap(Collection::stream).toList();
    }

    @NotNull
    public static List<class_1792> collectReference(IServerUtils utils, class_83 entry) {
        LinkedList<class_1792> result = new LinkedList<class_1792>();
        class_52 lootTable = utils.getLootTable(entry.field_993);
        if (lootTable != null) {
            result.addAll(ItemCollectorUtils.collectLootTable(utils, lootTable));
            result.addAll(Arrays.stream(entry.field_996).map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        }
        return result;
    }

    @NotNull
    public static List<class_1792> collectFurnaceSmelt(IServerUtils utils, List<class_1792> items, class_165 function) {
        class_3218 level = utils.getServerLevel();
        if (level != null) {
            return items.stream().map(i -> level.method_8433().method_8132(class_3956.field_17546, (class_1263)new class_1277(new class_1799[]{i.method_7854()}), (class_1937)level).map(l -> List.of(l.method_8110(utils.getServerLevel().method_30349()).method_7909())).orElse(List.of())).flatMap(Collection::stream).toList();
        }
        return List.of();
    }

    @NotNull
    public static Pair<List<class_1792>, List<class_1792>> collectTradeItems(IServerUtils utils, Int2ObjectMap<class_3853.class_1652[]> itemLists) {
        ArrayList inputs = new ArrayList();
        ArrayList outputs = new ArrayList();
        ObjectIterator objectIterator = itemLists.values().iterator();
        while (objectIterator.hasNext()) {
            class_3853.class_1652[] itemListings;
            for (class_3853.class_1652 itemListing : itemListings = (class_3853.class_1652[])objectIterator.next()) {
                Pair<List<class_1792>, List<class_1792>> pair = utils.collectItems(utils, itemListing);
                inputs.addAll((Collection)pair.getA());
                outputs.addAll((Collection)pair.getB());
            }
        }
        return new Pair(inputs, outputs);
    }
}

