/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.tooltip.BranchTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ComponentTooltipNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_137;
import net.minecraft.class_1799;
import net.minecraft.class_2022;
import net.minecraft.class_2025;
import net.minecraft.class_2035;
import net.minecraft.class_2040;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2102;
import net.minecraft.class_2105;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3735;
import net.minecraft.class_3837;
import net.minecraft.class_42;
import net.minecraft.class_4550;
import net.minecraft.class_4551;
import net.minecraft.class_4552;
import net.minecraft.class_4553;
import net.minecraft.class_4559;
import net.minecraft.class_4965;
import net.minecraft.class_5321;
import net.minecraft.class_5658;
import net.minecraft.class_6404;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7376;
import net.minecraft.class_7383;
import net.minecraft.class_8129;
import net.minecraft.class_94;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueTooltipUtils {
    @NotNull
    public static IKeyTooltipNode getFormulaTooltip(IServerUtils utils, class_94.class_96 formula) {
        IKeyTooltipNode tooltip = utils.getValueTooltip(utils, formula.method_466());
        if (formula instanceof class_94.class_95) {
            class_94.class_95 binomialWithBonusCount = (class_94.class_95)formula;
            tooltip.add(utils.getValueTooltip(utils, binomialWithBonusCount.field_1014).build("ali.property.value.extra_rounds"));
            tooltip.add(utils.getValueTooltip(utils, Float.valueOf(binomialWithBonusCount.field_1012)).build("ali.property.value.probability"));
        } else if (formula instanceof class_94.class_100) {
            class_94.class_100 uniformBonusCount = (class_94.class_100)formula;
            tooltip.add(utils.getValueTooltip(utils, uniformBonusCount.field_1017).build("ali.property.value.bonus_multiplier"));
        }
        return tooltip;
    }

    @NotNull
    public static IKeyTooltipNode getPropertyTooltip(IServerUtils utils, class_2769<?> property) {
        return utils.getValueTooltip(utils, property.method_11899());
    }

    @NotNull
    public static IKeyTooltipNode getModifierTooltip(IServerUtils utils, class_137.class_138 modifier) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, modifier.field_1107).build("ali.property.value.name")).add(utils.getValueTooltip(utils, modifier.field_1110).build("ali.property.value.attribute")).add(utils.getValueTooltip(utils, modifier.field_1109).build("ali.property.value.operation")).add(utils.getValueTooltip(utils, modifier.field_1108).build("ali.property.value.amount")).add(utils.getValueTooltip(utils, modifier.field_1111).build("ali.property.value.uuid")).add(utils.getValueTooltip(utils, Arrays.asList(modifier.field_1112)).build("ali.property.branch.equipment_slots"));
    }

    @NotNull
    public static IKeyTooltipNode getUUIDTooltip(IServerUtils ignoredUtils, UUID uuid) {
        return ValueTooltipNode.value(uuid);
    }

    @NotNull
    public static IKeyTooltipNode getPairTooltip(IServerUtils utils, Pair<?, ?> pair) {
        IKeyTooltipNode tooltip = utils.getValueTooltip(utils, pair.getFirst());
        tooltip.add(utils.getValueTooltip(utils, pair.getSecond()).build("ali.property.value.color"));
        return tooltip;
    }

    @NotNull
    public static IKeyTooltipNode getStatePropertiesPredicateTooltip(IServerUtils utils, class_4559 propertiesPredicate) {
        return GenericTooltipUtils.getCollectionTooltip(utils, propertiesPredicate.field_20737, GenericTooltipUtils::getPropertyMatcherTooltip);
    }

    @NotNull
    public static IKeyTooltipNode getDamageSourcePredicateTooltip(IServerUtils utils, class_2022 damagePredicate) {
        if (damagePredicate != class_2022.field_9533) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, damagePredicate.field_42272).build("ali.property.branch.tags")).add(utils.getValueTooltip(utils, damagePredicate.field_9534).build("ali.property.branch.direct_entity")).add(utils.getValueTooltip(utils, damagePredicate.field_9539).build("ali.property.branch.source_entity"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static <T> IKeyTooltipNode getTagPredicateTooltip(IServerUtils ignoredUtils, class_8129<T> tagPredicate) {
        return ValueTooltipNode.keyValue(tagPredicate.field_42477.comp_327().toString(), Boolean.toString(tagPredicate.field_42478));
    }

    @NotNull
    public static IKeyTooltipNode getEntityPredicateTooltip(IServerUtils utils, class_2048 entityPredicate) {
        if (entityPredicate != class_2048.field_9599) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, entityPredicate.field_9595).build("ali.property.value.entity_type")).add(utils.getValueTooltip(utils, entityPredicate.field_9601).build("ali.property.branch.distance_to_player")).add(utils.getValueTooltip(utils, entityPredicate.field_9596).build("ali.property.branch.location")).add(utils.getValueTooltip(utils, entityPredicate.field_33912).build("ali.property.branch.stepping_on_location")).add(utils.getValueTooltip(utils, entityPredicate.field_9594).build("ali.property.branch.mob_effects")).add(utils.getValueTooltip(utils, entityPredicate.field_9600).build("ali.property.value.nbt")).add(utils.getValueTooltip(utils, entityPredicate.field_9597).build("ali.property.branch.entity_flags")).add(utils.getValueTooltip(utils, entityPredicate.field_16490).build("ali.property.branch.entity_equipment")).add(utils.getValueTooltip(utils, entityPredicate.field_38721).build("ali.property.branch.entity_sub_predicate")).add(utils.getValueTooltip(utils, entityPredicate.field_24488).build("ali.property.branch.vehicle")).add(utils.getValueTooltip(utils, entityPredicate.field_33914).build("ali.property.branch.passenger")).add(utils.getValueTooltip(utils, entityPredicate.field_24489).build("ali.property.branch.targeted_entity")).add(utils.getValueTooltip(utils, entityPredicate.field_20698).build("ali.property.value.team"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getEntityTypePredicateTooltip(IServerUtils utils, class_2050 entityTypePredicate) {
        if (entityTypePredicate != class_2050.field_9609) {
            if (entityTypePredicate instanceof class_2050.class_2052) {
                class_2050.class_2052 typePredicate = (class_2050.class_2052)entityTypePredicate;
                return utils.getValueTooltip(utils, typePredicate.field_9611);
            }
            if (entityTypePredicate instanceof class_2050.class_2051) {
                class_2050.class_2051 tagPredicate = (class_2050.class_2051)entityTypePredicate;
                return utils.getValueTooltip(utils, tagPredicate.field_9610);
            }
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getDistancePredicateTooltip(IServerUtils utils, class_2025 distancePredicate) {
        if (distancePredicate != class_2025.field_9553) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, distancePredicate.field_9554).build("ali.property.value.x")).add(utils.getValueTooltip(utils, distancePredicate.field_9555).build("ali.property.value.y")).add(utils.getValueTooltip(utils, distancePredicate.field_9552).build("ali.property.value.z")).add(utils.getValueTooltip(utils, distancePredicate.field_9557).build("ali.property.value.horizontal")).add(utils.getValueTooltip(utils, distancePredicate.field_9556).build("ali.property.value.absolute"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getLocationPredicateTooltip(IServerUtils utils, class_2090 locationPredicate) {
        if (locationPredicate != class_2090.field_9685) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, locationPredicate.field_9682).build("ali.property.value.x")).add(utils.getValueTooltip(utils, locationPredicate.field_9684).build("ali.property.value.y")).add(utils.getValueTooltip(utils, locationPredicate.field_9681).build("ali.property.value.z")).add(utils.getValueTooltip(utils, locationPredicate.field_9683).build("ali.property.value.biome")).add(utils.getValueTooltip(utils, locationPredicate.field_9687).build("ali.property.value.structure")).add(utils.getValueTooltip(utils, locationPredicate.field_9686).build("ali.property.value.dimension")).add(utils.getValueTooltip(utils, locationPredicate.field_24500).build("ali.property.value.smokey")).add(utils.getValueTooltip(utils, locationPredicate.field_20714).build("ali.property.value.light")).add(utils.getValueTooltip(utils, locationPredicate.field_20715).build("ali.property.branch.block_predicate")).add(utils.getValueTooltip(utils, locationPredicate.field_20716).build("ali.property.branch.fluid_predicate"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getLightPredicateTooltip(IServerUtils utils, class_4552 lightPredicate) {
        if (lightPredicate != class_4552.field_20712) {
            return utils.getValueTooltip(utils, lightPredicate.field_20713);
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getBlockPredicateTooltip(IServerUtils utils, class_4550 blockPredicate) {
        if (blockPredicate != class_4550.field_20692) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, blockPredicate.field_20693).build("ali.property.value.tag")).add(utils.getValueTooltip(utils, blockPredicate.field_20694).build("ali.property.branch.blocks")).add(utils.getValueTooltip(utils, blockPredicate.field_20695).build("ali.property.branch.properties")).add(utils.getValueTooltip(utils, blockPredicate.field_20696).build("ali.property.value.nbt"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getNbtPredicateTooltip(IServerUtils utils, class_2105 nbtPredicate) {
        if (nbtPredicate != class_2105.field_9716) {
            return utils.getValueTooltip(utils, nbtPredicate.field_9715);
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getFluidPredicateTooltip(IServerUtils utils, class_4551 fluidPredicate) {
        if (fluidPredicate != class_4551.field_20708) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, fluidPredicate.field_20709).build("ali.property.value.tag")).add(utils.getValueTooltip(utils, fluidPredicate.field_20710).build("ali.property.value.fluid")).add(utils.getValueTooltip(utils, fluidPredicate.field_20711).build("ali.property.branch.properties"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getMobEffectPredicateTooltip(IServerUtils utils, class_2102 mobEffectsPredicate) {
        if (mobEffectsPredicate != class_2102.field_9709) {
            return GenericTooltipUtils.getMapTooltip(utils, mobEffectsPredicate.field_9710, GenericTooltipUtils::getMobEffectPredicateEntryTooltip);
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getEntityFlagsPredicateTooltip(IServerUtils utils, class_2040 predicate) {
        if (predicate != class_2040.field_9581) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, predicate.field_9580).build("ali.property.value.is_on_fire")).add(utils.getValueTooltip(utils, predicate.field_9583).build("ali.property.value.is_baby")).add(utils.getValueTooltip(utils, predicate.field_9582).build("ali.property.value.is_crouching")).add(utils.getValueTooltip(utils, predicate.field_9579).build("ali.property.value.is_sprinting")).add(utils.getValueTooltip(utils, predicate.field_9578).build("ali.property.value.is_swimming"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getEntityEquipmentPredicateTooltip(IServerUtils utils, class_3735 predicate) {
        if (predicate != class_3735.field_16485) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, predicate.field_16483).build("ali.property.branch.head")).add(utils.getValueTooltip(utils, predicate.field_16487).build("ali.property.branch.chest")).add(utils.getValueTooltip(utils, predicate.field_16488).build("ali.property.branch.legs")).add(utils.getValueTooltip(utils, predicate.field_16489).build("ali.property.branch.feet")).add(utils.getValueTooltip(utils, predicate.field_16486).build("ali.property.branch.mainhand")).add(utils.getValueTooltip(utils, predicate.field_16484).build("ali.property.branch.offhand"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getItemPredicateTooltip(IServerUtils utils, class_2073 itemPredicate) {
        if (itemPredicate != class_2073.field_9640) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, itemPredicate.field_9643).build("ali.property.value.tag")).add(utils.getValueTooltip(utils, itemPredicate.field_9644).build("ali.property.branch.items")).add(utils.getValueTooltip(utils, itemPredicate.field_9641).build("ali.property.value.count")).add(utils.getValueTooltip(utils, itemPredicate.field_9646).build("ali.property.value.durability")).add(utils.getValueTooltip(utils, Arrays.asList(itemPredicate.field_9647)).build("ali.property.branch.enchantments")).add(utils.getValueTooltip(utils, Arrays.asList(itemPredicate.field_20689)).build("ali.property.branch.stored_enchantments")).add(utils.getValueTooltip(utils, itemPredicate.field_9642).build("ali.property.value.potion")).add(utils.getValueTooltip(utils, itemPredicate.field_9645).build("ali.property.value.nbt"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getEnchantmentPredicateTooltip(IServerUtils utils, class_2035 enchantmentPredicate) {
        if (enchantmentPredicate != class_2035.field_9571) {
            return utils.getValueTooltip(utils, Objects.requireNonNullElse(enchantmentPredicate.field_9569, class_2561.method_43471((String)"ali.util.advanced_loot_info.any"))).add(utils.getValueTooltip(utils, enchantmentPredicate.field_9570).build("ali.property.value.level"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getEntitySubPredicateTooltip(IServerUtils utils, class_7376 entitySubPredicate) {
        if (entitySubPredicate != class_7376.field_38723) {
            Optional<Map.Entry> optional = class_7376.class_7378.field_38731.entrySet().stream().filter(p -> p.getValue() == entitySubPredicate.method_43099()).findFirst();
            return optional.map(entry -> {
                BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
                if (entitySubPredicate instanceof class_6404) {
                    class_6404 boltPredicate = (class_6404)entitySubPredicate;
                    tooltip.add(utils.getValueTooltip(utils, boltPredicate.field_33923).build("ali.property.value.blocks_on_fire"));
                    tooltip.add(utils.getValueTooltip(utils, boltPredicate.field_33924).build("ali.property.branch.stuck_entity"));
                } else if (entitySubPredicate instanceof class_4965) {
                    class_4965 fishingHookPredicate = (class_4965)entitySubPredicate;
                    tooltip.add(utils.getValueTooltip(utils, fishingHookPredicate.field_23138).build("ali.property.value.in_open_water"));
                } else if (entitySubPredicate instanceof class_4553) {
                    class_4553 playerPredicate = (class_4553)entitySubPredicate;
                    tooltip.add(utils.getValueTooltip(utils, playerPredicate.field_20723).build("ali.property.value.level"));
                    tooltip.add(utils.getValueTooltip(utils, playerPredicate.field_20724).build("ali.property.value.game_type"));
                    tooltip.add(GenericTooltipUtils.getStatsTooltip(utils, playerPredicate.field_20725).build("ali.property.branch.stats"));
                    tooltip.add(GenericTooltipUtils.getMapTooltip(utils, playerPredicate.field_20726, GenericTooltipUtils::getRecipeEntryTooltip).build("ali.property.branch.recipes"));
                    tooltip.add(GenericTooltipUtils.getMapTooltip(utils, playerPredicate.field_20727, GenericTooltipUtils::getAdvancementEntryTooltip).build("ali.property.branch.advancements"));
                    tooltip.add(utils.getValueTooltip(utils, playerPredicate.field_33929).build("ali.property.branch.looking_at"));
                } else if (entitySubPredicate instanceof class_7383) {
                    class_7383 slimePredicate = (class_7383)entitySubPredicate;
                    tooltip.add(utils.getValueTooltip(utils, slimePredicate.field_38759).build("ali.property.value.size"));
                } else {
                    JsonObject jsonObject = entitySubPredicate.method_22494();
                    if (jsonObject.has("variant")) {
                        tooltip.add(utils.getValueTooltip(utils, jsonObject.getAsJsonPrimitive("variant").getAsString()).build("ali.property.value.variant"));
                    } else {
                        tooltip.add(utils.getValueTooltip(utils, jsonObject.getAsString()).build("ali.property.value.variant"));
                    }
                }
                return tooltip;
            }).orElse(EmptyTooltipNode.empty());
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getBlockPosTooltip(IServerUtils ignoredUtils, class_2338 pos) {
        return ValueTooltipNode.value(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    @NotNull
    public static IKeyTooltipNode getCopyOperationTooltip(IServerUtils utils, class_3837.class_3839 copyOperation) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, copyOperation.field_17019).build("ali.property.value.source")).add(utils.getValueTooltip(utils, copyOperation.field_17021).build("ali.property.value.target")).add(utils.getValueTooltip(utils, copyOperation.field_17023).build("ali.property.value.merge_strategy"));
    }

    @NotNull
    public static IKeyTooltipNode getCompoundTagTooltip(IServerUtils utils, class_2487 tag) {
        return utils.getValueTooltip(utils, tag.toString());
    }

    @NotNull
    public static IKeyTooltipNode getAdvancementPredicateTooltip(IServerUtils utils, class_4553.class_4556 predicate) {
        if (predicate instanceof class_4553.class_4555) {
            class_4553.class_4555 donePredicate = (class_4553.class_4555)predicate;
            return utils.getValueTooltip(utils, donePredicate.field_20729);
        }
        if (predicate instanceof class_4553.class_4554) {
            class_4553.class_4554 criterionsPredicate = (class_4553.class_4554)predicate;
            return GenericTooltipUtils.getMapTooltip(utils, criterionsPredicate.field_20728, GenericTooltipUtils::getCriterionEntryTooltip);
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getItemStackTooltip(IServerUtils utils, class_1799 item) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, item.method_7909()).build("ali.property.value.item")).add(utils.getValueTooltip(utils, item.method_7947()).build("ali.property.value.count")).add(utils.getValueTooltip(utils, item.method_7969()).build("ali.property.value.tag"));
    }

    @NotNull
    public static IKeyTooltipNode getNumberProviderTooltip(IServerUtils utils, class_5658 value) {
        return ValueTooltipNode.value(utils.convertNumber(utils, value));
    }

    @NotNull
    public static IKeyTooltipNode getIntRangeTooltip(IServerUtils utils, class_42 range) {
        return ValueTooltipNode.value(RangeValue.rangeToString(utils.convertNumber(utils, range.field_921), utils.convertNumber(utils, range.field_920)));
    }

    @NotNull
    public static IKeyTooltipNode getBooleanTooltip(IServerUtils ignoredUtils, Boolean value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getIntegerTooltip(IServerUtils ignoredUtils, int value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getLongTooltip(IServerUtils ignoredUtils, Long value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getByteTooltip(IServerUtils ignoredUtils, Byte value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getStringTooltip(IServerUtils ignoredUtils, String value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getFloatTooltip(IServerUtils ignoredUtils, Float value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getDoubleTooltip(IServerUtils ignoredUtils, Double value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getEnumTooltip(IServerUtils ignoredUtils, Enum<?> value) {
        return ValueTooltipNode.value(value.name());
    }

    @NotNull
    public static IKeyTooltipNode getResourceLocationTooltip(IServerUtils ignoredUtils, class_2960 value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static <T> IKeyTooltipNode getBuiltInRegistryTooltip(IServerUtils utils, class_2378<T> registry, T value) {
        return utils.getValueTooltip(utils, registry.method_10221(value));
    }

    @NotNull
    public static <T> IKeyTooltipNode getResourceKeyTooltip(IServerUtils utils, class_5321<T> value) {
        return utils.getValueTooltip(utils, value.method_29177());
    }

    @NotNull
    public static IKeyTooltipNode getTagKeyTooltip(IServerUtils utils, class_6862<?> value) {
        return utils.getValueTooltip(utils, value.comp_327());
    }

    @NotNull
    public static IKeyTooltipNode getComponentTooltip(IServerUtils ignoredUtils, class_2561 component) {
        return ComponentTooltipNode.values(new class_2561[]{component.method_27661()});
    }

    @NotNull
    public static IKeyTooltipNode getMinMaxBoundsTooltip(IServerUtils ignoredUtils, class_2096.class_2100 ints) {
        if (ints != class_2096.class_2100.field_9708) {
            return ValueTooltipNode.value(GenericTooltipUtils.toString(ints));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getMinMaxBoundsTooltip(IServerUtils ignoredUtils, class_2096.class_2099 doubles) {
        if (doubles != class_2096.class_2099.field_9705) {
            return ValueTooltipNode.value(GenericTooltipUtils.toString(doubles));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static <T> IKeyTooltipNode getHolderTooltip(IServerUtils utils, class_6880<T> holder) {
        return utils.getValueTooltip(utils, holder.comp_349());
    }

    @NotNull
    public static <T> IKeyTooltipNode getOptionalTooltip(IServerUtils utils, Optional<T> optional) {
        return optional.map(v -> utils.getValueTooltip(utils, v)).orElse(EmptyTooltipNode.empty());
    }

    @NotNull
    public static IKeyTooltipNode getCollectionTooltip(IServerUtils utils, @Nullable Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return EmptyTooltipNode.empty();
        }
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        for (Object o : collection) {
            tooltip.add(utils.getValueTooltip(utils, o).build("ali.property.value.null"));
        }
        return tooltip;
    }
}

