/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.manager.AliServerRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.DoneMessage;
import com.yanny.ali.network.SyncLootTableMessage;
import com.yanny.ali.network.SyncTradeMessage;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.server.ItemCollectorUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9383;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

public abstract class AbstractServer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<SyncLootTableMessage> lootTableMessages = new LinkedList<SyncLootTableMessage>();
    private final List<SyncTradeMessage> tradeMessages = new LinkedList<SyncTradeMessage>();

    public final void readLootTables(class_9383.class_9385 manager, class_3218 level) {
        AliServerRegistry serverRegistry = PluginManager.SERVER_REGISTRY;
        Map<class_2960, class_52> lootTables = AbstractServer.collectLootTables(manager);
        HashMap<class_2960, IDataNode> lootNodes = new HashMap<class_2960, IDataNode>();
        HashMap<class_2960, class_52> unprocessedLootTables = new HashMap<class_2960, class_52>(lootTables);
        List<ILootModifier<?>> lootModifiers = serverRegistry.getLootModifiers();
        Map<ILootModifier.IType, List<ILootModifier>> groupedTypes = lootModifiers.stream().collect(Collectors.groupingBy(ILootModifier::getType));
        List<ILootModifier<?>> blockLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.BLOCK, Collections.emptyList());
        List<ILootModifier<?>> entityLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.ENTITY, Collections.emptyList());
        List<ILootModifier<?>> lootTableLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.LOOT_TABLE, Collections.emptyList());
        HashMap<class_2960, Pair<List<class_1792>, List<class_1792>>> tradeItems = new HashMap<class_2960, Pair<List<class_1792>, List<class_1792>>>();
        Pair<List<class_1792>, List<class_1792>> wanderingTraderItems = ItemCollectorUtils.collectTradeItems(serverRegistry, (Int2ObjectMap<class_3853.class_1652[]>)class_3853.field_17724);
        IDataNode wanderingTraderNode = AbstractServer.processWanderingTrader(serverRegistry);
        serverRegistry.setServerLevel(level);
        lootTables.forEach(serverRegistry::addLootTable);
        Map<class_2960, List<class_1792>> lootTableItems = lootTables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, AbstractServer::getItems));
        this.lootTableMessages.clear();
        this.tradeMessages.clear();
        lootNodes.putAll(AbstractServer.processBlocks(serverRegistry, unprocessedLootTables, blockLootModifiers, lootTableLootModifiers, lootTableItems));
        lootNodes.putAll(AbstractServer.processEntities(serverRegistry, level, unprocessedLootTables, entityLootModifiers, lootTableLootModifiers, lootTableItems));
        lootNodes.putAll(AbstractServer.processLootTables(serverRegistry, unprocessedLootTables, lootTableLootModifiers, lootTableItems));
        Map<class_2960, List<class_1799>> lootTableItemStacks = lootNodes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> AbstractServer.collectItems((IDataNode)e.getValue())));
        lootTables = AbstractServer.removeEmptyLootTable(lootTables, lootTableItemStacks);
        HashMap<class_2960, IDataNode> tradeNodes = new HashMap<class_2960, IDataNode>(AbstractServer.processTrades(serverRegistry, tradeItems));
        this.sendLootData(lootTables, lootTableItemStacks, lootNodes);
        this.sendTradeData(tradeNodes, tradeItems, wanderingTraderNode, wanderingTraderItems);
        serverRegistry.printRuntimeInfo();
    }

    public final void syncLootTables(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.sendClearMessage(serverPlayer, new ClearMessage());
            for (SyncLootTableMessage syncLootTableMessage : this.lootTableMessages) {
                try {
                    this.sendSyncLootTableMessage(serverPlayer, syncLootTableMessage);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LOGGER.warn("Failed to send message for loot table {} with error: {}", (Object)syncLootTableMessage.location(), (Object)e.getMessage());
                }
            }
            for (SyncTradeMessage syncTradeMessage : this.tradeMessages) {
                try {
                    this.sendSyncTradeMessage(serverPlayer, syncTradeMessage);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LOGGER.warn("Failed to send message for trade {} with error: {}", (Object)syncTradeMessage.location(), (Object)e.getMessage());
                }
            }
            this.sendDoneMessage(serverPlayer, new DoneMessage());
        }
    }

    protected abstract void sendClearMessage(class_3222 var1, ClearMessage var2);

    protected abstract void sendSyncLootTableMessage(class_3222 var1, SyncLootTableMessage var2);

    protected abstract void sendSyncTradeMessage(class_3222 var1, SyncTradeMessage var2);

    protected abstract void sendDoneMessage(class_3222 var1, DoneMessage var2);

    @NotNull
    private static List<class_1792> getItems(Map.Entry<class_2960, class_52> lootTableMap) {
        return ItemCollectorUtils.collectLootTable(PluginManager.SERVER_REGISTRY, lootTableMap.getValue());
    }

    @NotNull
    private static Map<class_2960, class_52> removeEmptyLootTable(Map<class_2960, class_52> lootTables, Map<class_2960, List<class_1799>> items) {
        HashMap<class_2960, class_52> result = new HashMap<class_2960, class_52>();
        for (Map.Entry<class_2960, class_52> entry : lootTables.entrySet()) {
            if (!items.getOrDefault(entry.getKey(), Collections.emptyList()).isEmpty()) {
                result.put(entry.getKey(), entry.getValue());
                continue;
            }
            LOGGER.info("Skipping empty loot table {}", (Object)entry.getKey());
        }
        return result;
    }

    @NotNull
    private static Map<class_2960, class_52> collectLootTables(class_9383.class_9385 manager) {
        HashMap<class_2960, class_52> lootTables = new HashMap<class_2960, class_52>();
        manager.method_58289().method_46759(class_7924.field_50079).ifPresent(lookup -> lookup.method_42017().forEach(reference -> lootTables.put(reference.method_40237().method_29177(), (class_52)reference.comp_349())));
        return lootTables;
    }

    @NotNull
    private static Map<class_2960, IDataNode> processBlocks(AliServerRegistry serverRegistry, Map<class_2960, class_52> lootTables, List<ILootModifier<?>> blockLootModifiers, List<ILootModifier<?>> lootTableLootModifiers, Map<class_2960, List<class_1792>> lootTableItems) {
        HashMap<class_2960, IDataNode> lootNodes = new HashMap<class_2960, IDataNode>();
        for (class_2248 block : class_7923.field_41175) {
            class_5321 resourceKey = block.method_26162();
            if (resourceKey == null) continue;
            class_2960 location = resourceKey.method_29177();
            class_52 lootTable = lootTables.remove(location);
            List<class_1792> items = lootTableItems.get(location);
            if (lootTable != null && items != null) {
                List<ILootModifier<?>> lootModifiers = Stream.concat(blockLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, block, items)), lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items))).toList();
                try {
                    lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LOGGER.warn("Failed to parse block loot table {} with error {}", (Object)location, (Object)e.getMessage());
                }
                continue;
            }
            LOGGER.debug("Missing block loot table for {}", (Object)block);
        }
        return lootNodes;
    }

    @NotNull
    private static Map<class_2960, IDataNode> processEntities(AliServerRegistry serverRegistry, class_3218 level, Map<class_2960, class_52> lootTables, List<ILootModifier<?>> entityLootModifiers, List<ILootModifier<?>> lootTableLootModifiers, Map<class_2960, List<class_1792>> lootTableItems) {
        HashMap<class_2960, IDataNode> lootNodes = new HashMap<class_2960, IDataNode>();
        for (class_1299 entityType : class_7923.field_41177) {
            List<class_1297> entityList = serverRegistry.createEntities(entityType, (class_1937)level);
            for (class_1297 entity : entityList) {
                class_1308 mob;
                class_5321 resourceKey;
                if (!(entity instanceof class_1308) || (resourceKey = (mob = (class_1308)entity).method_5989()) == null) continue;
                class_2960 location = resourceKey.method_29177();
                class_52 lootTable = lootTables.remove(location);
                List<class_1792> items = lootTableItems.get(location);
                if (lootTable != null && items != null) {
                    List<ILootModifier<?>> lootModifiers = Stream.concat(entityLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, entity, items)), lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items))).toList();
                    try {
                        lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        LOGGER.warn("Failed to parse entity loot table {} with error {}", (Object)location, (Object)e.getMessage());
                    }
                    continue;
                }
                LOGGER.debug("Missing entity loot table for {}", (Object)entity);
            }
        }
        return lootNodes;
    }

    @NotNull
    private static Map<class_2960, IDataNode> processLootTables(AliServerRegistry serverRegistry, Map<class_2960, class_52> lootTables, List<ILootModifier<?>> lootTableLootModifiers, Map<class_2960, List<class_1792>> lootTableItems) {
        HashMap<class_2960, IDataNode> lootNodes = new HashMap<class_2960, IDataNode>();
        for (Map.Entry<class_2960, class_52> entry : lootTables.entrySet()) {
            class_2960 location = entry.getKey();
            class_52 lootTable = entry.getValue();
            List<class_1792> items = lootTableItems.get(location);
            List<ILootModifier<?>> lootModifiers = lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items)).toList();
            try {
                lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOGGER.warn("Failed to parse loot table {} with error {}", (Object)location, (Object)e.getMessage());
            }
        }
        return lootNodes;
    }

    @NotNull
    private static Map<class_2960, IDataNode> processTrades(AliServerRegistry serverRegistry, Map<class_2960, Pair<List<class_1792>, List<class_1792>>> tradeItems) {
        HashMap<class_2960, IDataNode> nodes = new HashMap<class_2960, IDataNode>();
        for (Map.Entry entry : class_7923.field_41195.method_29722()) {
            class_2960 location = ((class_5321)entry.getKey()).method_29177();
            Int2ObjectMap itemListingMap = (Int2ObjectMap)class_3853.field_17067.get(entry.getValue());
            if (itemListingMap != null && itemListingMap.int2ObjectEntrySet().stream().anyMatch(e -> ((class_3853.class_1652[])e.getValue()).length > 0)) {
                try {
                    nodes.put(location, serverRegistry.parseTrade((Int2ObjectMap<class_3853.class_1652[]>)itemListingMap));
                    tradeItems.put(location, ItemCollectorUtils.collectTradeItems(serverRegistry, (Int2ObjectMap<class_3853.class_1652[]>)itemListingMap));
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                    LOGGER.warn("Failed to parse trade for villager {} with error {}", (Object)((class_3852)entry.getValue()).comp_818(), (Object)e2.getMessage());
                }
                continue;
            }
            LOGGER.warn("No trades defined for {}", (Object)location);
        }
        return nodes;
    }

    @NotNull
    private static IDataNode processWanderingTrader(AliServerRegistry serverRegistry) {
        try {
            return serverRegistry.parseTrade((Int2ObjectMap<class_3853.class_1652[]>)class_3853.field_17724);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.warn("Failed to parse wandering trader with error {}", (Object)e.getMessage());
            return new MissingNode();
        }
    }

    private static <T> boolean predicateModifier(ILootModifier<?> modifier, T value, List<class_1792> items) {
        return modifier.predicate(value) && AbstractServer.predicateItem(modifier, items);
    }

    private static boolean predicateItem(ILootModifier<?> modifier, List<class_1792> items) {
        if (!items.isEmpty()) {
            return items.stream().anyMatch(i -> modifier.getOperations().stream().anyMatch(o -> o.predicate().test(i.method_7854())));
        }
        return true;
    }

    @NotNull
    private static List<class_1799> collectItems(IDataNode node) {
        ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            for (IDataNode n : listNode.nodes()) {
                itemStacks.addAll(AbstractServer.collectItems(n));
            }
        } else if (node instanceof IItemNode) {
            IItemNode itemNode = (IItemNode)((Object)node);
            itemStacks.addAll((Collection)itemNode.getModifiedItem().map(List::of, AbstractServer::toItemStacks));
        }
        return itemStacks;
    }

    private void sendLootData(Map<class_2960, class_52> lootTables, Map<class_2960, List<class_1799>> lootTableItemStacks, Map<class_2960, IDataNode> lootNodes) {
        lootTables.forEach((location, lootTable) -> this.lootTableMessages.add(new SyncLootTableMessage((class_2960)location, lootTableItemStacks.getOrDefault(location, Collections.emptyList()), (IDataNode)lootNodes.get(location))));
    }

    private void sendTradeData(Map<class_2960, IDataNode> trades, Map<class_2960, Pair<List<class_1792>, List<class_1792>>> items, IDataNode wanderingTraderNode, Pair<List<class_1792>, List<class_1792>> wanderingTraderItems) {
        trades.forEach((location, node) -> this.tradeMessages.add(new SyncTradeMessage((class_2960)location, (IDataNode)node, (Pair<List<class_1792>, List<class_1792>>)((Pair)items.get(location)))));
        this.tradeMessages.add(new SyncTradeMessage(wanderingTraderNode, wanderingTraderItems));
    }

    private static <T extends class_1935> List<class_1799> toItemStacks(class_6862<T> tag) {
        class_2378 registry = (class_2378)class_7923.field_41167.method_10223(tag.comp_326().method_29177());
        if (registry != null) {
            return registry.method_40266(tag).map(holders -> holders.method_40239().map(class_6880::comp_349).map(i -> i.method_8389().method_7854()).toList()).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }
}

