/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.mods.immersive_engineering.trades;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.trades.ItemsToItemsNode;
import com.yanny.ali.plugin.common.trades.SubTradesNode;
import com.yanny.ali.plugin.mods.BaseAccessor;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.IItemListing;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3853;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

@ClassAccessor(value="blusunrize.immersiveengineering.common.world.Villages$RerollingItemListing")
public class RerollingItemListing
extends BaseAccessor<class_3853.class_1652>
implements IItemListing {
    private static final Logger LOGGER;
    private static final List<class_1792> ITEMS;
    private static final Object MAP_INSTANCE;
    private static final Object REVOLVER_INSTANCE;

    public RerollingItemListing(class_3853.class_1652 parent) {
        super(parent);
    }

    @Override
    @NotNull
    public IDataNode getNode(final IServerUtils utils, List<ITooltipNode> conditions) {
        return new SubTradesNode<RerollingItemListing>(utils, this, conditions){

            @Override
            public List<IDataNode> getSubTrades(IServerUtils ignoredUtils, RerollingItemListing ignoredListing) {
                ArrayList<IDataNode> nodes = new ArrayList<IDataNode>();
                if (RerollingItemListing.this.parent == MAP_INSTANCE) {
                    nodes.add(this.getMapListing());
                } else if (RerollingItemListing.this.parent == REVOLVER_INSTANCE) {
                    for (class_1792 item : ITEMS) {
                        nodes.add(this.getRevolverListing(item));
                    }
                }
                return nodes;
            }

            @NotNull
            private IDataNode getMapListing() {
                class_1799 map = class_1802.field_8895.method_7854();
                map.method_57379(class_9334.field_50239, (Object)class_2561.method_43471((String)"item.immersiveengineering.map_orevein"));
                return new ItemsToItemsNode(utils, (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)class_1802.field_8687.method_7854()), new RangeValue(8.0f, 16.0f), (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)map), new RangeValue(1.0f), 30, 1, 0.5f, Collections.emptyList());
            }

            @NotNull
            private IDataNode getRevolverListing(class_1792 item) {
                return new ItemsToItemsNode(utils, (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)class_1802.field_8687.method_7854()), new RangeValue(5.0f, 64.0f), (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)item.method_7854()), new RangeValue(1.0f), 30, 1, 0.5f, Collections.emptyList());
            }
        };
    }

    @Override
    public Pair<List<class_1792>, List<class_1792>> collectItems(IServerUtils utils) {
        if (this.parent == MAP_INSTANCE) {
            return new Pair(List.of(class_1802.field_8687), List.of(class_1802.field_8895));
        }
        if (this.parent == REVOLVER_INSTANCE) {
            return new Pair(List.of(class_1802.field_8687), ITEMS);
        }
        return new Pair(List.of(), List.of());
    }

    @NotNull
    private static class_1792 getItem(String name) {
        return (class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)"immersiveengineering", (String)name));
    }

    static {
        Field typeMapField;
        Class<?> tradesClass;
        LOGGER = LogUtils.getLogger();
        ITEMS = List.of(RerollingItemListing.getItem("gunpart_barrel"), RerollingItemListing.getItem("gunpart_drum"), RerollingItemListing.getItem("gunpart_hammer"));
        Object mapInstance = null;
        Object revolverInstance = null;
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages$OreveinMapForEmeralds");
            typeMapField = tradesClass.getDeclaredField("INSTANCE");
            typeMapField.setAccessible(true);
            mapInstance = typeMapField.get(null);
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to obtain map instance: {}", (Object)e.getMessage());
        }
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages$RevolverPieceForEmeralds");
            typeMapField = tradesClass.getDeclaredField("INSTANCE");
            typeMapField.setAccessible(true);
            revolverInstance = typeMapField.get(null);
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to obtain revolver instance: {}", (Object)e.getMessage());
        }
        MAP_INSTANCE = mapInstance;
        REVOLVER_INSTANCE = revolverInstance;
    }
}

