/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootPoolNode
extends ListNode {
    public static final ResourceLocation ID = ResourceLocation.m_339182_((String)"ali", (String)"loot_pool");
    private final List<ITooltipNode> tooltip;

    public LootPoolNode(List<ILootModifier<?>> modifiers, IServerUtils utils, LootPool lootPool, float chance, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        List<LootItemFunction> allFunctions = Stream.concat(functions.stream(), lootPool.f_79026_.stream()).toList();
        List<LootItemCondition> allConditions = Stream.concat(conditions.stream(), lootPool.f_79024_.stream()).toList();
        int sumWeight = NodeUtils.getTotalWeight(lootPool.f_79023_);
        this.tooltip = EntryTooltipUtils.getLootPoolTooltip(utils.convertNumber(utils, lootPool.f_79028_), utils.convertNumber(utils, lootPool.f_79029_));
        for (LootPoolEntryContainer entry : lootPool.f_79023_) {
            this.addChildren(utils.getEntryFactory(utils, entry).create(utils, entry, chance, sumWeight, allFunctions, allConditions));
        }
    }

    public LootPoolNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        super(utils, buf);
        this.tooltip = NodeUtils.decodeTooltipNodes(utils, buf);
    }

    @Override
    public void encodeNode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        NodeUtils.encodeTooltipNodes(utils, buf, this.tooltip);
    }

    @Override
    public List<ITooltipNode> getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

