/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ReferenceNode
extends ListNode {
    public static final ResourceLocation ID = ResourceLocation.m_339182_((String)"ali", (String)"reference");
    private final List<ITooltipNode> tooltip;
    private final float chance;

    public ReferenceNode(IServerUtils utils, NestedLootTable entry, float chance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        List<LootItemFunction> allFunctions = Stream.concat(functions.stream(), entry.f_79677_.stream()).toList();
        List<LootItemCondition> allConditions = Stream.concat(conditions.stream(), entry.f_79636_.stream()).toList();
        LootTable lootTable = utils.getLootTable((Either<ResourceLocation, LootTable>)entry.f_314988_.mapLeft(ResourceKey::m_135782_));
        if (lootTable != null) {
            this.addChildren(new LootTableNode(utils, lootTable, chance * (float)entry.f_79675_ / (float)sumWeight, allFunctions, allConditions));
        } else {
            this.addChildren(new MissingNode());
        }
        this.chance = chance * (float)entry.f_79675_ / (float)sumWeight;
        this.tooltip = EntryTooltipUtils.getReferenceTooltip(entry, chance, sumWeight);
    }

    public ReferenceNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        super(utils, buf);
        this.tooltip = NodeUtils.decodeTooltipNodes(utils, buf);
        this.chance = buf.readFloat();
    }

    @Override
    public void encodeNode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        NodeUtils.encodeTooltipNodes(utils, buf, this.tooltip);
        buf.writeFloat(this.chance);
    }

    @Override
    public List<ITooltipNode> getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public float getChance() {
        return this.chance;
    }
}

