/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.RangeValue;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.jetbrains.annotations.NotNull;

public class TooltipUtils {
    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getChance(IServerUtils utils, List<LootItemCondition> conditions, float rawChance) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> chance = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        chance.put(null, Map.of(0, new RangeValue(rawChance * 100.0f)));
        for (LootItemCondition condition : conditions) {
            utils.applyChanceModifier(utils, condition, chance);
        }
        return chance;
    }

    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getCount(IServerUtils utils, List<LootItemFunction> functions) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> count = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        count.put(null, Map.of(0, new RangeValue()));
        for (LootItemFunction function : functions) {
            utils.applyCountModifier(utils, function, count);
        }
        return count;
    }

    public static ItemStack getItemStack(IServerUtils utils, ItemStack itemStack, List<LootItemFunction> functions) {
        for (LootItemFunction function : functions) {
            itemStack = utils.applyItemStackModifier(utils, function, itemStack);
        }
        return itemStack;
    }

    public static void applyRandomChance(IServerUtils utils, LootItemRandomChanceCondition condition, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> chanceMap : chance.entrySet()) {
            for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                levelEntry.getValue().multiply(utils.convertNumber(utils, condition.f_337409_()));
            }
        }
    }

    public static void applyRandomChanceWithLooting(IServerUtils utils, LootItemRandomChanceWithEnchantedBonusCondition condition, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        Holder enchantment = condition.f_337283_();
        if (chance.containsKey(enchantment)) {
            chance.get(null).get(0).multiply(condition.f_336942_());
            for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                RangeValue value = new RangeValue();
                TooltipUtils.calculateCount(condition.f_336885_(), value, (int)entry.getKey());
                entry.getValue().multiply(value);
            }
        } else {
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(condition.f_336942_());
            chance.put((Holder<Enchantment>)enchantment, levelMap);
            for (int level = 1; level <= ((Enchantment)enchantment.m_203334_()).m_6586_(); ++level) {
                RangeValue value = new RangeValue();
                TooltipUtils.calculateCount(condition.f_336885_(), value, level);
                levelMap.put(level, new RangeValue(baseChance).multiply(value));
            }
        }
    }

    public static void applyTableBonus(IServerUtils utils, BonusLevelTableCondition condition, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        block2: {
            Holder enchantment;
            block3: {
                enchantment = condition.f_81507_();
                if (condition.f_81508_().isEmpty()) break block2;
                if (!chance.containsKey(enchantment)) break block3;
                chance.get(null).get(0).multiply(((Float)condition.f_81508_().getFirst()).floatValue());
                if (condition.f_81508_().size() <= 1) break block2;
                for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                    Integer level = entry.getKey();
                    if (level >= condition.f_81508_().size()) continue;
                    entry.getValue().multiply(((Float)condition.f_81508_().get(level)).floatValue());
                }
                break block2;
            }
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(((Float)condition.f_81508_().getFirst()).floatValue());
            chance.put((Holder<Enchantment>)enchantment, levelMap);
            for (int level = 1; level <= ((Enchantment)enchantment.m_203334_()).m_6586_() && level < condition.f_81508_().size(); ++level) {
                levelMap.put(level, new RangeValue(baseChance).multiply(((Float)condition.f_81508_().get(level)).floatValue()));
            }
        }
    }

    public static void applySetCount(IServerUtils utils, SetItemCountFunction function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        if (function.f_80676_.isEmpty()) {
            for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> chanceMap : count.entrySet()) {
                for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                    if (function.f_165407_) {
                        levelEntry.getValue().add(utils.convertNumber(utils, function.f_80997_));
                        continue;
                    }
                    levelEntry.getValue().set(utils.convertNumber(utils, function.f_80997_));
                }
            }
        }
    }

    public static void applyBonus(IServerUtils utils, ApplyBonusCount function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        block4: {
            if (!function.f_80676_.isEmpty()) break block4;
            Holder enchantment = function.f_79899_;
            if (count.containsKey(enchantment)) {
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    TooltipUtils.calculateCount(function, entry.getValue(), (int)entry.getKey());
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                count.put((Holder<Enchantment>)enchantment, levelMap);
                for (int level = 1; level <= ((Enchantment)enchantment.m_203334_()).m_6586_(); ++level) {
                    RangeValue value = new RangeValue(baseCount);
                    TooltipUtils.calculateCount(function, value, level);
                    levelMap.put(level, value);
                }
            }
        }
    }

    public static void applyLimitCount(IServerUtils utils, LimitCount function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> bonusCount) {
        if (function.f_80676_.isEmpty()) {
            for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> entry : bonusCount.entrySet()) {
                for (Map.Entry<Integer, RangeValue> mapEntry : entry.getValue().entrySet()) {
                    RangeValue value = mapEntry.getValue();
                    value.clamp(utils.convertNumber(utils, function.f_80635_.f_165001_), utils.convertNumber(utils, function.f_80635_.f_165002_));
                }
            }
        }
    }

    public static void applyLootingEnchant(IServerUtils utils, EnchantedCountIncreaseFunction function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        block5: {
            if (!function.f_80676_.isEmpty()) break block5;
            Holder enchantment = function.f_337606_;
            if (count.containsKey(enchantment)) {
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    RangeValue value = entry.getValue();
                    value.add(utils.convertNumber(utils, function.f_337272_).multiply(entry.getKey().intValue()));
                    if (function.f_337685_ <= 0) continue;
                    value.clamp(new RangeValue(false, true), new RangeValue(function.f_337685_));
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                count.put((Holder<Enchantment>)enchantment, levelMap);
                for (int level = 1; level <= ((Enchantment)enchantment.m_203334_()).m_6586_(); ++level) {
                    RangeValue value = new RangeValue(baseCount).add(utils.convertNumber(utils, function.f_337272_).multiply(level));
                    if (function.f_337685_ > 0) {
                        value.clamp(new RangeValue(false, true), new RangeValue(function.f_337685_));
                    }
                    levelMap.put(level, value);
                }
            }
        }
    }

    @NotNull
    public static ItemStack applyEnchantRandomlyItemStackModifier(IServerUtils utils, EnchantRandomlyFunction function, ItemStack itemStack) {
        if (itemStack.m_41792_() && function.f_80676_.isEmpty()) {
            List<Holder> list;
            boolean isBook = itemStack.m_150930_(Items.f_42517_);
            boolean compatible = !isBook && function.f_336641_;
            ItemStack finalItemStack = itemStack;
            Optional<HolderSet.Direct> enchantments = function.f_336941_;
            if (enchantments.isEmpty() && (list = function.f_336941_.map(HolderSet::m_203614_).orElseGet(() -> utils.lookupProvider().m_255025_(Registries.f_256762_).m_214062_().map(Function.identity())).filter(ref -> compatible || ((Enchantment)ref.m_203334_()).m_6081_(finalItemStack)).toList()).size() == 1) {
                enchantments = Optional.of(HolderSet.m_205809_((Holder[])new Holder[]{list.getFirst()}));
            }
            if (enchantments.isPresent() && ((HolderSet)enchantments.get()).m_203632_() == 1 && ((Enchantment)((HolderSet)enchantments.get()).m_203662_(0).m_203334_()).m_44702_() == ((Enchantment)((HolderSet)enchantments.get()).m_203662_(0).m_203334_()).m_6586_()) {
                itemStack.m_41663_(((HolderSet)enchantments.get()).m_203662_(0), ((Enchantment)((HolderSet)enchantments.get()).m_203662_(0).m_203334_()).m_6586_());
            } else if (isBook) {
                itemStack = Items.f_42690_.m_7968_();
            } else {
                itemStack.m_322496_(DataComponents.f_315974_, (Object)true);
            }
        }
        return itemStack;
    }

    @NotNull
    public static ItemStack applyEnchantWithLevelsItemStackModifier(IServerUtils utils, EnchantWithLevelsFunction function, ItemStack itemStack) {
        if (itemStack.m_41792_() && function.f_80676_.isEmpty()) {
            if (itemStack.m_150930_(Items.f_42517_)) {
                itemStack = Items.f_42690_.m_7968_();
            } else {
                itemStack.m_322496_(DataComponents.f_315974_, (Object)true);
            }
        }
        return itemStack;
    }

    public static ItemStack applySetAttributesItemStackModifier(IServerUtils utils, SetAttributesFunction function, ItemStack itemStack) {
        if (function.f_80676_.isEmpty()) {
            if (function.f_314132_) {
                itemStack.m_322496_(DataComponents.f_316119_, (Object)TooltipUtils.updateModifiers(function.f_80831_, ItemAttributeModifiers.f_314473_));
            } else {
                itemStack.m_322591_(DataComponents.f_316119_, (Object)ItemAttributeModifiers.f_314473_, modifiers -> {
                    if (modifiers.f_314826_().isEmpty()) {
                        return TooltipUtils.updateModifiers(function.f_80831_, itemStack.m_41720_().m_7167_());
                    }
                    return TooltipUtils.updateModifiers(function.f_80831_, modifiers);
                });
            }
        }
        return itemStack;
    }

    public static ItemStack applySetNameItemStackModifier(IServerUtils utils, SetNameFunction function, ItemStack itemStack) {
        if (function.f_80676_.isEmpty() && function.f_81123_.isPresent()) {
            itemStack.m_322496_(function.f_315028_.m_322685_(), (Object)((Component)function.f_81123_.get()));
        }
        return itemStack;
    }

    @NotNull
    public static ItemStack applySetEnchantmentsItemStackModifier(IServerUtils utils, SetEnchantmentsFunction function, ItemStack itemStack) {
        if (itemStack.m_41792_() && function.f_80676_.isEmpty()) {
            if (itemStack.m_150930_(Items.f_42517_)) {
                itemStack = Items.f_42690_.m_7968_();
            } else {
                itemStack.m_322496_(DataComponents.f_315974_, (Object)true);
            }
        }
        return itemStack;
    }

    public static ItemStack applyItemStackModifier(IServerUtils utils, LootItemFunction function, ItemStack itemStack) {
        if (function instanceof LootItemConditionalFunction) {
            LootItemConditionalFunction conditional = (LootItemConditionalFunction)function;
            if (!conditional.f_80676_.isEmpty()) {
                return itemStack;
            }
        }
        itemStack = (ItemStack)function.apply((Object)itemStack, null);
        return itemStack;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void calculateCount(ApplyBonusCount function, RangeValue value, int level) {
        ApplyBonusCount.Formula formula = function.f_79900_;
        Objects.requireNonNull(formula);
        ApplyBonusCount.Formula formula2 = formula;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ApplyBonusCount.OreDrops.class, ApplyBonusCount.BinomialWithBonusCount.class, ApplyBonusCount.UniformBonusCount.class}, (Object)formula2, n)) {
            case 0: {
                ApplyBonusCount.OreDrops ignored = (ApplyBonusCount.OreDrops)formula2;
                if (level <= 0) return;
                value.multiplyMax(level + 1);
                return;
            }
            case 1: {
                ApplyBonusCount.BinomialWithBonusCount binomialWithBonusCount = (ApplyBonusCount.BinomialWithBonusCount)formula2;
                value.addMax(binomialWithBonusCount.f_79948_() + level);
                return;
            }
            case 2: {
                ApplyBonusCount.UniformBonusCount uniformBonusCount = (ApplyBonusCount.UniformBonusCount)formula2;
                try {
                    int n2;
                    int bonusMultiplier = n2 = uniformBonusCount.f_80013_();
                    if (level <= 0) return;
                    value.addMax(bonusMultiplier * level);
                    return;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void calculateCount(LevelBasedValue levelBasedValue, RangeValue v, int level) {
        block20: {
            v0 = levelBasedValue;
            Objects.requireNonNull(v0);
            var3_3 = v0;
            var4_5 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LevelBasedValue.Constant.class, LevelBasedValue.Clamped.class, LevelBasedValue.Fraction.class, LevelBasedValue.Linear.class, LevelBasedValue.LevelsSquared.class, LevelBasedValue.Lookup.class}, (Object)var3_3, var4_5)) {
                case 0: {
                    var5_6 = (LevelBasedValue.Constant)var3_3;
                    value = var7_7 = var5_6.f_336981_();
                    v.multiply(value);
                    break;
                }
                case 1: {
                    var7_8 = (LevelBasedValue.Clamped)var3_3;
                    value = var11_10 = var7_8.f_336702_();
                    min = var11_11 = var7_8.f_336751_();
                    max = var11_11 = var7_8.f_337031_();
                    TooltipUtils.calculateCount(value, v, level);
                    v.clamp(min, max);
                    break;
                }
                case 2: {
                    var11_12 = (LevelBasedValue.Fraction)var3_3;
                    numerator = var14_16 = var11_12.f_337089_();
                    denominator = var14_16 = var11_12.f_337310_();
                    n = new RangeValue();
                    d = new RangeValue();
                    TooltipUtils.calculateCount(numerator, n, level);
                    TooltipUtils.calculateCount(denominator, d, level);
                    v.multiply(new RangeValue(n.min() / d.max(), n.max() / d.min()));
                    break;
                }
                case 3: {
                    var14_17 = (LevelBasedValue.Linear)var3_3;
                    base = var17_22 = var14_17.f_337076_();
                    perLevelAboveFirst = var17_22 = var14_17.f_336969_();
                    v.multiply(new RangeValue(base).add(perLevelAboveFirst * (float)(level - 1)));
                    break;
                }
                case 4: {
                    var17_23 = (LevelBasedValue.LevelsSquared)var3_3;
                    added = var19_25 = var17_23.f_337001_();
                    v.multiply(added + (float)Mth.m_144944_((int)level));
                    break;
                }
                case 5: {
                    var19_26 = (LevelBasedValue.Lookup)var3_3;
                    values = var22_28 = var19_26.f_337520_();
                    fallback = var22_28 = var19_26.f_337128_();
                    if (level >= values.size()) ** GOTO lbl65
                    v.multiply(((Float)values.get(level)).floatValue());
                    break;
lbl65:
                    // 1 sources

                    TooltipUtils.calculateCount((LevelBasedValue)fallback, v, level);
                    break;
                }
                default: {
                    v.set(new RangeValue(false, true));
                    break;
                }
            }
            break block20;
            catch (Throwable var3_4) {
                throw new MatchException(var3_4.toString(), var3_4);
            }
        }
    }

    private static ItemAttributeModifiers updateModifiers(List<SetAttributesFunction.Modifier> modifiers, ItemAttributeModifiers itemAttributeModifiers) {
        for (SetAttributesFunction.Modifier modifier : modifiers) {
            ResourceLocation id = modifier.f_80851_();
            if (modifier.f_80852_().size() != 1 || modifier.f_80850_().m_142587_() != NumberProviders.f_165731_) continue;
            EquipmentSlotGroup equipmentSlot = (EquipmentSlotGroup)Util.m_214621_((List)modifier.f_80852_(), (RandomSource)RandomSource.m_216327_());
            ConstantValue value = (ConstantValue)modifier.f_80850_();
            itemAttributeModifiers = itemAttributeModifiers.m_320732_(modifier.f_80848_(), new AttributeModifier(id, (double)value.m_142688_(null), modifier.f_80849_()), equipmentSlot);
        }
        return itemAttributeModifiers;
    }
}

