/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.logging.LogUtils;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.configuration.BlockLootCategory;
import com.yanny.ali.configuration.EntityLootCategory;
import com.yanny.ali.configuration.GameplayLootCategory;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.configuration.TradeLootCategory;
import com.yanny.ali.platform.Services;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ConfigUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    @NotNull
    public static AliConfig readConfiguration() {
        Path configDir = Services.getPlatform().getConfiguration();
        if (configDir == null) {
            LOGGER.warn("Failed to obtain config dir path!");
            return new AliConfig();
        }
        Path modConfigDir = configDir.resolve("ali");
        Path configFile = modConfigDir.resolve("ali_common.json");
        if (!modConfigDir.toFile().exists() && !modConfigDir.toFile().mkdirs()) {
            LOGGER.warn("Failed to create path {} for configuration", (Object)modConfigDir);
            return new AliConfig();
        }
        File config = configFile.toFile();
        Gson gson = ConfigUtils.createGson();
        if (!config.exists()) {
            ConfigUtils.saveConfig(configFile, gson);
        }
        return ConfigUtils.load(configFile, gson);
    }

    private static AliConfig load(Path configFilePath, Gson gson) {
        AliConfig aliConfig;
        block8: {
            BufferedReader reader = Files.newBufferedReader(configFilePath);
            try {
                LOGGER.info("Loading configuration file {}", (Object)configFilePath);
                aliConfig = (AliConfig)gson.fromJson((Reader)reader, AliConfig.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("Error while reading configuration file: {}", (Object)e.getMessage());
                    return new AliConfig();
                }
            }
            ((Reader)reader).close();
        }
        return aliConfig;
    }

    private static void saveConfig(Path configFilePath, Gson gson) {
        try (FileWriter writer = new FileWriter(configFilePath.toFile());){
            gson.toJson((Object)new AliConfig(), (Appendable)writer);
            LOGGER.info("Created new configuration file {}", (Object)configFilePath);
        }
        catch (IOException e) {
            LOGGER.warn("Error while writing configuration file: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    @NotNull
    private static Gson createGson() {
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(LootCategory.class, (Object)new LootCategoryAdapter()).registerTypeAdapter(BlockLootCategory.class, (Object)new LootCategoryAdapter()).registerTypeAdapter(EntityLootCategory.class, (Object)new LootCategoryAdapter()).registerTypeAdapter(GameplayLootCategory.class, (Object)new LootCategoryAdapter()).registerTypeAdapter(TradeLootCategory.class, (Object)new LootCategoryAdapter()).create();
    }

    private static class LootCategoryAdapter
    implements JsonSerializer<LootCategory<?>>,
    JsonDeserializer<LootCategory<?>> {
        private LootCategoryAdapter() {
        }

        @NotNull
        public LootCategory<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            LootCategory.Type type = LootCategory.Type.valueOf(GsonHelper.getAsString((JsonObject)jsonObject, (String)"type"));
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case LootCategory.Type.BLOCK -> new BlockLootCategory(jsonObject);
                case LootCategory.Type.ENTITY -> new EntityLootCategory(jsonObject);
                case LootCategory.Type.TRADE -> new TradeLootCategory(jsonObject);
                case LootCategory.Type.GAMEPLAY -> new GameplayLootCategory(jsonObject);
            };
        }

        @NotNull
        public JsonElement serialize(LootCategory<?> lootCategory, Type typeOfT, JsonSerializationContext context) {
            return lootCategory.toJson();
        }
    }
}

