/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.functions.SetStewEffectFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class GenericTooltipUtils {
    private static final ChatFormatting TEXT_STYLE = ChatFormatting.GOLD;
    private static final ChatFormatting PARAM_STYLE = ChatFormatting.AQUA;

    public static @Unmodifiable @NotNull ITooltipNode getMissingFunction(IServerUtils utils, LootItemFunction function) {
        return RegistriesTooltipUtils.getFunctionTypeTooltip(utils, "ali.util.advanced_loot_info.missing", function.getType());
    }

    public static @Unmodifiable @NotNull ITooltipNode getMissingCondition(IServerUtils utils, LootItemCondition condition) {
        return RegistriesTooltipUtils.getConditionTypeTooltip(utils, "ali.util.advanced_loot_info.missing", condition.getType());
    }

    @NotNull
    public static List<ITooltipNode> getConditionListTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        return conditions.stream().map(condition -> utils.getConditionTooltip(utils, condition)).toList();
    }

    @NotNull
    public static List<ITooltipNode> getConditionsTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        if (!conditions.isEmpty()) {
            ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.util.advanced_loot_info.delimiter.conditions", new Object[0])));
            tooltip.addAll(GenericTooltipUtils.getConditionListTooltip(utils, conditions));
            return tooltip;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static ITooltipNode getSubConditionsTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        if (!conditions.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.property.branch.conditions", new Object[0]));
            for (ITooltipNode node : GenericTooltipUtils.getConditionListTooltip(utils, conditions)) {
                tooltip.add(node);
            }
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static List<ITooltipNode> getFunctionListTooltip(IServerUtils utils, List<LootItemFunction> functions) {
        return functions.stream().map(function -> utils.getFunctionTooltip(utils, function)).toList();
    }

    @NotNull
    public static List<ITooltipNode> getFunctionsTooltip(IServerUtils utils, List<LootItemFunction> functions) {
        if (!functions.isEmpty()) {
            ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.util.advanced_loot_info.delimiter.functions", new Object[0])));
            tooltip.addAll(GenericTooltipUtils.getFunctionListTooltip(utils, functions));
            return tooltip;
        }
        return Collections.emptyList();
    }

    public static @Unmodifiable @NotNull ITooltipNode getFormulaTooltip(IServerUtils utils, String key, ApplyBonusCount.Formula formula) {
        ITooltipNode tooltip = GenericTooltipUtils.getResourceLocationTooltip(utils, key, formula.getType().id());
        if (formula instanceof ApplyBonusCount.BinomialWithBonusCount) {
            ApplyBonusCount.BinomialWithBonusCount binomialWithBonusCount = (ApplyBonusCount.BinomialWithBonusCount)formula;
            tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.extra_rounds", binomialWithBonusCount.extraRounds()));
            tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.probability", Float.valueOf(binomialWithBonusCount.probability())));
        } else if (formula instanceof ApplyBonusCount.UniformBonusCount) {
            ApplyBonusCount.UniformBonusCount uniformBonusCount = (ApplyBonusCount.UniformBonusCount)formula;
            tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.bonus_multiplier", uniformBonusCount.bonusMultiplier()));
        }
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getPropertyTooltip(IServerUtils utils, String key, Property<?> property) {
        return GenericTooltipUtils.getStringTooltip(utils, key, property.getName());
    }

    @NotNull
    public static ITooltipNode getModifierTooltip(IServerUtils utils, String key, SetAttributesFunction.Modifier modifier) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.name", modifier.name()));
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.attribute", modifier.attribute(), RegistriesTooltipUtils::getAttributeTooltip));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.operation", modifier.operation()));
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.amount", modifier.amount()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.uuid", modifier.id(), GenericTooltipUtils::getUUIDTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.equipment_slots", "ali.property.value.null", modifier.slots(), GenericTooltipUtils::getEnumTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getUUIDTooltip(IServerUtils utils, String key, UUID uuid) {
        return new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.uuid", GenericTooltipUtils.value(uuid)));
    }

    @NotNull
    public static ITooltipNode getBannerPatternsTooltip(IServerUtils utils, String key, Pair<Holder<BannerPattern>, DyeColor> pair) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, key, (Holder)pair.getFirst(), RegistriesTooltipUtils::getBannerPatternTooltip);
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.color", (Enum)pair.getSecond()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getStatePropertiesPredicateTooltip(IServerUtils utils, String key, StatePropertiesPredicate propertiesPredicate) {
        return GenericTooltipUtils.getCollectionTooltip(utils, key, propertiesPredicate.properties(), GenericTooltipUtils::getPropertyMatcherTooltip);
    }

    @NotNull
    public static ITooltipNode getPropertyMatcherTooltip(IServerUtils ignoredUtils, StatePropertiesPredicate.PropertyMatcher propertyMatcher) {
        String name = propertyMatcher.name();
        StatePropertiesPredicate.ValueMatcher valueMatcher = propertyMatcher.valueMatcher();
        if (valueMatcher instanceof StatePropertiesPredicate.ExactMatcher) {
            StatePropertiesPredicate.ExactMatcher matcher = (StatePropertiesPredicate.ExactMatcher)valueMatcher;
            return new TooltipNode(GenericTooltipUtils.keyValue(name, matcher.value()));
        }
        valueMatcher = propertyMatcher.valueMatcher();
        if (valueMatcher instanceof StatePropertiesPredicate.RangedMatcher) {
            StatePropertiesPredicate.RangedMatcher matcher = (StatePropertiesPredicate.RangedMatcher)valueMatcher;
            Optional min = matcher.minValue();
            Optional max = matcher.maxValue();
            return min.map(s -> max.map(string -> new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_both", name, s, string)))).orElseGet(() -> new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_gte", name, s))))).orElseGet(() -> max.map(string -> new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_lte", name, string)))).orElseGet(() -> new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_any", name)))));
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getDamageSourcePredicateTooltip(IServerUtils utils, String key, DamageSourcePredicate damagePredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.tags", "ali.property.value.null", damagePredicate.tags(), GenericTooltipUtils::getTagPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.direct_entity", damagePredicate.directEntity(), GenericTooltipUtils::getEntityPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.source_entity", damagePredicate.sourceEntity(), GenericTooltipUtils::getEntityPredicateTooltip));
        return tooltip;
    }

    public static <T> @Unmodifiable @NotNull ITooltipNode getTagPredicateTooltip(IServerUtils utils, String key, TagPredicate<T> tagPredicate) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.keyValue(tagPredicate.tag().location().toString(), tagPredicate.expected())));
    }

    @NotNull
    public static ITooltipNode getEntityPredicateTooltip(IServerUtils utils, String key, EntityPredicate entityPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.entity_types", entityPredicate.entityType(), GenericTooltipUtils::getEntityTypePredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.distance_to_player", entityPredicate.distanceToPlayer(), GenericTooltipUtils::getDistancePredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.location", entityPredicate.location(), GenericTooltipUtils::getLocationPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.stepping_on_location", entityPredicate.steppingOnLocation(), GenericTooltipUtils::getLocationPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.mob_effects", entityPredicate.effects(), GenericTooltipUtils::getMobEffectPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.nbt", entityPredicate.nbt(), GenericTooltipUtils::getNbtPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.entity_flags", entityPredicate.flags(), GenericTooltipUtils::getEntityFlagsPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.entity_equipment", entityPredicate.equipment(), GenericTooltipUtils::getEntityEquipmentPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.entity_sub_predicate", entityPredicate.subPredicate(), GenericTooltipUtils::getEntitySubPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.vehicle", entityPredicate.vehicle(), GenericTooltipUtils::getEntityPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.passenger", entityPredicate.passenger(), GenericTooltipUtils::getEntityPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.targeted_entity", entityPredicate.targetedEntity(), GenericTooltipUtils::getEntityPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.team", entityPredicate.team(), GenericTooltipUtils::getStringTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEntityTypePredicateTooltip(IServerUtils utils, String key, EntityTypePredicate entityTypePredicate) {
        return GenericTooltipUtils.getHolderSetTooltip(utils, key, "ali.property.value.null", entityTypePredicate.types(), RegistriesTooltipUtils::getEntityTypeTooltip);
    }

    @NotNull
    public static ITooltipNode getDistancePredicateTooltip(IServerUtils utils, String key, DistancePredicate distancePredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.x", distancePredicate.x()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.y", distancePredicate.y()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.z", distancePredicate.z()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.horizontal", distancePredicate.horizontal()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.absolute", distancePredicate.absolute()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getLocationPredicateTooltip(IServerUtils utils, String key, LocationPredicate locationPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.position", locationPredicate.position(), GenericTooltipUtils::getPositionPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.biome", locationPredicate.biome(), GenericTooltipUtils::getResourceKeyTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.structure", locationPredicate.structure(), GenericTooltipUtils::getResourceKeyTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.dimension", locationPredicate.dimension(), GenericTooltipUtils::getResourceKeyTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.smokey", locationPredicate.smokey(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.light", locationPredicate.light(), GenericTooltipUtils::getLightPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.block_predicate", locationPredicate.block(), GenericTooltipUtils::getBlockPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.fluid_predicate", locationPredicate.fluid(), GenericTooltipUtils::getFluidPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getPositionPredicateTooltip(IServerUtils utils, String key, LocationPredicate.PositionPredicate positionPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.x", positionPredicate.x()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.y", positionPredicate.y()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.z", positionPredicate.z()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getLightPredicateTooltip(IServerUtils utils, String key, LightPredicate lightPredicate) {
        return GenericTooltipUtils.getMinMaxBoundsTooltip(utils, key, lightPredicate.composite());
    }

    @NotNull
    public static ITooltipNode getBlockPredicateTooltip(IServerUtils utils, String key, BlockPredicate blockPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.tag", blockPredicate.tag(), GenericTooltipUtils::getTagKeyTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, "ali.property.branch.blocks", "ali.property.value.null", blockPredicate.blocks(), RegistriesTooltipUtils::getBlockTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.properties", blockPredicate.properties(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.nbt", blockPredicate.nbt(), GenericTooltipUtils::getNbtPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getNbtPredicateTooltip(IServerUtils utils, String key, NbtPredicate nbtPredicate) {
        return GenericTooltipUtils.getCompoundTagTooltip(utils, key, nbtPredicate.tag());
    }

    @NotNull
    public static ITooltipNode getFluidPredicateTooltip(IServerUtils utils, String key, FluidPredicate fluidPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.tag", fluidPredicate.tag(), GenericTooltipUtils::getTagKeyTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalHolderTooltip(utils, "ali.property.value.fluid", fluidPredicate.fluid(), RegistriesTooltipUtils::getFluidTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.properties", fluidPredicate.properties(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMobEffectPredicateTooltip(IServerUtils utils, String key, MobEffectsPredicate mobEffectsPredicate) {
        return GenericTooltipUtils.getMapTooltip(utils, key, mobEffectsPredicate.effectMap(), GenericTooltipUtils::getMobEffectPredicateEntryTooltip);
    }

    @NotNull
    public static ITooltipNode getEntityFlagsPredicateTooltip(IServerUtils utils, String key, EntityFlagsPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_on_fire", predicate.isOnFire(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_baby", predicate.isBaby(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_crouching", predicate.isCrouching(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_sprinting", predicate.isSprinting(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_swimming", predicate.isSwimming(), GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEntityEquipmentPredicateTooltip(IServerUtils utils, String key, EntityEquipmentPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.head", predicate.head(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.chest", predicate.chest(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.legs", predicate.legs(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.feet", predicate.feet(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.mainhand", predicate.mainhand(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.offhand", predicate.offhand(), GenericTooltipUtils::getItemPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getItemPredicateTooltip(IServerUtils utils, String key, ItemPredicate itemPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.tag", itemPredicate.tag(), GenericTooltipUtils::getTagKeyTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, "ali.property.branch.items", "ali.property.value.null", itemPredicate.items(), RegistriesTooltipUtils::getItemTooltip));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.count", itemPredicate.count()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.durability", itemPredicate.durability()));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.enchantments", "ali.property.value.null", itemPredicate.enchantments(), GenericTooltipUtils::getEnchantmentPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.stored_enchantments", "ali.property.value.null", itemPredicate.storedEnchantments(), GenericTooltipUtils::getEnchantmentPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalHolderTooltip(utils, "ali.property.value.potion", itemPredicate.potion(), RegistriesTooltipUtils::getPotionTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.nbt", itemPredicate.nbt(), GenericTooltipUtils::getNbtPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEnchantmentPredicateTooltip(IServerUtils utils, String key, EnchantmentPredicate enchantmentPredicate) {
        ITooltipNode tooltip = enchantmentPredicate.enchantment().isPresent() ? GenericTooltipUtils.getHolderTooltip(utils, key, (Holder)enchantmentPredicate.enchantment().get(), RegistriesTooltipUtils::getEnchantmentTooltip) : new TooltipNode();
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.level", enchantmentPredicate.level()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEntitySubPredicateTooltip(IServerUtils utils, String key, EntitySubPredicate entitySubPredicate) {
        Optional<Map.Entry> optional = EntitySubPredicate.Types.TYPES.entrySet().stream().filter(p -> p.getValue() == entitySubPredicate.type()).findFirst();
        return optional.map(entry -> {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, entry.getKey()));
            if (entitySubPredicate instanceof LightningBoltPredicate) {
                LightningBoltPredicate predicate = (LightningBoltPredicate)entitySubPredicate;
                tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.blocks_on_fire", predicate.blocksSetOnFire()));
                tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.stuck_entity", predicate.entityStruck(), GenericTooltipUtils::getEntityPredicateTooltip));
            } else if (entitySubPredicate instanceof FishingHookPredicate) {
                FishingHookPredicate predicate = (FishingHookPredicate)entitySubPredicate;
                tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.in_open_water", predicate.inOpenWater(), GenericTooltipUtils::getBooleanTooltip));
            } else if (entitySubPredicate instanceof PlayerPredicate) {
                PlayerPredicate predicate = (PlayerPredicate)entitySubPredicate;
                tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.level", predicate.level()));
                tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.game_type", predicate.gameType(), GenericTooltipUtils::getEnumTooltip));
                tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.stats", predicate.stats(), GenericTooltipUtils::getStatMatcherTooltip));
                tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.recipes", predicate.recipes(), GenericTooltipUtils::getRecipeEntryTooltip));
                tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.advancements", predicate.advancements(), GenericTooltipUtils::getAdvancementEntryTooltip));
                tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.looking_at", predicate.lookingAt(), GenericTooltipUtils::getEntityPredicateTooltip));
            } else if (entitySubPredicate instanceof SlimePredicate) {
                SlimePredicate predicate = (SlimePredicate)entitySubPredicate;
                tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.size", predicate.size()));
            } else {
                EntitySubPredicate.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entitySubPredicate).result().ifPresent(element -> {
                    JsonObject jsonObject = element.getAsJsonObject();
                    if (jsonObject.has("variant")) {
                        tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.variant", jsonObject.getAsJsonPrimitive("variant").getAsString())));
                    } else {
                        tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.variant", jsonObject.toString())));
                    }
                });
            }
            return tooltip;
        }).orElse(new TooltipNode());
    }

    @NotNull
    public static ITooltipNode getStatMatcherTooltip(IServerUtils utils, PlayerPredicate.StatMatcher<?> stat) {
        ITooltipNode tooltip;
        Holder value = stat.value();
        Object object = value.value();
        if (object instanceof Item) {
            Item item = (Item)object;
            tooltip = RegistriesTooltipUtils.getItemTooltip(utils, "ali.property.value.item", item);
            tooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(stat.type().getDisplayName(), GenericTooltipUtils.toString(stat.range()))));
        } else {
            object = value.value();
            if (object instanceof Block) {
                Block block = (Block)object;
                tooltip = RegistriesTooltipUtils.getBlockTooltip(utils, "ali.property.value.block", block);
                tooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(stat.type().getDisplayName(), GenericTooltipUtils.toString(stat.range()))));
            } else {
                object = value.value();
                if (object instanceof EntityType) {
                    EntityType entityType = (EntityType)object;
                    tooltip = RegistriesTooltipUtils.getEntityTypeTooltip(utils, "ali.property.value.entity_type", entityType);
                    tooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(stat.type().getDisplayName(), GenericTooltipUtils.toString(stat.range()))));
                } else {
                    object = value.value();
                    if (object instanceof ResourceLocation) {
                        ResourceLocation resourceLocation = (ResourceLocation)object;
                        tooltip = GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.property.value.id", resourceLocation);
                        tooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(GenericTooltipUtils.translatable(GenericTooltipUtils.getTranslationKey(resourceLocation), new Object[0]), GenericTooltipUtils.toString(stat.range()))));
                    } else {
                        tooltip = new TooltipNode();
                    }
                }
            }
        }
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getBlockPosTooltip(IServerUtils ignoredUtils, String key, BlockPos pos) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(pos.getX()), GenericTooltipUtils.value(pos.getY()), GenericTooltipUtils.value(pos.getZ())));
    }

    @NotNull
    public static ITooltipNode getCopyOperationTooltip(IServerUtils utils, String key, CopyNbtFunction.CopyOperation copyOperation) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.source", copyOperation.sourcePath().string()));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.target", copyOperation.targetPath().string()));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.merge_strategy", copyOperation.op()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEffectEntryTooltip(IServerUtils utils, String key, SetStewEffectFunction.EffectEntry entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, key, entry.effect(), RegistriesTooltipUtils::getMobEffectTooltip);
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.duration", entry.duration()));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getCompoundTagTooltip(IServerUtils ignoredUtils, String key, CompoundTag tag) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(tag.toString())));
    }

    @NotNull
    public static ITooltipNode getAdvancementPredicateTooltip(IServerUtils utils, String key, PlayerPredicate.AdvancementPredicate predicate) {
        if (predicate instanceof PlayerPredicate.AdvancementDonePredicate) {
            PlayerPredicate.AdvancementDonePredicate donePredicate = (PlayerPredicate.AdvancementDonePredicate)predicate;
            return new TooltipNode(GenericTooltipUtils.translatable(key, donePredicate.state()));
        }
        if (predicate instanceof PlayerPredicate.AdvancementCriterionsPredicate) {
            PlayerPredicate.AdvancementCriterionsPredicate criterionsPredicate = (PlayerPredicate.AdvancementCriterionsPredicate)predicate;
            return GenericTooltipUtils.getMapTooltip(utils, criterionsPredicate.criterions(), GenericTooltipUtils::getCriterionEntryTooltip);
        }
        return new TooltipNode();
    }

    public static @Unmodifiable @NotNull ITooltipNode getItemStackTooltip(IServerUtils utils, String key, ItemStack item) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(RegistriesTooltipUtils.getItemTooltip(utils, "ali.property.value.item", item.getItem()));
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.count", item.getCount()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.tag", Optional.ofNullable(item.getTag()), GenericTooltipUtils::getCompoundTagTooltip));
        return tooltip;
    }

    @NotNull
    public static Component translatable(String key, Object ... args) {
        return Component.translatable((String)key, (Object[])Arrays.stream(args).map(GenericTooltipUtils::convertObject).toArray()).withStyle(TEXT_STYLE);
    }

    @NotNull
    public static Component value(Object value) {
        return GenericTooltipUtils.convertObject(value).withStyle(new ChatFormatting[]{PARAM_STYLE, ChatFormatting.BOLD});
    }

    @NotNull
    public static Component value(Object value, String unit) {
        return Component.translatable((String)"ali.util.advanced_loot_info.two_values", (Object[])new Object[]{GenericTooltipUtils.convertObject(value), unit}).withStyle(new ChatFormatting[]{PARAM_STYLE, ChatFormatting.BOLD});
    }

    @NotNull
    public static Component pair(Object value1, Object value2) {
        return Component.translatable((String)"ali.util.advanced_loot_info.two_values_with_space", (Object[])new Object[]{GenericTooltipUtils.convertObject(value1), GenericTooltipUtils.convertObject(value2)});
    }

    @NotNull
    public static Component pad(int count, Object arg) {
        if (count > 0) {
            return GenericTooltipUtils.pair(Component.translatable((String)("ali.util.advanced_loot_info.pad." + count)), GenericTooltipUtils.convertObject(arg));
        }
        return GenericTooltipUtils.convertObject(arg);
    }

    @NotNull
    public static Component keyValue(Object key, Object value) {
        return GenericTooltipUtils.translatable("ali.util.advanced_loot_info.key_value", GenericTooltipUtils.convertObject(key), GenericTooltipUtils.value(value));
    }

    public static @Unmodifiable @NotNull ITooltipNode getNumberProviderTooltip(IServerUtils utils, String key, NumberProvider value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(utils.convertNumber(utils, value))));
    }

    public static @Unmodifiable @NotNull ITooltipNode getIntRangeTooltip(IServerUtils utils, String key, IntRange range) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(RangeValue.rangeToString(utils.convertNumber(utils, range.min), utils.convertNumber(utils, range.max)))));
    }

    public static @Unmodifiable @NotNull ITooltipNode getBooleanTooltip(IServerUtils utils, String key, Boolean value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getIntegerTooltip(IServerUtils ignoredUtils, String key, int value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getLongTooltip(IServerUtils ignoredUtils, String key, Long value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getStringTooltip(IServerUtils utils, String key, String value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getFloatTooltip(IServerUtils ignoredUtils, String key, Float value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getDoubleTooltip(IServerUtils ignoredUtils, String key, Double value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getEnumTooltip(IServerUtils ignoredUtils, String key, Enum<?> value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value.name())));
    }

    public static @Unmodifiable @NotNull ITooltipNode getResourceLocationTooltip(IServerUtils ignoredUtils, String key, ResourceLocation value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static <T> @Unmodifiable @NotNull ITooltipNode getBuiltInRegistryTooltip(IServerUtils utils, String key, Registry<T> registry, T value) {
        return GenericTooltipUtils.getOptionalTooltip(utils, key, Optional.ofNullable(registry.getKey(value)), GenericTooltipUtils::getResourceLocationTooltip);
    }

    public static <T> @Unmodifiable @NotNull ITooltipNode getResourceKeyTooltip(IServerUtils utils, String key, ResourceKey<T> value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value.location())));
    }

    public static @Unmodifiable @NotNull ITooltipNode getTagKeyTooltip(IServerUtils utils, String key, TagKey<?> value) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, key, value.location());
    }

    public static @Unmodifiable @NotNull ITooltipNode getComponentTooltip(IServerUtils ignoredUtils, String key, Component component) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(component.copy())));
    }

    @NotNull
    public static ITooltipNode getMinMaxBoundsTooltip(IServerUtils ignoredUtils, String key, MinMaxBounds.Ints ints) {
        if (ints != MinMaxBounds.Ints.ANY) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(GenericTooltipUtils.toString(ints))));
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getMinMaxBoundsTooltip(IServerUtils ignoredUtils, String key, MinMaxBounds.Doubles doubles) {
        if (doubles != MinMaxBounds.Doubles.ANY) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(GenericTooltipUtils.toString(doubles))));
        }
        return new TooltipNode();
    }

    @NotNull
    public static <T> ITooltipNode getOptionalTooltip(IServerUtils utils, String key, Optional<T> optional, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        return optional.map(value -> (ITooltipNode)mapper.apply((Object)utils, (Object)key, value)).orElse(new TooltipNode());
    }

    @NotNull
    public static <T> ITooltipNode getOptionalHolderTooltip(IServerUtils utils, String key, Optional<Holder<T>> optional, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        return optional.map(holder -> GenericTooltipUtils.getHolderTooltip(utils, key, holder, mapper)).orElse(new TooltipNode());
    }

    @NotNull
    public static <T> ITooltipNode getOptionalHolderSetTooltip(IServerUtils utils, String key, String value, Optional<HolderSet<T>> optional, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        return optional.map(holderSet -> GenericTooltipUtils.getHolderSetTooltip(utils, key, value, holderSet, mapper)).orElse(new TooltipNode());
    }

    @NotNull
    public static <T> ITooltipNode getHolderTooltip(IServerUtils utils, String key, Holder<T> holder, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        return (ITooltipNode)mapper.apply((Object)utils, (Object)key, holder.value());
    }

    @NotNull
    public static <T> ITooltipNode getHolderSetTooltip(IServerUtils utils, String key, String value, HolderSet<T> holderSet, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        Either either = holderSet.unwrap();
        Optional left = either.left();
        Optional right = either.right();
        TooltipNode tooltip = left.isPresent() || !right.orElse(List.of()).isEmpty() ? new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0])) : new TooltipNode();
        left.ifPresent(tagKey -> tooltip.add(GenericTooltipUtils.getTagKeyTooltip(utils, "ali.property.value.tag", tagKey)));
        right.ifPresent(list -> {
            if (!list.isEmpty()) {
                holderSet.forEach(holder -> tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, value, holder, mapper)));
            }
        });
        return tooltip;
    }

    @NotNull
    public static <T> ITooltipNode getCollectionTooltip(IServerUtils utils, String key, Collection<T> values, BiFunction<IServerUtils, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            values.forEach(value -> tooltip.add((ITooltipNode)mapper.apply(utils, value)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <T> ITooltipNode getCollectionTooltip(IServerUtils utils, String key, String value, Collection<T> values, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            values.forEach(v -> tooltip.add((ITooltipNode)mapper.apply((Object)utils, (Object)value, v)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <K, V> ITooltipNode getMapTooltip(IServerUtils utils, Map<K, V> values, BiFunction<IServerUtils, Map.Entry<K, V>, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode();
            values.entrySet().forEach(e -> tooltip.add((ITooltipNode)mapper.apply(utils, (Map.Entry)e)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <K, V> ITooltipNode getMapTooltip(IServerUtils utils, String key, Map<K, V> values, BiFunction<IServerUtils, Map.Entry<K, V>, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            values.entrySet().forEach(e -> tooltip.add((ITooltipNode)mapper.apply(utils, (Map.Entry)e)));
            return tooltip;
        }
        return new TooltipNode();
    }

    public static @Unmodifiable @NotNull ITooltipNode getRecipeEntryTooltip(IServerUtils ignoredUtils, Map.Entry<ResourceLocation, Boolean> entry) {
        return new TooltipNode(GenericTooltipUtils.keyValue(entry.getKey(), entry.getValue()));
    }

    public static @Unmodifiable @NotNull ITooltipNode getCriterionEntryTooltip(IServerUtils ignoredUtils, Map.Entry<String, Boolean> entry) {
        return new TooltipNode(GenericTooltipUtils.keyValue(entry.getKey(), entry.getValue()));
    }

    @NotNull
    public static ITooltipNode getIntRangeEntryTooltip(IServerUtils utils, Map.Entry<String, IntRange> entry) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.value(entry.getKey()));
        tooltip.add(GenericTooltipUtils.getIntRangeTooltip(utils, "ali.property.value.limit", entry.getValue()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMobEffectPredicateEntryTooltip(IServerUtils utils, Map.Entry<Holder<MobEffect>, MobEffectsPredicate.MobEffectInstancePredicate> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.null", entry.getKey(), RegistriesTooltipUtils::getMobEffectTooltip);
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.amplifier", entry.getValue().amplifier()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.duration", entry.getValue().duration()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_ambient", entry.getValue().ambient(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_visible", entry.getValue().visible(), GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEnchantmentLevelsEntryTooltip(IServerUtils utils, Map.Entry<Holder<Enchantment>, NumberProvider> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.null", entry.getKey(), RegistriesTooltipUtils::getEnchantmentTooltip);
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.levels", entry.getValue()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getAdvancementEntryTooltip(IServerUtils utils, Map.Entry<ResourceLocation, PlayerPredicate.AdvancementPredicate> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.property.value.null", entry.getKey());
        tooltip.add(GenericTooltipUtils.getAdvancementPredicateTooltip(utils, "ali.property.value.done", entry.getValue()));
        return tooltip;
    }

    @NotNull
    private static String toString(MinMaxBounds.Doubles doubles) {
        Optional min = doubles.min();
        Optional max = doubles.max();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min, max)) {
                    return String.format("%.1f-%.1f", min.get(), max.get());
                }
                return String.format("=%.1f", min.get());
            }
            return String.format("\u2265%.1f", min.get());
        }
        return max.map(aDouble -> String.format("\u2264%.1f", aDouble)).orElse("???");
    }

    @NotNull
    private static String toString(MinMaxBounds.Ints ints) {
        Optional min = ints.min();
        Optional max = ints.max();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min, max)) {
                    return String.format("%d-%d", min.get(), max.get());
                }
                return String.format("=%d", min.get());
            }
            return String.format("\u2265%d", min.get());
        }
        return max.map(integer -> String.format("\u2264%d", integer)).orElse("???");
    }

    @NotNull
    private static MutableComponent convertObject(@Nullable Object object) {
        if (object instanceof MutableComponent) {
            MutableComponent component = (MutableComponent)object;
            return component;
        }
        if (object != null) {
            return Component.literal((String)object.toString());
        }
        return Component.literal((String)"null");
    }

    @NotNull
    private static String getTranslationKey(ResourceLocation location) {
        return "stat." + location.toString().replace(':', '.');
    }
}

