/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.rei;

import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.rei.ReiBaseDisplay;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ReiEntityDisplay
extends ReiBaseDisplay {
    private final EntityType<?> entityType;
    private final ResourceLocation variant;
    private final CategoryIdentifier<ReiEntityDisplay> identifier;

    public ReiEntityDisplay(EntityLootType entry, CategoryIdentifier<ReiEntityDisplay> identifier) {
        super(ReiEntityDisplay.getSpawnEgg(entry), entry);
        this.entityType = entry.entityType();
        this.variant = entry.variant();
        this.identifier = identifier;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.identifier;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public ResourceLocation getVariant() {
        return this.variant;
    }

    private static @Unmodifiable @NotNull List<EntryIngredient> getSpawnEgg(EntityLootType entry) {
        SpawnEggItem item = SpawnEggItem.byId(entry.entityType());
        if (item != null) {
            return List.of(EntryIngredients.of((ItemLike)item));
        }
        return List.of();
    }
}

