/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.configuration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yanny.ali.configuration.LootCategory;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class BlockLootCategory
extends LootCategory<Block> {
    private final List<Class<?>> classes;

    public BlockLootCategory(ResourceLocation key, Item icon, boolean hide, List<Class<?>> classes) {
        super(key, icon, LootCategory.Type.BLOCK, hide);
        this.classes = classes;
    }

    public BlockLootCategory(JsonObject object) {
        super(LootCategory.Type.BLOCK, object);
        this.classes = GsonHelper.getAsJsonArray((JsonObject)object, (String)"classes").asList().stream().map(JsonElement::getAsString).map(className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JsonParseException("Failed to resolve class " + className);
            }
        }).toList();
    }

    @Override
    protected void toJson(JsonObject object) {
        JsonArray array = new JsonArray();
        this.classes.forEach(c -> array.add(c.getName()));
        object.add("classes", (JsonElement)array);
    }

    @Override
    public boolean validate(Block block) {
        return this.classes.stream().anyMatch(p -> p.isAssignableFrom(block.getClass()));
    }
}

