/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.AliServerRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.common.trades.TradeNode;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

public record SyncTradeMessage(ResourceLocation location, IDataNode node, List<Item> inputs, List<Item> outputs) implements CustomPacketPayload
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CustomPacketPayload.Type<SyncTradeMessage> TYPE = new CustomPacketPayload.Type(Utils.modLoc("trade_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncTradeMessage> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, l -> l.location, (StreamCodec)StreamCodec.of((b, l) -> {
        int fallbackIndex = b.writerIndex();
        try {
            AliServerRegistry utils = PluginManager.SERVER_REGISTRY;
            l.encode(utils, (RegistryFriendlyByteBuf)b);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to encode loot table with error: {}", (Object)e.getMessage());
            b.writerIndex(fallbackIndex);
            ByteBufCodecs.fromCodecWithRegistries((Codec)LootDataType.TABLE.codec()).encode(b, (Object)LootTable.EMPTY);
        }
    }, b -> {
        try {
            AliClientRegistry utils = PluginManager.CLIENT_REGISTRY;
            return new TradeNode(utils, (RegistryFriendlyByteBuf)b);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to decode loot table with error: {}", (Object)e.getMessage());
            return new MissingNode();
        }
    }), l -> l.node, (StreamCodec)StreamCodec.of((buf, l) -> buf.writeCollection((Collection)l, (b, i) -> b.writeResourceLocation(BuiltInRegistries.ITEM.getKey(i))), buf -> buf.readList(b -> (Item)BuiltInRegistries.ITEM.get(b.readResourceLocation()))), l -> l.inputs, (StreamCodec)StreamCodec.of((buf, l) -> buf.writeCollection((Collection)l, (b, i) -> b.writeResourceLocation(BuiltInRegistries.ITEM.getKey(i))), buf -> buf.readList(b -> (Item)BuiltInRegistries.ITEM.get(b.readResourceLocation()))), l -> l.outputs, SyncTradeMessage::new);

    public SyncTradeMessage(IDataNode node, Pair<List<Item>, List<Item>> items) {
        this(new ResourceLocation("empty"), node, (List)items.getA(), (List)items.getB());
    }

    public SyncTradeMessage(ResourceLocation location, IDataNode node, Pair<List<Item>, List<Item>> items) {
        this(location, node, (List)items.getA(), (List)items.getB());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

