/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.mods.sawmill;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.trades.ItemsToItemsNode;
import com.yanny.ali.plugin.common.trades.SubTradesNode;
import com.yanny.ali.plugin.mods.BaseAccessor;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.FieldAccessor;
import com.yanny.ali.plugin.mods.IItemListing;
import com.yanny.ali.plugin.mods.ReflectionUtils;
import com.yanny.ali.plugin.mods.sawmill.Utils;
import com.yanny.ali.plugin.mods.sawmill.WoodType;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3853;
import net.minecraft.class_3854;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_9306;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

@ClassAccessor(value="net.mehvahdjukaar.sawmill.CarpenterTrades$WoodToItemListing")
public class WoodToItemListing
extends BaseAccessor<class_3853.class_1652>
implements IItemListing {
    private static final Logger LOGGER = LogUtils.getLogger();
    @FieldAccessor
    private boolean buys;
    @FieldAccessor
    private String childKey;
    @FieldAccessor
    private int woodPrice;
    @FieldAccessor
    private class_9306 emeralds;
    @FieldAccessor
    private int maxTrades;
    @FieldAccessor
    private int xp;
    @FieldAccessor
    private float priceMult;
    @FieldAccessor
    private boolean typeDependant;

    public WoodToItemListing(class_3853.class_1652 parent) {
        super(parent);
    }

    @Override
    public IDataNode getNode(IServerUtils utils, List<ITooltipNode> conditions) {
        return new SubTradesNode<WoodToItemListing>(utils, this, conditions){

            @Override
            public List<IDataNode> getSubTrades(IServerUtils utils, WoodToItemListing listing) {
                ArrayList<IDataNode> nodes = new ArrayList<IDataNode>();
                if (WoodToItemListing.this.typeDependant) {
                    for (class_3854 type : class_7923.field_41194) {
                        List<WoodType> woodTypes = Utils.WOOD_TYPES.get(type);
                        if (woodTypes == null) continue;
                        List<ITooltipNode> cond = List.of(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.villager_type", type.toString()));
                        nodes.addAll(WoodToItemListing.this.getNodes(utils, woodTypes, cond));
                    }
                } else {
                    nodes.addAll(WoodToItemListing.this.getNodes(utils, WoodToItemListing.getAllWoodTypes(), Collections.emptyList()));
                }
                return nodes;
            }
        };
    }

    @Override
    public Pair<List<class_1792>, List<class_1792>> collectItems(IServerUtils utils) {
        ArrayList<Object> inputs = new ArrayList<Object>();
        ArrayList<Object> outputs = new ArrayList<Object>();
        List typed = class_7923.field_41194.method_10220().map(Utils.WOOD_TYPES::get).filter(Objects::nonNull).flatMap(e -> e.stream().flatMap(w -> {
            class_1792 child = w.getItemOfThis(this.childKey);
            return child != null ? Stream.of(child) : Stream.of(new class_1792[0]);
        })).toList();
        List allTypes = WoodToItemListing.getAllWoodTypes().stream().flatMap(w -> {
            class_1792 child = w.getItemOfThis(this.childKey);
            return child != null ? Stream.of(child) : Stream.of(new class_1792[0]);
        }).toList();
        if (this.typeDependant) {
            if (this.buys) {
                inputs.addAll(typed);
                outputs.add((class_1792)this.emeralds.comp_2424().comp_349());
            } else {
                inputs.add((class_1792)this.emeralds.comp_2424().comp_349());
                outputs.addAll(typed);
            }
        } else if (this.buys) {
            inputs.addAll(allTypes);
            outputs.add((class_1792)this.emeralds.comp_2424().comp_349());
        } else {
            inputs.add((class_1792)this.emeralds.comp_2424().comp_349());
            outputs.addAll(allTypes);
        }
        return new Pair(inputs, outputs);
    }

    @NotNull
    private List<IDataNode> getNodes(IServerUtils utils, Collection<WoodType> woodTypes, List<ITooltipNode> cond) {
        ArrayList<IDataNode> nodes = new ArrayList<IDataNode>();
        for (WoodType woodType : woodTypes) {
            class_1792 w = woodType.getItemOfThis(this.childKey);
            if (w == null || w.method_7854().method_7960()) continue;
            if (this.buys) {
                nodes.add(new ItemsToItemsNode(utils, (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)w.method_7854()), new RangeValue(this.woodPrice), (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)((class_1792)this.emeralds.comp_2424().comp_349()).method_7854()), new RangeValue(this.emeralds.comp_2425()), this.maxTrades, this.xp, this.priceMult, cond));
                continue;
            }
            nodes.add(new ItemsToItemsNode(utils, (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)((class_1792)this.emeralds.comp_2424().comp_349()).method_7854()), new RangeValue(this.emeralds.comp_2425()), (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)w.method_7854()), new RangeValue(this.woodPrice), this.maxTrades, this.xp, this.priceMult, cond));
        }
        return nodes;
    }

    private static Collection<WoodType> getAllWoodTypes() {
        try {
            Class<?> registryClass = Class.forName("net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry");
            return ((Collection)registryClass.getMethod("getTypes", new Class[0]).invoke(null, new Object[0])).stream().map(e -> ReflectionUtils.copyClassData(WoodType.class, e)).toList();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            LOGGER.warn("Unable to obtain all wood types: {}", (Object)e2.getMessage());
            return Collections.emptyList();
        }
    }
}

