/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.common.tooltip.BranchTooltipNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ErrorTooltipNode;
import com.yanny.ali.plugin.common.tooltip.LiteralTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericTooltipUtils {
    @NotNull
    public static ITooltipNode getMissingFunction(IServerUtils utils, LootItemFunction function) {
        IKeyTooltipNode tooltip = RegistriesTooltipUtils.getFunctionTypeTooltip(utils, function.m_7162_());
        Field[] fields = function.getClass().getDeclaredFields();
        List<Field> names = Arrays.stream(fields).filter(f -> !Modifier.isStatic(f.getModifiers())).toList();
        names.forEach(f -> {
            f.setAccessible(true);
            try {
                IKeyTooltipNode t = utils.getValueTooltip(utils, f.get(function));
                if (t instanceof ValueTooltipNode.Builder) {
                    ValueTooltipNode.Builder builder = (ValueTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof BranchTooltipNode.Builder) {
                    BranchTooltipNode.Builder builder = (BranchTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof ErrorTooltipNode.Builder) {
                    tooltip.add(ValueTooltipNode.keyValue(f.getName(), "???").build("ali.property.value.null"));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        return tooltip.build("ali.util.advanced_loot_info.auto_detected");
    }

    @NotNull
    public static ITooltipNode getMissingCondition(IServerUtils utils, LootItemCondition condition) {
        IKeyTooltipNode tooltip = RegistriesTooltipUtils.getConditionTypeTooltip(utils, condition.m_7940_());
        Field[] fields = condition.getClass().getDeclaredFields();
        List<Field> names = Arrays.stream(fields).filter(f -> !Modifier.isStatic(f.getModifiers())).toList();
        names.forEach(f -> {
            f.setAccessible(true);
            try {
                IKeyTooltipNode t = utils.getValueTooltip(utils, f.get(condition));
                if (t instanceof ValueTooltipNode.Builder) {
                    ValueTooltipNode.Builder builder = (ValueTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof BranchTooltipNode.Builder) {
                    BranchTooltipNode.Builder builder = (BranchTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof ErrorTooltipNode.Builder) {
                    tooltip.add(ValueTooltipNode.keyValue(f.getName(), "???").build("ali.property.value.null"));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        return tooltip.build("ali.util.advanced_loot_info.auto_detected");
    }

    @NotNull
    public static ITooltipNode getConditionListTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        ArrayTooltipNode.Builder array = ArrayTooltipNode.array();
        for (LootItemCondition condition : conditions) {
            array.add(utils.getConditionTooltip(utils, condition));
        }
        return array.build();
    }

    @NotNull
    public static ITooltipNode getConditionsTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        if (!conditions.isEmpty()) {
            return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.util.advanced_loot_info.delimiter.conditions")).add(GenericTooltipUtils.getConditionListTooltip(utils, conditions)).build();
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static IKeyTooltipNode getSubConditionsTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        if (!conditions.isEmpty()) {
            return BranchTooltipNode.branch().add(GenericTooltipUtils.getConditionListTooltip(utils, conditions));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static ITooltipNode getFunctionListTooltip(IServerUtils utils, List<LootItemFunction> functions) {
        ArrayTooltipNode.Builder array = ArrayTooltipNode.array();
        for (LootItemFunction function : functions) {
            array.add(utils.getFunctionTooltip(utils, function));
        }
        return array.build();
    }

    @NotNull
    public static ITooltipNode getFunctionsTooltip(IServerUtils utils, List<LootItemFunction> functions) {
        if (!functions.isEmpty()) {
            return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.util.advanced_loot_info.delimiter.functions")).add(GenericTooltipUtils.getFunctionListTooltip(utils, functions)).build();
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static ITooltipNode getPropertyMatcherTooltip(IServerUtils ignoredUtils, StatePropertiesPredicate.PropertyMatcher propertyMatcher) {
        if (propertyMatcher instanceof StatePropertiesPredicate.ExactPropertyMatcher) {
            StatePropertiesPredicate.ExactPropertyMatcher matcher = (StatePropertiesPredicate.ExactPropertyMatcher)propertyMatcher;
            return ValueTooltipNode.value(matcher.f_67715_, matcher.f_67707_).build("ali.util.advanced_loot_info.key_value");
        }
        if (propertyMatcher instanceof StatePropertiesPredicate.RangedPropertyMatcher) {
            StatePropertiesPredicate.RangedPropertyMatcher matcher = (StatePropertiesPredicate.RangedPropertyMatcher)propertyMatcher;
            String min = matcher.f_67727_;
            String max = matcher.f_67728_;
            if (min != null) {
                if (max != null) {
                    return ValueTooltipNode.value(matcher.f_67715_, min, max).build("ali.property.value.ranged_property_both");
                }
                return ValueTooltipNode.value(matcher.f_67715_, min).build("ali.property.value.ranged_property_gte");
            }
            if (max != null) {
                return ValueTooltipNode.value(matcher.f_67715_, max).build("ali.property.value.ranged_property_lte");
            }
            return ValueTooltipNode.value(matcher.f_67715_).build("ali.property.value.ranged_property_any");
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static IKeyTooltipNode getStatsTooltip(IServerUtils utils, Map<Stat<?>, MinMaxBounds.Ints> statIntsMap) {
        if (!statIntsMap.isEmpty()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            statIntsMap.forEach((stat, ints) -> {
                Object value = stat.m_12867_();
                if (value instanceof Item) {
                    Item item = (Item)value;
                    IKeyTooltipNode itemTooltip = utils.getValueTooltip(utils, item);
                    itemTooltip.add(ValueTooltipNode.keyValue(ValueTooltipNode.translate(stat.m_12859_().m_12904_()), GenericTooltipUtils.toString(ints)).build("ali.property.value.null"));
                    tooltip.add(itemTooltip.build("ali.property.value.item"));
                } else if (value instanceof Block) {
                    Block block = (Block)value;
                    IKeyTooltipNode blockTooltip = utils.getValueTooltip(utils, block);
                    blockTooltip.add(ValueTooltipNode.keyValue(ValueTooltipNode.translate(stat.m_12859_().m_12904_()), GenericTooltipUtils.toString(ints)).build("ali.property.value.null"));
                    tooltip.add(blockTooltip.build("ali.property.value.block"));
                } else if (value instanceof EntityType) {
                    EntityType entityType = (EntityType)value;
                    IKeyTooltipNode entityTooltip = utils.getValueTooltip(utils, entityType);
                    entityTooltip.add(ValueTooltipNode.keyValue(ValueTooltipNode.translate(stat.m_12859_().m_12904_()), GenericTooltipUtils.toString(ints)).build("ali.property.value.null"));
                    tooltip.add(entityTooltip.build("ali.property.value.entity_type"));
                } else if (value instanceof ResourceLocation) {
                    ResourceLocation resourceLocation = (ResourceLocation)value;
                    IKeyTooltipNode locationTooltip = utils.getValueTooltip(utils, resourceLocation);
                    locationTooltip.add(ValueTooltipNode.keyValue(ValueTooltipNode.translate(GenericTooltipUtils.getTranslationKey(resourceLocation)), GenericTooltipUtils.toString(ints)).build("ali.property.value.null"));
                    tooltip.add(locationTooltip.build("ali.property.value.id"));
                }
            });
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static <T> IKeyTooltipNode getCollectionTooltip(IServerUtils utils, Collection<T> values, BiFunction<IServerUtils, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            values.forEach(value -> tooltip.add((ITooltipNode)mapper.apply(utils, value)));
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getCollectionTooltip(IServerUtils utils, String value, @Nullable Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return EmptyTooltipNode.empty();
        }
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        for (Object o : collection) {
            tooltip.add(utils.getValueTooltip(utils, o).build(value));
        }
        return tooltip;
    }

    @NotNull
    public static <K, V> IKeyTooltipNode getMapTooltip(IServerUtils utils, Map<K, V> values, BiFunction<IServerUtils, Map.Entry<K, V>, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            values.entrySet().forEach(e -> tooltip.add((ITooltipNode)mapper.apply(utils, (Map.Entry)e)));
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static ITooltipNode getRecipeEntryTooltip(IServerUtils ignoredUtils, Map.Entry<ResourceLocation, Boolean> entry) {
        return ValueTooltipNode.keyValue(entry.getKey(), entry.getValue()).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getCriterionEntryTooltip(IServerUtils ignoredUtils, Map.Entry<String, Boolean> entry) {
        return ValueTooltipNode.keyValue(entry.getKey(), entry.getValue()).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getIntRangeEntryTooltip(IServerUtils utils, Map.Entry<String, IntRange> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.limit")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getMobEffectPredicateEntryTooltip(IServerUtils utils, Map.Entry<MobEffect, MobEffectsPredicate.MobEffectInstancePredicate> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue().f_56566_).build("ali.property.value.amplifier")).add(utils.getValueTooltip(utils, entry.getValue().f_56567_).build("ali.property.value.duration")).add(utils.getValueTooltip(utils, entry.getValue().f_56568_).build("ali.property.value.is_ambient")).add(utils.getValueTooltip(utils, entry.getValue().f_56569_).build("ali.property.value.is_visible")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getEnchantmentLevelsEntryTooltip(IServerUtils utils, Map.Entry<Enchantment, NumberProvider> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.levels")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getMobEffectDurationEntryTooltip(IServerUtils utils, Map.Entry<MobEffect, NumberProvider> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.duration")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getAdvancementEntryTooltip(IServerUtils utils, Map.Entry<ResourceLocation, PlayerPredicate.AdvancementPredicate> entry) {
        IKeyTooltipNode tooltip = utils.getValueTooltip(utils, entry.getKey());
        IKeyTooltipNode value = utils.getValueTooltip(utils, entry.getValue());
        if (value instanceof ValueTooltipNode.Builder) {
            tooltip.add(value.build("ali.property.value.done"));
        } else {
            tooltip.add(value.build("ali.property.branch.criterions"));
        }
        return tooltip.build("ali.property.value.null");
    }

    @NotNull
    public static String toString(MinMaxBounds.Doubles doubles) {
        Double min = (Double)doubles.m_55305_();
        Double max = (Double)doubles.m_55326_();
        if (min != null) {
            if (max != null) {
                if (!Objects.equals(min, max)) {
                    return String.format("%.1f-%.1f", min, max);
                }
                return String.format("=%.1f", min);
            }
            return String.format("\u2265%.1f", min);
        }
        if (max != null) {
            return String.format("\u2264%.1f", max);
        }
        return "???";
    }

    @NotNull
    public static String toString(MinMaxBounds.Ints ints) {
        Integer min = (Integer)ints.m_55305_();
        Integer max = (Integer)ints.m_55326_();
        if (min != null) {
            if (max != null) {
                if (!Objects.equals(min, max)) {
                    return String.format("%d-%d", min, max);
                }
                return String.format("=%d", min);
            }
            return String.format("\u2265%d", min);
        }
        if (max != null) {
            return String.format("\u2264%d", max);
        }
        return "???";
    }

    @NotNull
    private static String getTranslationKey(ResourceLocation location) {
        return "stat." + location.toString().replace(':', '.');
    }
}

