/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.common.GameplayLootType;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.jei.JeiBaseLoot;
import com.yanny.ali.compatibility.jei.RecipeHolder;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import java.util.List;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8029;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class JeiGameplayLoot
extends JeiBaseLoot<GameplayLootType, class_2960> {
    public JeiGameplayLoot(IGuiHelper guiHelper, RecipeType<RecipeHolder<GameplayLootType>> recipeType, LootCategory<class_2960> lootCategory, class_2561 title, IDrawable icon) {
        super(guiHelper, recipeType, lootCategory, title, icon);
    }

    @Override
    Pair<List<IRecipeWidget>, List<IRecipeSlotDrawable>> getWidgets(IRecipeExtrasBuilder builder, GameplayLootType recipe) {
        String key = "ali/loot_table/" + recipe.id();
        class_2561 text = GenericUtils.ellipsis(key, "/" + recipe.id(), 162);
        class_5250 fullText = class_2561.method_48321((String)key, (String)("/" + recipe.id()));
        Rect rect = new Rect(0, 0, 162, 8);
        return new Pair(List.of(this.createTextWidget(text, 0, false), new TooltipWidget((class_2561)fullText, rect)), List.of());
    }

    @Override
    int getYOffset(GameplayLootType recipe) {
        return 10;
    }

    @Override
    IWidget getRootWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth) {
        return new LootTableWidget(utils, entry, rect, maxWidth);
    }

    private record TooltipWidget(class_2561 component, Rect rect) implements IRecipeWidget
    {
        @NotNull
        public class_8029 getPosition() {
            return new class_8029(this.rect().x(), this.rect.y());
        }

        public void getTooltip(ITooltipBuilder tooltip, double mouseX, double mouseY) {
            if (this.rect.contains((int)mouseX, (int)mouseY)) {
                tooltip.add((class_5348)this.component);
            }
        }
    }
}

