/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.common.tooltip.BranchTooltipNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ErrorTooltipNode;
import com.yanny.ali.plugin.common.tooltip.LiteralTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.class_117;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2096;
import net.minecraft.class_2102;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_42;
import net.minecraft.class_4553;
import net.minecraft.class_4559;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericTooltipUtils {
    @NotNull
    public static ITooltipNode getMissingFunction(IServerUtils utils, class_117 function) {
        IKeyTooltipNode tooltip = RegistriesTooltipUtils.getFunctionTypeTooltip(utils, function.method_29321());
        Field[] fields = function.getClass().getDeclaredFields();
        List<Field> names = Arrays.stream(fields).filter(f -> !Modifier.isStatic(f.getModifiers())).toList();
        names.forEach(f -> {
            f.setAccessible(true);
            try {
                IKeyTooltipNode t = utils.getValueTooltip(utils, f.get(function));
                if (t instanceof ValueTooltipNode.Builder) {
                    ValueTooltipNode.Builder builder = (ValueTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof BranchTooltipNode.Builder) {
                    BranchTooltipNode.Builder builder = (BranchTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof ErrorTooltipNode.Builder) {
                    tooltip.add(ValueTooltipNode.keyValue(f.getName(), "???").build("ali.property.value.null"));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        return tooltip.build("ali.util.advanced_loot_info.auto_detected");
    }

    @NotNull
    public static ITooltipNode getMissingCondition(IServerUtils utils, class_5341 condition) {
        IKeyTooltipNode tooltip = RegistriesTooltipUtils.getConditionTypeTooltip(utils, condition.method_29325());
        Field[] fields = condition.getClass().getDeclaredFields();
        List<Field> names = Arrays.stream(fields).filter(f -> !Modifier.isStatic(f.getModifiers())).toList();
        names.forEach(f -> {
            f.setAccessible(true);
            try {
                IKeyTooltipNode t = utils.getValueTooltip(utils, f.get(condition));
                if (t instanceof ValueTooltipNode.Builder) {
                    ValueTooltipNode.Builder builder = (ValueTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof BranchTooltipNode.Builder) {
                    BranchTooltipNode.Builder builder = (BranchTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof ErrorTooltipNode.Builder) {
                    tooltip.add(ValueTooltipNode.keyValue(f.getName(), "???").build("ali.property.value.null"));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        return tooltip.build("ali.util.advanced_loot_info.auto_detected");
    }

    @NotNull
    public static ITooltipNode getConditionListTooltip(IServerUtils utils, List<class_5341> conditions) {
        ArrayTooltipNode.Builder array = ArrayTooltipNode.array();
        for (class_5341 condition : conditions) {
            array.add(utils.getConditionTooltip(utils, condition));
        }
        return array.build();
    }

    @NotNull
    public static ITooltipNode getConditionsTooltip(IServerUtils utils, List<class_5341> conditions) {
        if (!conditions.isEmpty()) {
            return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.util.advanced_loot_info.delimiter.conditions")).add(GenericTooltipUtils.getConditionListTooltip(utils, conditions)).build();
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static IKeyTooltipNode getSubConditionsTooltip(IServerUtils utils, List<class_5341> conditions) {
        if (!conditions.isEmpty()) {
            return BranchTooltipNode.branch().add(GenericTooltipUtils.getConditionListTooltip(utils, conditions));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static ITooltipNode getFunctionListTooltip(IServerUtils utils, List<class_117> functions) {
        ArrayTooltipNode.Builder array = ArrayTooltipNode.array();
        for (class_117 function : functions) {
            array.add(utils.getFunctionTooltip(utils, function));
        }
        return array.build();
    }

    @NotNull
    public static ITooltipNode getFunctionsTooltip(IServerUtils utils, List<class_117> functions) {
        if (!functions.isEmpty()) {
            return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.util.advanced_loot_info.delimiter.functions")).add(GenericTooltipUtils.getFunctionListTooltip(utils, functions)).build();
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static ITooltipNode getPropertyMatcherTooltip(IServerUtils ignoredUtils, class_4559.class_4562 propertyMatcher) {
        if (propertyMatcher instanceof class_4559.class_4561) {
            class_4559.class_4561 matcher = (class_4559.class_4561)propertyMatcher;
            return ValueTooltipNode.value(matcher.field_20740, matcher.field_20739).build("ali.util.advanced_loot_info.key_value");
        }
        if (propertyMatcher instanceof class_4559.class_4563) {
            class_4559.class_4563 matcher = (class_4559.class_4563)propertyMatcher;
            String min = matcher.field_20741;
            String max = matcher.field_20742;
            if (min != null) {
                if (max != null) {
                    return ValueTooltipNode.value(matcher.field_20740, min, max).build("ali.property.value.ranged_property_both");
                }
                return ValueTooltipNode.value(matcher.field_20740, min).build("ali.property.value.ranged_property_gte");
            }
            if (max != null) {
                return ValueTooltipNode.value(matcher.field_20740, max).build("ali.property.value.ranged_property_lte");
            }
            return ValueTooltipNode.value(matcher.field_20740).build("ali.property.value.ranged_property_any");
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static IKeyTooltipNode getStatsTooltip(IServerUtils utils, Map<class_3445<?>, class_2096.class_2100> statIntsMap) {
        if (!statIntsMap.isEmpty()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            statIntsMap.forEach((stat, ints) -> {
                Object value = stat.method_14951();
                if (value instanceof class_1792) {
                    class_1792 item = (class_1792)value;
                    IKeyTooltipNode itemTooltip = utils.getValueTooltip(utils, item);
                    itemTooltip.add(ValueTooltipNode.keyValue(ValueTooltipNode.translate(stat.method_14949().method_14957()), GenericTooltipUtils.toString(ints)).build("ali.property.value.null"));
                    tooltip.add(itemTooltip.build("ali.property.value.item"));
                } else if (value instanceof class_2248) {
                    class_2248 block = (class_2248)value;
                    IKeyTooltipNode blockTooltip = utils.getValueTooltip(utils, block);
                    blockTooltip.add(ValueTooltipNode.keyValue(ValueTooltipNode.translate(stat.method_14949().method_14957()), GenericTooltipUtils.toString(ints)).build("ali.property.value.null"));
                    tooltip.add(blockTooltip.build("ali.property.value.block"));
                } else if (value instanceof class_1299) {
                    class_1299 entityType = (class_1299)value;
                    IKeyTooltipNode entityTooltip = utils.getValueTooltip(utils, entityType);
                    entityTooltip.add(ValueTooltipNode.keyValue(ValueTooltipNode.translate(stat.method_14949().method_14957()), GenericTooltipUtils.toString(ints)).build("ali.property.value.null"));
                    tooltip.add(entityTooltip.build("ali.property.value.entity_type"));
                } else if (value instanceof class_2960) {
                    class_2960 resourceLocation = (class_2960)value;
                    IKeyTooltipNode locationTooltip = utils.getValueTooltip(utils, resourceLocation);
                    locationTooltip.add(ValueTooltipNode.keyValue(ValueTooltipNode.translate(GenericTooltipUtils.getTranslationKey(resourceLocation)), GenericTooltipUtils.toString(ints)).build("ali.property.value.null"));
                    tooltip.add(locationTooltip.build("ali.property.value.id"));
                }
            });
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static <T> IKeyTooltipNode getCollectionTooltip(IServerUtils utils, Collection<T> values, BiFunction<IServerUtils, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            values.forEach(value -> tooltip.add((ITooltipNode)mapper.apply(utils, value)));
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getCollectionTooltip(IServerUtils utils, String value, @Nullable Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return EmptyTooltipNode.empty();
        }
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        for (Object o : collection) {
            tooltip.add(utils.getValueTooltip(utils, o).build(value));
        }
        return tooltip;
    }

    @NotNull
    public static <K, V> IKeyTooltipNode getMapTooltip(IServerUtils utils, Map<K, V> values, BiFunction<IServerUtils, Map.Entry<K, V>, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            values.entrySet().forEach(e -> tooltip.add((ITooltipNode)mapper.apply(utils, (Map.Entry)e)));
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static ITooltipNode getRecipeEntryTooltip(IServerUtils ignoredUtils, Map.Entry<class_2960, Boolean> entry) {
        return ValueTooltipNode.keyValue(entry.getKey(), entry.getValue()).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getCriterionEntryTooltip(IServerUtils ignoredUtils, Map.Entry<String, Boolean> entry) {
        return ValueTooltipNode.keyValue(entry.getKey(), entry.getValue()).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getIntRangeEntryTooltip(IServerUtils utils, Map.Entry<String, class_42> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.limit")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getMobEffectPredicateEntryTooltip(IServerUtils utils, Map.Entry<class_1291, class_2102.class_2103> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue().field_9711).build("ali.property.value.amplifier")).add(utils.getValueTooltip(utils, entry.getValue().field_9713).build("ali.property.value.duration")).add(utils.getValueTooltip(utils, entry.getValue().field_9714).build("ali.property.value.is_ambient")).add(utils.getValueTooltip(utils, entry.getValue().field_9712).build("ali.property.value.is_visible")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getEnchantmentLevelsEntryTooltip(IServerUtils utils, Map.Entry<class_1887, class_5658> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.levels")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getMobEffectDurationEntryTooltip(IServerUtils utils, Map.Entry<class_1291, class_5658> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.duration")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getAdvancementEntryTooltip(IServerUtils utils, Map.Entry<class_2960, class_4553.class_4556> entry) {
        IKeyTooltipNode tooltip = utils.getValueTooltip(utils, entry.getKey());
        IKeyTooltipNode value = utils.getValueTooltip(utils, entry.getValue());
        if (value instanceof ValueTooltipNode.Builder) {
            tooltip.add(value.build("ali.property.value.done"));
        } else {
            tooltip.add(value.build("ali.property.branch.criterions"));
        }
        return tooltip.build("ali.property.value.null");
    }

    @NotNull
    public static String toString(class_2096.class_2099 doubles) {
        Double min = (Double)doubles.method_9038();
        Double max = (Double)doubles.method_9042();
        if (min != null) {
            if (max != null) {
                if (!Objects.equals(min, max)) {
                    return String.format("%.1f-%.1f", min, max);
                }
                return String.format("=%.1f", min);
            }
            return String.format("\u2265%.1f", min);
        }
        if (max != null) {
            return String.format("\u2264%.1f", max);
        }
        return "???";
    }

    @NotNull
    public static String toString(class_2096.class_2100 ints) {
        Integer min = (Integer)ints.method_9038();
        Integer max = (Integer)ints.method_9042();
        if (min != null) {
            if (max != null) {
                if (!Objects.equals(min, max)) {
                    return String.format("%d-%d", min, max);
                }
                return String.format("=%d", min);
            }
            return String.format("\u2265%d", min);
        }
        if (max != null) {
            return String.format("\u2264%d", max);
        }
        return "???";
    }

    @NotNull
    private static String getTranslationKey(class_2960 location) {
        return "stat." + location.toString().replace(':', '.');
    }
}

