/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.RangeValue;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_106;
import net.minecraft.class_109;
import net.minecraft.class_114;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_125;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_137;
import net.minecraft.class_141;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_182;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_219;
import net.minecraft.class_225;
import net.minecraft.class_3670;
import net.minecraft.class_44;
import net.minecraft.class_5341;
import net.minecraft.class_5659;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_94;
import org.jetbrains.annotations.NotNull;

public class TooltipUtils {
    @NotNull
    public static Map<class_1887, Map<Integer, RangeValue>> getChance(IServerUtils utils, List<class_5341> conditions, float rawChance) {
        LinkedHashMap<class_1887, Map<Integer, RangeValue>> chance = new LinkedHashMap<class_1887, Map<Integer, RangeValue>>();
        chance.put(null, Map.of(0, new RangeValue(rawChance * 100.0f)));
        for (class_5341 condition : conditions) {
            utils.applyChanceModifier(utils, condition, chance);
        }
        return chance;
    }

    @NotNull
    public static Map<class_1887, Map<Integer, RangeValue>> getCount(IServerUtils utils, List<class_117> functions) {
        LinkedHashMap<class_1887, Map<Integer, RangeValue>> count = new LinkedHashMap<class_1887, Map<Integer, RangeValue>>();
        count.put(null, Map.of(0, new RangeValue()));
        for (class_117 function : functions) {
            utils.applyCountModifier(utils, function, count);
        }
        return count;
    }

    public static class_1799 getItemStack(IServerUtils utils, class_1799 itemStack, List<class_117> functions) {
        for (class_117 function : functions) {
            itemStack = utils.applyItemStackModifier(utils, function, itemStack);
        }
        return itemStack;
    }

    public static void applyRandomChance(IServerUtils utils, class_219 condition, Map<class_1887, Map<Integer, RangeValue>> chance) {
        for (Map.Entry<class_1887, Map<Integer, RangeValue>> chanceMap : chance.entrySet()) {
            for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                levelEntry.getValue().multiply(condition.field_1296);
            }
        }
    }

    public static void applyRandomChanceWithLooting(IServerUtils utils, class_225 condition, Map<class_1887, Map<Integer, RangeValue>> chance) {
        class_1887 enchantment = class_1893.field_9110;
        if (chance.containsKey(enchantment)) {
            chance.get(null).get(0).multiply(condition.field_1300);
            for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                entry.getValue().multiply(condition.field_1300 + (float)entry.getKey().intValue() * condition.field_1299);
            }
        } else {
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(condition.field_1300);
            chance.put(enchantment, levelMap);
            for (int level = 1; level <= enchantment.method_8183(); ++level) {
                levelMap.put(level, new RangeValue(baseChance).multiply(condition.field_1300 + (float)level * condition.field_1299));
            }
        }
    }

    public static void applyTableBonus(IServerUtils utils, class_182 condition, Map<class_1887, Map<Integer, RangeValue>> chance) {
        block2: {
            class_1887 enchantment;
            block3: {
                enchantment = condition.field_1234;
                if (condition.field_1235.length <= 0) break block2;
                if (!chance.containsKey(enchantment)) break block3;
                chance.get(null).get(0).multiply(condition.field_1235[0]);
                if (condition.field_1235.length <= 1) break block2;
                for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                    Integer level = entry.getKey();
                    if (level >= condition.field_1235.length) continue;
                    entry.getValue().multiply(condition.field_1235[level]);
                }
                break block2;
            }
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(condition.field_1235[0]);
            chance.put(enchantment, levelMap);
            for (int level = 1; level <= enchantment.method_8183() && level < condition.field_1235.length; ++level) {
                levelMap.put(level, new RangeValue(baseChance).multiply(condition.field_1235[level]));
            }
        }
    }

    public static void applySetCount(IServerUtils utils, class_141 function, Map<class_1887, Map<Integer, RangeValue>> count) {
        if (function.field_1047.length == 0) {
            for (Map.Entry<class_1887, Map<Integer, RangeValue>> chanceMap : count.entrySet()) {
                for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                    if (function.field_27909) {
                        levelEntry.getValue().add(utils.convertNumber(utils, function.field_1114));
                        continue;
                    }
                    levelEntry.getValue().set(utils.convertNumber(utils, function.field_1114));
                }
            }
        }
    }

    public static void applyBonus(IServerUtils utils, class_94 function, Map<class_1887, Map<Integer, RangeValue>> count) {
        block4: {
            if (function.field_1047.length != 0) break block4;
            class_1887 enchantment = function.field_1011;
            if (count.containsKey(enchantment)) {
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    TooltipUtils.calculateCount(function, entry.getValue(), entry.getKey());
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                count.put(enchantment, levelMap);
                for (int level = 1; level <= enchantment.method_8183(); ++level) {
                    RangeValue value = new RangeValue(baseCount);
                    TooltipUtils.calculateCount(function, value, level);
                    levelMap.put(level, value);
                }
            }
        }
    }

    public static void applyLimitCount(IServerUtils utils, class_114 function, Map<class_1887, Map<Integer, RangeValue>> bonusCount) {
        if (function.field_1047.length == 0) {
            for (Map.Entry<class_1887, Map<Integer, RangeValue>> entry : bonusCount.entrySet()) {
                for (Map.Entry<Integer, RangeValue> mapEntry : entry.getValue().entrySet()) {
                    RangeValue value = mapEntry.getValue();
                    value.clamp(utils.convertNumber(utils, function.field_1044.field_921), utils.convertNumber(utils, function.field_1044.field_920));
                }
            }
        }
    }

    public static void applyLootingEnchant(IServerUtils utils, class_125 function, Map<class_1887, Map<Integer, RangeValue>> count) {
        block5: {
            if (function.field_1047.length != 0) break block5;
            class_1887 enchantment = class_1893.field_9110;
            if (count.containsKey(enchantment)) {
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    RangeValue value = entry.getValue();
                    value.add(utils.convertNumber(utils, function.field_1082).multiply(entry.getKey().intValue()));
                    if (function.field_1083 <= 0) continue;
                    value.clamp(new RangeValue(false, true), new RangeValue(function.field_1083));
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                count.put(enchantment, levelMap);
                for (int level = 1; level <= enchantment.method_8183(); ++level) {
                    RangeValue value = new RangeValue(baseCount).add(utils.convertNumber(utils, function.field_1082).multiply(level));
                    if (function.field_1083 > 0) {
                        value.clamp(new RangeValue(false, true), new RangeValue(function.field_1083));
                    }
                    levelMap.put(level, value);
                }
            }
        }
    }

    @NotNull
    public static class_1799 applyEnchantRandomlyItemStackModifier(IServerUtils utils, class_109 function, class_1799 itemStack) {
        if (itemStack.method_7923() && function.field_1047.length == 0) {
            boolean isBook = itemStack.method_31574(class_1802.field_8529);
            class_1799 finalItemStack = itemStack;
            List<class_1887> enchantments = function.field_1030;
            if (enchantments.isEmpty()) {
                enchantments = class_7923.field_41176.method_10220().filter(class_1887::method_25950).filter(enchantment -> isBook || enchantment.method_8192(finalItemStack)).toList();
            }
            if (enchantments.size() == 1 && ((class_1887)enchantments.get(0)).method_8187() == enchantments.get(0).method_8183()) {
                itemStack.method_7978(enchantments.get(0), enchantments.get(0).method_8183());
            } else if (isBook) {
                itemStack = class_1802.field_8598.method_7854();
            }
        }
        return itemStack;
    }

    @NotNull
    public static class_1799 applyEnchantWithLevelsItemStackModifier(IServerUtils utils, class_106 function, class_1799 itemStack) {
        if (itemStack.method_7923() && function.field_1047.length == 0 && itemStack.method_31574(class_1802.field_8529)) {
            itemStack = class_1802.field_8598.method_7854();
        }
        return itemStack;
    }

    public static class_1799 applySetAttributesItemStackModifier(IServerUtils utils, class_137 function, class_1799 itemStack) {
        if (function.field_1047.length == 0) {
            for (class_137.class_138 modifier : function.field_1105) {
                UUID id = modifier.field_1111;
                if (id == null) {
                    id = UUID.randomUUID();
                }
                if (modifier.field_1112.length != 1 || modifier.field_1108.method_365() != class_5659.field_27921) continue;
                class_1304 equipmentSlot = (class_1304)class_156.method_27173((Object[])modifier.field_1112, (class_5819)class_5819.method_43047());
                class_44 value = (class_44)modifier.field_1108;
                itemStack.method_7916(modifier.field_1110, new class_1322(id, modifier.field_1107, (double)value.method_32454(null), modifier.field_1109), equipmentSlot);
            }
        }
        return itemStack;
    }

    public static class_1799 applySetNameItemStackModifier(IServerUtils utils, class_3670 function, class_1799 itemStack) {
        if (function.field_1047.length == 0) {
            itemStack.method_7977(function.field_16228);
        }
        return itemStack;
    }

    public static class_1799 applyItemStackModifier(IServerUtils utils, class_117 function, class_1799 itemStack) {
        if (function instanceof class_120) {
            class_120 conditional = (class_120)function;
            if (conditional.field_1047.length > 0) {
                return itemStack;
            }
        }
        itemStack = (class_1799)function.apply((Object)itemStack, null);
        return itemStack;
    }

    private static void calculateCount(class_94 function, RangeValue value, int level) {
        if (function.field_1009 instanceof class_94.class_98) {
            if (level > 0) {
                value.multiplyMax(level + 1);
            }
        } else {
            class_94.class_96 class_962 = function.field_1009;
            if (class_962 instanceof class_94.class_95) {
                class_94.class_95 binomialWithBonusCount = (class_94.class_95)class_962;
                value.addMax(binomialWithBonusCount.field_1014 + level);
            } else {
                class_962 = function.field_1009;
                if (class_962 instanceof class_94.class_100) {
                    class_94.class_100 uniformBonusCount = (class_94.class_100)class_962;
                    if (level > 0) {
                        value.addMax(uniformBonusCount.field_1017 * level);
                    }
                }
            }
        }
    }
}

