/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.api;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.api.WidgetDirection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_7836;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ListWidget
implements IWidget {
    public static final class_2960 TEXTURE_LOC = class_2960.method_60655((String)"ali", (String)"textures/gui/gui.png");
    public static final int GROUP_WIDGET_WIDTH = 7;
    public static final int GROUP_WIDGET_HEIGHT = 18;
    private final List<IWidget> widgets;
    private final RelativeRect bounds;
    private final int groupWidgetWidth;

    public ListWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth) {
        this(utils, entry, rect, maxWidth, entry);
    }

    public ListWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth, IDataNode tooltipNode) {
        IWidget groupWidget = this.getLootGroupWidget(rect, tooltipNode);
        boolean hasGroupWidget = groupWidget != null;
        ArrayList<IWidget> children = null;
        this.groupWidgetWidth = hasGroupWidget ? groupWidget.getRect().width : 0;
        this.bounds = rect;
        if (hasGroupWidget) {
            children = new ArrayList<IWidget>();
            children.add(groupWidget);
        }
        if (entry instanceof ListNode) {
            ListNode listNode = (ListNode)entry;
            RelativeRect subRect = new RelativeRect(this.groupWidgetWidth, 0, rect.width - this.groupWidgetWidth, 0, rect);
            List<IDataNode> nodes = listNode.nodes();
            if (!nodes.isEmpty()) {
                List<IWidget> widgetList = utils.createWidgets(utils, nodes, subRect, maxWidth);
                if (children != null) {
                    children.addAll(widgetList);
                } else {
                    children = new ArrayList<IWidget>(widgetList);
                }
            }
            this.bounds.setDimensions(subRect.width + this.groupWidgetWidth, subRect.height);
        } else {
            this.bounds.setDimensions(7, 18);
        }
        this.widgets = children != null ? children : Collections.emptyList();
    }

    @Nullable
    public abstract IWidget getLootGroupWidget(RelativeRect var1, IDataNode var2);

    @Override
    public RelativeRect getRect() {
        return this.bounds;
    }

    @Override
    public WidgetDirection getDirection() {
        return WidgetDirection.VERTICAL;
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY) {
        int lastY = 0;
        WidgetDirection lastDirection = null;
        for (IWidget widget : this.widgets) {
            widget.render(guiGraphics, mouseX, mouseY);
            WidgetDirection direction = widget.getDirection();
            if (direction == WidgetDirection.VERTICAL || lastDirection != null && direction != lastDirection) {
                lastY = Math.max(lastY, widget.getRect().getY());
            }
            lastDirection = direction;
        }
        int top = this.bounds.getY() + 18;
        int height = lastY - this.bounds.getY() - 9;
        ListWidget.blitRepeating(guiGraphics, TEXTURE_LOC, this.bounds.getX() + this.groupWidgetWidth / 2, top, 2, height, 0, 0, 2, 18);
        lastDirection = null;
        for (IWidget widget : this.widgets) {
            WidgetDirection direction = widget.getDirection();
            if ((direction == WidgetDirection.VERTICAL || lastDirection != null && direction != lastDirection) && widget.getRect().offsetY > 0) {
                ListWidget.blitRepeating(guiGraphics, TEXTURE_LOC, (int)((double)this.bounds.getX() + Math.floor((double)this.groupWidgetWidth / 2.0) + 1.0), widget.getRect().getY() + 8, (int)(Math.ceil((double)this.groupWidgetWidth / 2.0) - 1.0), 2, 2, 0, 18, 2);
            }
            lastDirection = direction;
        }
    }

    @Override
    public List<class_2561> getTooltipComponents(int mouseX, int mouseY) {
        LinkedList<class_2561> components = new LinkedList<class_2561>();
        for (IWidget widget : this.widgets) {
            RelativeRect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            components.addAll(widget.getTooltipComponents(mouseX, mouseY));
        }
        return components;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        boolean clicked = false;
        for (IWidget widget : this.widgets) {
            RelativeRect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            clicked |= widget.mouseClicked(mouseX, mouseY, button);
        }
        return clicked;
    }

    public static void blit(class_332 guiGraphics, class_2960 pAtlasLocation, int pX, int pY, int pWidth, int pHeight, float pUOffset, float pVOffset, int pUWidth, int pVHeight) {
        guiGraphics.method_25302(class_10799.field_56883, pAtlasLocation, pX, pY, pUOffset, pVOffset, pWidth, pHeight, pUWidth, pVHeight, 255, 255);
    }

    public static void blit(class_332 guiGraphics, class_2960 pAtlasLocation, int pX, int pY, float pUOffset, float pVOffset, int pWidth, int pHeight) {
        ListWidget.blit(guiGraphics, pAtlasLocation, pX, pY, pWidth, pHeight, pUOffset, pVOffset, pWidth, pHeight);
    }

    public static void blitRepeating(class_332 guiGraphics, class_2960 pAtlasLocation, int pTargetX, int pTargetY, int pTargetWidth, int pTargetHeight, int pSourceX, int pSourceY, int pSourceWidth, int pSourceHeight) {
        int i = pTargetX;
        IntIterator intiterator = ListWidget.slices(pTargetWidth, pSourceWidth);
        while (intiterator.hasNext()) {
            int j = intiterator.nextInt();
            int k = (pSourceWidth - j) / 2;
            int l = pTargetY;
            IntIterator intiterator1 = ListWidget.slices(pTargetHeight, pSourceHeight);
            while (intiterator1.hasNext()) {
                int i1 = intiterator1.nextInt();
                int j1 = (pSourceHeight - i1) / 2;
                ListWidget.blit(guiGraphics, pAtlasLocation, i, l, pSourceX + k, pSourceY + j1, j, i1);
                l += i1;
            }
            i += j;
        }
    }

    @NotNull
    private static IntIterator slices(int p_282197_, int p_282161_) {
        int i = class_3532.method_38788((int)p_282197_, (int)p_282161_);
        return new class_7836(p_282197_, i);
    }
}

