/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.lootjs.node;

import com.almostreliable.lootjs.core.LootEntry;
import com.almostreliable.lootjs.loot.action.AddLootAction;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.mixin.MixinAddLootAction;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.lootjs.Utils;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class AddLootNode
extends ListNode {
    public static final ResourceLocation ID = new ResourceLocation("lootjs", "add_loot");
    private final List<ITooltipNode> tooltip;
    private final AddLootAction.AddType addType;

    public AddLootNode(IServerUtils utils, AddLootAction lootAction, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        int sumWeight;
        MixinAddLootAction mixinAddLootAction = (MixinAddLootAction)lootAction;
        if (mixinAddLootAction.getType() == AddLootAction.AddType.DEFAULT) {
            sumWeight = 0;
            for (LootEntry entry : mixinAddLootAction.getEntries()) {
                sumWeight += entry.getWeight();
            }
        } else {
            sumWeight = 1;
        }
        for (LootEntry entry : mixinAddLootAction.getEntries()) {
            this.addChildren(Utils.getEntry(utils, entry, sumWeight, functions, conditions, true));
        }
        this.addType = mixinAddLootAction.getType();
        this.tooltip = switch (mixinAddLootAction.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case AddLootAction.AddType.DEFAULT -> EntryTooltipUtils.getGroupTooltip();
            case AddLootAction.AddType.SEQUENCE -> EntryTooltipUtils.getSequentialTooltip();
            case AddLootAction.AddType.ALTERNATIVES -> EntryTooltipUtils.getAlternativesTooltip();
        };
    }

    public AddLootNode(IClientUtils utils, FriendlyByteBuf buf) {
        super(utils, buf);
        this.tooltip = NodeUtils.decodeTooltipNodes(utils, buf);
        this.addType = (AddLootAction.AddType)buf.m_130066_(AddLootAction.AddType.class);
    }

    public AddLootAction.AddType getAddType() {
        return this.addType;
    }

    @Override
    public void encodeNode(IServerUtils utils, FriendlyByteBuf buf) {
        NodeUtils.encodeTooltipNodes(utils, buf, this.tooltip);
        buf.m_130068_((Enum)this.addType);
    }

    @Override
    public List<ITooltipNode> getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

