/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.compatibility.common.BlockLootType;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.GameplayLootType;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.common.TradeLootType;
import com.yanny.ali.compatibility.rei.ReiBaseCategory;
import com.yanny.ali.compatibility.rei.ReiBaseDisplay;
import com.yanny.ali.compatibility.rei.ReiBlockCategory;
import com.yanny.ali.compatibility.rei.ReiBlockDisplay;
import com.yanny.ali.compatibility.rei.ReiEntityCategory;
import com.yanny.ali.compatibility.rei.ReiEntityDisplay;
import com.yanny.ali.compatibility.rei.ReiGameplayCategory;
import com.yanny.ali.compatibility.rei.ReiGameplayDisplay;
import com.yanny.ali.compatibility.rei.ReiTradeCategory;
import com.yanny.ali.compatibility.rei.ReiTradeDisplay;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.AliCommonRegistry;
import com.yanny.ali.manager.PluginManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReasons;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ReiCompatibility
implements REIClientPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<LootCategory<Block>, Holder<ReiBlockDisplay, BlockLootType, Block>> blockCategories = new LinkedHashMap<LootCategory<Block>, Holder<ReiBlockDisplay, BlockLootType, Block>>();
    private final Map<LootCategory<EntityType<?>>, Holder<ReiEntityDisplay, EntityLootType, EntityType<?>>> entityCategories = new LinkedHashMap();
    private final Map<LootCategory<ResourceLocation>, Holder<ReiGameplayDisplay, GameplayLootType, ResourceLocation>> gameplayCategories = new LinkedHashMap<LootCategory<ResourceLocation>, Holder<ReiGameplayDisplay, GameplayLootType, ResourceLocation>>();
    private final Map<LootCategory<ResourceLocation>, Holder<ReiTradeDisplay, TradeLootType, ResourceLocation>> tradeCategories = new LinkedHashMap<LootCategory<ResourceLocation>, Holder<ReiTradeDisplay, TradeLootType, ResourceLocation>>();

    public void registerCategories(CategoryRegistry registry) {
        AliCommonRegistry commonRegistry = PluginManager.COMMON_REGISTRY;
        this.blockCategories.clear();
        this.entityCategories.clear();
        this.gameplayCategories.clear();
        this.tradeCategories.clear();
        this.blockCategories.putAll(commonRegistry.getConfiguration().blockCategories.stream().collect(ReiCompatibility.getCollector(ReiBlockDisplay::new, ReiBlockCategory::new)));
        this.entityCategories.putAll(commonRegistry.getConfiguration().entityCategories.stream().collect(ReiCompatibility.getCollector(ReiEntityDisplay::new, ReiEntityCategory::new)));
        this.gameplayCategories.putAll(commonRegistry.getConfiguration().gameplayCategories.stream().collect(ReiCompatibility.getCollector(ReiGameplayDisplay::new, ReiGameplayCategory::new)));
        this.tradeCategories.putAll(commonRegistry.getConfiguration().tradeCategories.stream().collect(ReiCompatibility.getCollector(ReiTradeDisplay::new, ReiTradeCategory::new)));
        for (Holder<ReiBlockDisplay, BlockLootType, Block> holder : this.blockCategories.values()) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.entityCategories.values()) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.gameplayCategories.values()) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.tradeCategories.values()) {
            registry.add(holder.category);
        }
    }

    public void registerDisplays(DisplayRegistry registry) {
        CompletableFuture<Pair<Map<ResourceLocation, IDataNode>, Map<ResourceLocation, IDataNode>>> futureData = PluginManager.CLIENT_REGISTRY.getCurrentDataFuture();
        if (futureData.isDone()) {
            LOGGER.info("Data already received, processing instantly.");
        } else {
            LOGGER.info("Blocking this thread until all data are received!");
        }
        try {
            Pair<Map<ResourceLocation, IDataNode>, Map<ResourceLocation, IDataNode>> pair = futureData.get();
            this.registerData(registry, (Map)pair.getLeft(), (Map)pair.getRight());
        }
        catch (ExecutionException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof TimeoutException) {
                futureData.cancel(true);
                PluginManager.CLIENT_REGISTRY.clearLootData();
                LOGGER.error("Failed to received data: Inactivity timeout occurred. Registration aborted!");
            } else {
                LOGGER.error("Failed to finish registering data with error {}", (Object)cause.getMessage());
                cause.printStackTrace();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.error("Failed to finish registering data with unexpected error {}", (Object)e.getMessage());
        }
    }

    private void registerData(DisplayRegistry registry, Map<ResourceLocation, IDataNode> lootData, Map<ResourceLocation, IDataNode> tradeData) {
        AliClientRegistry clientRegistry = PluginManager.CLIENT_REGISTRY;
        ClientLevel level = Minecraft.getInstance().level;
        LOGGER.info("Adding loot information to REI");
        if (level != null) {
            HashMap blockRecipeTypes = new HashMap();
            HashMap entityRecipeTypes = new HashMap();
            HashMap gameplayRecipeTypes = new HashMap();
            HashMap tradeRecipeTypes = new HashMap();
            GenericUtils.processData(level, clientRegistry, lootData, tradeData, (node, location, block, outputs) -> {
                Holder<ReiBlockDisplay, BlockLootType, Block> recipeHolder = null;
                for (Holder<ReiBlockDisplay, BlockLootType, Block> holder : this.blockCategories.values()) {
                    if (!holder.category.getLootCategory().validate(block)) continue;
                    if (holder.category.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeHolder = holder;
                    break;
                }
                if (recipeHolder != null) {
                    blockRecipeTypes.computeIfAbsent(recipeHolder, b -> new LinkedList()).add(new BlockLootType((Block)block, (IDataNode)node, Collections.emptyList(), (List<ItemStack>)outputs));
                }
            }, (node, location, entity, outputs) -> {
                Holder<ReiEntityDisplay, EntityLootType, EntityType<?>> recipeHolder = null;
                for (Holder<ReiEntityDisplay, EntityLootType, EntityType<?>> holder : this.entityCategories.values()) {
                    if (!holder.category.getLootCategory().validate(entity)) continue;
                    if (holder.category.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeHolder = holder;
                    break;
                }
                if (recipeHolder != null) {
                    entityRecipeTypes.computeIfAbsent(recipeHolder, b -> new LinkedList()).add(new EntityLootType((EntityType<?>)entity, (ResourceLocation)location, (IDataNode)node, Collections.emptyList(), (List<ItemStack>)outputs));
                }
            }, (node, location, outputs) -> {
                Holder<ReiGameplayDisplay, GameplayLootType, ResourceLocation> recipeHolder = null;
                for (Holder<ReiGameplayDisplay, GameplayLootType, ResourceLocation> holder : this.gameplayCategories.values()) {
                    if (!holder.category.getLootCategory().validate(location)) continue;
                    if (holder.category.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeHolder = holder;
                    break;
                }
                if (recipeHolder != null) {
                    gameplayRecipeTypes.computeIfAbsent(recipeHolder, b -> new LinkedList()).add(new GameplayLootType((IDataNode)node, location.getPath(), Collections.emptyList(), (List<ItemStack>)outputs));
                }
            }, (tradeEntry, location, inputs, outputs) -> {
                Holder<ReiTradeDisplay, TradeLootType, ResourceLocation> recipeHolder = null;
                for (Holder<ReiTradeDisplay, TradeLootType, ResourceLocation> holder : this.tradeCategories.values()) {
                    if (!holder.category.getLootCategory().validate(location)) continue;
                    if (holder.category.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeHolder = holder;
                    break;
                }
                if (recipeHolder != null) {
                    tradeRecipeTypes.computeIfAbsent(recipeHolder, b -> new LinkedList()).add(new TradeLootType((IDataNode)tradeEntry, location.getPath(), (List<ItemStack>)inputs, (List<ItemStack>)outputs));
                }
            }, (tradeEntry, location, inputs, outputs) -> {
                Holder<ReiTradeDisplay, TradeLootType, ResourceLocation> recipeHolder = null;
                for (Holder<ReiTradeDisplay, TradeLootType, ResourceLocation> holder : this.tradeCategories.values()) {
                    if (!holder.category.getLootCategory().validate(location)) continue;
                    if (holder.category.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeHolder = holder;
                    break;
                }
                if (recipeHolder != null) {
                    tradeRecipeTypes.computeIfAbsent(recipeHolder, b -> new LinkedList()).add(new TradeLootType((IDataNode)tradeEntry, location.getPath(), (List<ItemStack>)inputs, (List<ItemStack>)outputs));
                }
            });
            for (Map.Entry entry : blockRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.blockPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry entry : entityRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.entityPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry entry : gameplayRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.gameplayPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry entry : tradeRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.tradePredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
        } else {
            LOGGER.warn("REI integration was not loaded! Level is null!");
        }
    }

    @NotNull
    private static <D extends ReiBaseDisplay, T, U> Holder<D, T, U> createCategory(LootCategory<U> lootCategory, BiFunction<T, CategoryIdentifier<D>, D> displayFactory, TriFunction<CategoryIdentifier<D>, Component, LootCategory<U>, ReiBaseCategory<D, U>> categoryFactory) {
        CategoryIdentifier identifier = CategoryIdentifier.of((ResourceLocation)lootCategory.getKey());
        MutableComponent title = Component.translatable((String)("emi.category." + lootCategory.getKey().getNamespace() + "." + lootCategory.getKey().getPath().replace('/', '.')));
        BiFunction<Object, DisplayAdditionReasons, ReiBaseDisplay> filler = (type, r) -> (ReiBaseDisplay)((Object)((Object)displayFactory.apply(type, identifier)));
        return new Holder(identifier, (ReiBaseCategory)categoryFactory.apply((Object)identifier, (Object)title, lootCategory), filler);
    }

    @NotNull
    private static <D extends ReiBaseDisplay, T, U> Collector<LootCategory<U>, ?, Map<LootCategory<U>, Holder<D, T, U>>> getCollector(BiFunction<T, CategoryIdentifier<D>, D> displayFactory, TriFunction<CategoryIdentifier<D>, Component, LootCategory<U>, ReiBaseCategory<D, U>> categoryFactory) {
        return Collectors.toMap(e -> e, e -> ReiCompatibility.createCategory(e, displayFactory, categoryFactory), (a, b) -> a, LinkedHashMap::new);
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> blockPredicate(List<BlockLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof BlockLootType) {
                BlockLootType type = (BlockLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> entityPredicate(List<EntityLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof EntityLootType) {
                EntityLootType type = (EntityLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> gameplayPredicate(List<GameplayLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof GameplayLootType) {
                GameplayLootType type = (GameplayLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> tradePredicate(List<TradeLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof TradeLootType) {
                TradeLootType type = (TradeLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    private record Holder<D extends ReiBaseDisplay, T, U>(CategoryIdentifier<D> identifier, ReiBaseCategory<D, U> category, BiFunction<T, DisplayAdditionReasons, D> filler) {
    }
}

