/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.rei;

import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.rei.ReiBaseCategory;
import com.yanny.ali.compatibility.rei.ReiTradeDisplay;
import com.yanny.ali.configuration.LootCategory;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class ReiTradeCategory
extends ReiBaseCategory<ReiTradeDisplay, ResourceLocation> {
    private static final int OFFSET = 10;
    private final CategoryIdentifier<ReiTradeDisplay> identifier;
    private final Component title;
    private final ItemStack icon;

    public ReiTradeCategory(CategoryIdentifier<ReiTradeDisplay> identifier, Component title, LootCategory<ResourceLocation> lootCategory) {
        super(lootCategory);
        this.identifier = identifier;
        this.title = title;
        this.icon = lootCategory.getIcon().getDefaultInstance();
    }

    @Override
    public List<Widget> setupDisplay(ReiTradeDisplay display, Rectangle bounds) {
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        String key = display.getId().equals("empty") ? "entity.minecraft.wandering_trader" : "entity.minecraft.villager." + display.getId();
        String id = display.getId().equals("empty") ? "wandering_trader" : display.getId();
        Component lootName = GenericUtils.ellipsis(key, id, bounds.width);
        MutableComponent fullText = Component.translatableWithFallback((String)key, (String)id);
        int textWidth = Minecraft.getInstance().font.width((FormattedText)lootName);
        ReiBaseCategory.WidgetHolder holder = this.getBaseWidget(display, new Rectangle(0, 0, bounds.width, bounds.height), 10);
        int with = Mth.clamp((int)holder.bounds().width, (int)textWidth, (int)bounds.width);
        int innerWidth = with % 2 == 0 ? with : with + 1;
        Rectangle innerBounds = new Rectangle(0, 0, innerWidth, holder.bounds().height + 10);
        int height = Math.min(innerBounds.height + 8, bounds.height - 8);
        Rectangle fullBounds = new Rectangle(0, 0, innerBounds.width + 8, height);
        LinkedList<Widget> innerWidgets = new LinkedList<Widget>(holder.widgets());
        fullBounds.move(bounds.getCenterX() - fullBounds.width / 2, bounds.y + 4);
        innerWidgets.add((Widget)Widgets.createLabel((Point)new Point(innerBounds.getCenterX(), 0), (Component)lootName).noShadow().color(-16777216).tooltip(new Component[]{fullText}));
        widgets.add((Widget)Widgets.createCategoryBase((Rectangle)fullBounds));
        if (bounds.height >= innerBounds.height + 8) {
            innerBounds.move(bounds.getCenterX() - innerBounds.width / 2, bounds.y + 8);
            widgets.add((Widget)Widgets.withTranslate((Widget)Widgets.concat(innerWidgets), (double)(bounds.getCenterX() - Math.round((float)innerBounds.width / 2.0f)), (double)(bounds.y + 8)));
        } else {
            Rectangle overflowBounds = new Rectangle(fullBounds.x + 4, fullBounds.y + 4, fullBounds.width - 8, fullBounds.height - 8);
            widgets.add((Widget)Widgets.overflowed((Rectangle)overflowBounds, (WidgetWithBounds)Widgets.concatWithBounds((Rectangle)innerBounds, innerWidgets)));
        }
        return widgets;
    }

    public CategoryIdentifier<ReiTradeDisplay> getCategoryIdentifier() {
        return this.identifier;
    }

    public Component getTitle() {
        return this.title;
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemStack)this.icon);
    }
}

