/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.Bees;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.component.DebugStickState;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.InstrumentComponent;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.component.OminousBottleAmplifier;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.saveddata.maps.MapId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class DataComponentTooltipUtils {
    public static @Unmodifiable @NotNull ITooltipNode getCustomDataTooltip(IServerUtils utils, CustomData value) {
        return GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.tag", value.copyTag().toString());
    }

    public static @Unmodifiable @NotNull ITooltipNode getIntTooltip(IServerUtils utils, int value) {
        return GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.value", value);
    }

    public static @Unmodifiable @NotNull ITooltipNode getCustomNameTooltip(IServerUtils utils, Component value) {
        return GenericTooltipUtils.getComponentTooltip(utils, "ali.property.value.custom_name", value);
    }

    public static @Unmodifiable @NotNull ITooltipNode getItemNameTooltip(IServerUtils utils, Component value) {
        return GenericTooltipUtils.getComponentTooltip(utils, "ali.property.value.item_name", value);
    }

    @NotNull
    public static ITooltipNode getItemLoreTooltip(IServerUtils utils, ItemLore value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.lines", "ali.property.value.null", value.lines(), GenericTooltipUtils::getComponentTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.styled_lines", "ali.property.value.null", value.styledLines(), GenericTooltipUtils::getComponentTooltip));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getRarityTooltip(IServerUtils utils, Rarity value) {
        return GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.rarity", value);
    }

    @NotNull
    public static ITooltipNode getItemEnchantmentsTooltip(IServerUtils utils, ItemEnchantments value) {
        return GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.enchantments", value.enchantments, GenericTooltipUtils::getEnchantmentLevelEntryTooltip);
    }

    @NotNull
    public static ITooltipNode getAdventureModePredicateTooltip(IServerUtils utils, AdventureModePredicate value) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.blocks", "ali.property.branch.predicate", value.predicates, GenericTooltipUtils::getBlockPredicateTooltip);
    }

    @NotNull
    public static ITooltipNode getAttributeModifiersTooltip(IServerUtils utils, ItemAttributeModifiers value) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.modifiers", "ali.property.branch.modifier", value.modifiers(), GenericTooltipUtils::getItemAttributeModifiersEntryTooltip);
    }

    public static @Unmodifiable @NotNull ITooltipNode getCustomModelDataTooltip(IServerUtils utils, CustomModelData value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.floats", value.floats().toString()));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.flags", value.flags().toString()));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.strings", value.strings().toString()));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.colors", value.colors().toString()));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getTooltipDisplayTooltip(IServerUtils utils, TooltipDisplay value) {
        TooltipNode components = new TooltipNode();
        components.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.hide_tooltip", value.hideTooltip()));
        components.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.hidden_components", "ali.property.value.null", value.hiddenComponents(), RegistriesTooltipUtils::getDataComponentTypeTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull ITooltipNode getEmptyTooltip(IServerUtils ignoredUtils, Unit ignoredValue) {
        return new TooltipNode();
    }

    public static @Unmodifiable @NotNull ITooltipNode getBoolTooltip(IServerUtils utils, boolean value) {
        return GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.value", value);
    }

    @NotNull
    public static ITooltipNode getFoodTooltip(IServerUtils utils, FoodProperties food) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.nutrition", food.nutrition()));
        tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.saturation", Float.valueOf(food.saturation())));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.can_always_eat", food.canAlwaysEat()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getConsumableTooltip(IServerUtils utils, Consumable consumable) {
        TooltipNode components = new TooltipNode();
        components.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.consume_seconds", Float.valueOf(consumable.consumeSeconds())));
        components.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.animation", consumable.animation()));
        components.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.sound", consumable.sound(), RegistriesTooltipUtils::getSoundEventTooltip));
        components.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.has_custom_particles", consumable.hasConsumeParticles()));
        components.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.on_consume_effects", consumable.onConsumeEffects(), utils::getConsumeEffectTooltip));
        return components;
    }

    @NotNull
    public static ITooltipNode getUseRemainderTooltip(IServerUtils utils, UseRemainder remainder) {
        return GenericTooltipUtils.getItemStackTooltip(utils, "ali.property.branch.convert_into", remainder.convertInto());
    }

    @NotNull
    public static ITooltipNode getUseCooldownTooltip(IServerUtils utils, UseCooldown cooldown) {
        TooltipNode components = new TooltipNode();
        components.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.seconds", Float.valueOf(cooldown.seconds())));
        components.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.cooldown_group", cooldown.cooldownGroup(), GenericTooltipUtils::getResourceLocationTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull ITooltipNode getDamageResistantTooltip(IServerUtils utils, DamageResistant resistant) {
        return GenericTooltipUtils.getTagKeyTooltip(utils, "ali.property.value.type", resistant.types());
    }

    @NotNull
    public static ITooltipNode getToolTooltip(IServerUtils utils, Tool tool) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.rules", "ali.property.branch.rule", tool.rules(), GenericTooltipUtils::getRuleTooltip));
        tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.default_mining_speed", Float.valueOf(tool.defaultMiningSpeed())));
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.damage_per_block", tool.damagePerBlock()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.can_destroy_blocks_in_creative", tool.canDestroyBlocksInCreative()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getWeaponTooltip(IServerUtils utils, Weapon weapon) {
        TooltipNode components = new TooltipNode();
        components.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.item_damage_per_attack", weapon.itemDamagePerAttack()));
        components.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.disable_blocking_for_seconds", Float.valueOf(weapon.disableBlockingForSeconds())));
        return components;
    }

    public static @Unmodifiable @NotNull ITooltipNode getEnchantableTooltip(IServerUtils utils, Enchantable enchantable) {
        return GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.value", enchantable.value());
    }

    public static @Unmodifiable @NotNull ITooltipNode getEquipableTooltip(IServerUtils utils, Equippable equippable) {
        TooltipNode components = new TooltipNode();
        components.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.equipment_slot", equippable.slot()));
        components.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.equip_sound", equippable.equipSound(), RegistriesTooltipUtils::getSoundEventTooltip));
        components.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.asset_id", equippable.assetId(), GenericTooltipUtils::getResourceKeyTooltip));
        components.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.camera_overlay", equippable.cameraOverlay(), GenericTooltipUtils::getResourceLocationTooltip));
        components.add(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, "ali.property.branch.allowed_entities", "ali.property.value.null", equippable.allowedEntities(), RegistriesTooltipUtils::getEntityTypeTooltip));
        components.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.dispensable", equippable.dispensable()));
        components.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.swappable", equippable.swappable()));
        components.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.damage_on_hurt", equippable.damageOnHurt()));
        components.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.equip_on_interact", equippable.equipOnInteract()));
        return components;
    }

    public static @Unmodifiable @NotNull ITooltipNode getRepairableTooltip(IServerUtils utils, Repairable repairable) {
        return GenericTooltipUtils.getHolderSetTooltip(utils, "ali.property.branch.items", "ali.property.value.null", repairable.items(), RegistriesTooltipUtils::getItemTooltip);
    }

    public static @Unmodifiable @NotNull ITooltipNode getDeathProtectionTooltip(IServerUtils utils, DeathProtection protection) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.death_effects", protection.deathEffects(), utils::getConsumeEffectTooltip);
    }

    public static @Unmodifiable @NotNull ITooltipNode getBlockAttacksTooltip(IServerUtils utils, BlocksAttacks value) {
        TooltipNode components = new TooltipNode();
        components.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.block_delay_seconds", Float.valueOf(value.blockDelaySeconds())));
        components.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.disable_cooldown_scale", Float.valueOf(value.disableCooldownScale())));
        components.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.damage_reductions", "ali.property.branch.damage_reduction", value.damageReductions(), GenericTooltipUtils::getDamageReductionTooltip));
        components.add(GenericTooltipUtils.getItemDamageTooltip(utils, "ali.property.branch.item_damage", value.itemDamage()));
        components.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.bypassed_by", value.bypassedBy(), GenericTooltipUtils::getTagKeyTooltip));
        components.add(GenericTooltipUtils.getOptionalHolderTooltip(utils, "ali.property.value.block_sound", value.blockSound(), RegistriesTooltipUtils::getSoundEventTooltip));
        components.add(GenericTooltipUtils.getOptionalHolderTooltip(utils, "ali.property.value.disable_sound", value.disableSound(), RegistriesTooltipUtils::getSoundEventTooltip));
        return components;
    }

    @NotNull
    public static ITooltipNode getDyedColorTooltip(IServerUtils utils, DyedItemColor value) {
        return GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.rgb", value.rgb());
    }

    public static @Unmodifiable @NotNull ITooltipNode getMapColorTooltip(IServerUtils utils, MapItemColor value) {
        return GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.rgb", value.rgb());
    }

    public static @Unmodifiable @NotNull ITooltipNode getMapIdTooltip(IServerUtils utils, MapId value) {
        return GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.value", value.id());
    }

    @NotNull
    public static ITooltipNode getMapDecorationsTooltip(IServerUtils utils, MapDecorations value) {
        return GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.decorations", value.decorations(), GenericTooltipUtils::getMapDecorationEntryTooltip);
    }

    public static @Unmodifiable @NotNull ITooltipNode getMapPostProcessingTooltip(IServerUtils utils, MapPostProcessing value) {
        return GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.value", value);
    }

    @NotNull
    public static ITooltipNode getChargedProjectilesTooltip(IServerUtils utils, ChargedProjectiles value) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.items", "ali.property.branch.item", value.getItems(), GenericTooltipUtils::getItemStackTooltip);
    }

    @NotNull
    public static ITooltipNode getBundleContentsTooltip(IServerUtils utils, BundleContents value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.items", "ali.property.branch.item", value.items, GenericTooltipUtils::getItemStackTooltip));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.fraction", value.weight().toString()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getPotionContentsTooltip(IServerUtils utils, PotionContents value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getOptionalHolderTooltip(utils, "ali.property.value.potion", value.potion(), RegistriesTooltipUtils::getPotionTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.custom_color", value.customColor(), GenericTooltipUtils::getIntegerTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.custom_effects", "ali.property.value.null", value.customEffects(), GenericTooltipUtils::getMobEffectInstanceTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.custom_name", value.customName(), GenericTooltipUtils::getStringTooltip));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getFloatValueTooltip(IServerUtils utils, float value) {
        return GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.value", Float.valueOf(value));
    }

    @NotNull
    public static ITooltipNode getSuspiciousStewEffectsTooltip(IServerUtils utils, SuspiciousStewEffects value) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.effects", value.effects(), GenericTooltipUtils::getSuspiciousStewEffectEntryTooltip);
    }

    @NotNull
    public static ITooltipNode getWritableBookContentTooltip(IServerUtils utils, WritableBookContent value) {
        return GenericTooltipUtils.getFilterableTooltip(utils, "ali.property.branch.pages", "ali.property.branch.page", value.pages(), GenericTooltipUtils::getStringTooltip);
    }

    @NotNull
    public static ITooltipNode getWrittenBookContentTooltip(IServerUtils utils, WrittenBookContent value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getFilterableTooltip(utils, "ali.property.branch.title", value.title(), GenericTooltipUtils::getStringTooltip));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.author", value.author()));
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.generation", value.generation()));
        tooltip.add(GenericTooltipUtils.getFilterableTooltip(utils, "ali.property.branch.pages", "ali.property.branch.page", value.pages(), GenericTooltipUtils::getComponentTooltip));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.resolved", value.resolved()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getTrimTooltip(IServerUtils utils, ArmorTrim value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(RegistriesTooltipUtils.getTrimMaterialTooltip(utils, "ali.property.value.material", (TrimMaterial)value.material().value()));
        tooltip.add(RegistriesTooltipUtils.getTrimPatternTooltip(utils, "ali.property.value.pattern", (TrimPattern)value.pattern().value()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getDebugStickStateTooltip(IServerUtils utils, DebugStickState value) {
        return GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.properties", value.properties(), GenericTooltipUtils::getBlockPropertyEntryTooltip);
    }

    public static @Unmodifiable @NotNull ITooltipNode getInstrumentTooltip(IServerUtils utils, InstrumentComponent value) {
        return GenericTooltipUtils.getEitherHolderTooltip(utils, "ali.property.value.value", value.instrument(), RegistriesTooltipUtils::getInstrumentTooltip);
    }

    public static @Unmodifiable @NotNull ITooltipNode getProvidesTrimMaterialTooltip(IServerUtils utils, ProvidesTrimMaterial value) {
        return GenericTooltipUtils.getEitherHolderTooltip(utils, "ali.property.value.material", value.material(), RegistriesTooltipUtils::getTrimMaterialTooltip);
    }

    public static @Unmodifiable @NotNull ITooltipNode getOminousBottleAmplifierTooltip(IServerUtils utils, OminousBottleAmplifier value) {
        return GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.value", value.value());
    }

    @NotNull
    public static ITooltipNode getJukeboxPlayableTooltip(IServerUtils utils, JukeboxPlayable value) {
        return GenericTooltipUtils.getEitherHolderTooltip(utils, "ali.property.value.song", value.song(), RegistriesTooltipUtils::getJukeboxSongTooltip);
    }

    public static @Unmodifiable @NotNull ITooltipNode getProvidesBannerPatternsTooltip(IServerUtils utils, TagKey<BannerPattern> value) {
        return GenericTooltipUtils.getTagKeyTooltip(utils, "ali.property.value.banner_pattern", value);
    }

    public static @Unmodifiable @NotNull ITooltipNode getRecipesTooltip(IServerUtils utils, List<ResourceKey<Recipe<?>>> value) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.recipes", "ali.property.value.null", value, GenericTooltipUtils::getResourceKeyTooltip);
    }

    @NotNull
    public static ITooltipNode getLodestoneTrackerTooltip(IServerUtils utils, LodestoneTracker value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.global_pos", value.target(), GenericTooltipUtils::getGlobalPosTooltip));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.tracked", value.tracked()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getFireworkExplosionTooltip(IServerUtils utils, FireworkExplosion value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.shape", value.shape()));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.colors", value.colors().toString()));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.fade_colors", value.fadeColors().toString()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.has_trail", value.hasTrail()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.has_twinkle", value.hasTwinkle()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getFireworksTooltip(IServerUtils utils, Fireworks value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.flight_duration", value.flightDuration()));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.explosions", "ali.property.branch.explosion", value.explosions(), GenericTooltipUtils::getFireworkExplosionTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getProfileTooltip(IServerUtils utils, ResolvableProfile value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.name", value.name(), GenericTooltipUtils::getStringTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.uuid", value.id(), GenericTooltipUtils::getUUIDTooltip));
        tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.properties", value.properties().asMap(), GenericTooltipUtils::getPropertiesEntryTooltip));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getResourceLocationTooltip(IServerUtils utils, ResourceLocation value) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.property.value.value", value);
    }

    public static @Unmodifiable @NotNull ITooltipNode getBannerPatternsTooltip(IServerUtils utils, BannerPatternLayers value) {
        return GenericTooltipUtils.getBannerPatternLayersTooltip(utils, "ali.property.branch.banner_patterns", value);
    }

    public static @Unmodifiable @NotNull ITooltipNode getDyeColorTooltip(IServerUtils utils, DyeColor value) {
        return GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.color", value);
    }

    @NotNull
    public static ITooltipNode getPotDecorationsTooltip(IServerUtils utils, PotDecorations value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.back", value.back(), RegistriesTooltipUtils::getItemTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.left", value.left(), RegistriesTooltipUtils::getItemTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.right", value.right(), RegistriesTooltipUtils::getItemTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.front", value.front(), RegistriesTooltipUtils::getItemTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getContainerTooltip(IServerUtils utils, ItemContainerContents value) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.items", "ali.property.branch.item", value.items, GenericTooltipUtils::getItemStackTooltip);
    }

    @NotNull
    public static ITooltipNode getBlockStateTooltip(IServerUtils ignoredUtils, BlockItemStateProperties properties) {
        return GenericTooltipUtils.getMapTooltip(ignoredUtils, "ali.property.branch.properties", properties.properties(), GenericTooltipUtils::getStringEntryTooltip);
    }

    @NotNull
    public static ITooltipNode getBeesTooltip(IServerUtils utils, Bees bees) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.bees", "ali.property.branch.occupant", bees.bees(), GenericTooltipUtils::getBeehiveBlockEntityOccupantTooltip);
    }

    public static @Unmodifiable @NotNull ITooltipNode getLockTooltip(IServerUtils utils, LockCode lockCode) {
        return GenericTooltipUtils.getItemPredicateTooltip(utils, "ali.property.branch.predicate", lockCode.predicate());
    }

    @NotNull
    public static ITooltipNode getContainerLootTooltip(IServerUtils utils, SeededContainerLoot value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getResourceKeyTooltip(utils, "ali.property.value.loot_table", value.lootTable()));
        tooltip.add(GenericTooltipUtils.getLongTooltip(utils, "ali.property.value.seed", value.seed()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getBreakSoundTooltip(IServerUtils utils, Holder<SoundEvent> soundEvent) {
        return GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.sound", soundEvent, RegistriesTooltipUtils::getSoundEventTooltip);
    }

    @NotNull
    public static ITooltipNode getVillagerVariantTooltip(IServerUtils utils, Holder<VillagerType> villager) {
        return GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.type", villager, RegistriesTooltipUtils::getVillagerTypeTooltip);
    }

    @NotNull
    public static ITooltipNode getWolfVariantTooltip(IServerUtils utils, Holder<WolfVariant> wolf) {
        return GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.type", wolf, RegistriesTooltipUtils::getWolfVariantTooltip);
    }

    @NotNull
    public static ITooltipNode getWolfSoundVariantTooltip(IServerUtils utils, Holder<WolfSoundVariant> wolfSound) {
        return GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.type", wolfSound, RegistriesTooltipUtils::getWolfSoundVariantTooltip);
    }

    public static @Unmodifiable @NotNull ITooltipNode getEnumTypeTooltip(IServerUtils utils, Enum<?> type) {
        return GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.type", type);
    }

    @NotNull
    public static ITooltipNode getPigVariantTooltip(IServerUtils utils, Holder<PigVariant> pigVariant) {
        return GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.type", pigVariant, RegistriesTooltipUtils::getPigVariantTooltip);
    }

    @NotNull
    public static ITooltipNode getCowVariantTooltip(IServerUtils utils, Holder<CowVariant> cowVariant) {
        return GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.type", cowVariant, RegistriesTooltipUtils::getCowVariantTooltip);
    }

    @NotNull
    public static ITooltipNode getChickenVariantTooltip(IServerUtils utils, EitherHolder<ChickenVariant> holder) {
        return GenericTooltipUtils.getEitherHolderTooltip(utils, "ali.property.value.type", holder, RegistriesTooltipUtils::getChickenVariantTooltip);
    }

    @NotNull
    public static ITooltipNode getFrogVariantTooltip(IServerUtils utils, Holder<FrogVariant> frogVariant) {
        return GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.type", frogVariant, RegistriesTooltipUtils::getFrogVariantTooltip);
    }

    @NotNull
    public static ITooltipNode getPaintingVariantTooltip(IServerUtils utils, Holder<PaintingVariant> paintingVariant) {
        return GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.type", paintingVariant, RegistriesTooltipUtils::getPaintingVariantTooltip);
    }

    @NotNull
    public static ITooltipNode getCatVariantTooltip(IServerUtils utils, Holder<CatVariant> catVariant) {
        return GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.type", catVariant, RegistriesTooltipUtils::getCatVariantTooltip);
    }
}

