/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.common;

import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.QuadConsumer;
import com.yanny.ali.compatibility.common.TriConsumer;
import com.yanny.ali.manager.AliClientRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GenericUtils {
    private static final ResourceLocation TEXTURE_LOC = Utils.modLoc("textures/gui/gui.png");
    private static final int WIDGET_SIZE = 36;
    private static final int DOTS_WIDTH = Minecraft.getInstance().font.width("...");

    public static void renderEntity(Entity entity, Rect bounds, int fullWidth, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            guiGraphics.pose().pushMatrix();
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE_LOC, bounds.x(), bounds.y(), 0.0f, 36.0f, bounds.width(), bounds.height(), 36, 36, 256, 256);
            EntityDimensions dimensions = entity.getType().getDimensions();
            GenericUtils.renderEntityInInventoryFollowsMouse(guiGraphics, bounds.x() + 1, bounds.y() + 1, bounds.right() - 1, bounds.bottom() - 1, (int)Math.min(20.0f / dimensions.height(), 20.0f / dimensions.width()), 0.0625f, mouseX, mouseY, livingEntity);
            guiGraphics.pose().popMatrix();
        }
    }

    @NotNull
    public static Component ellipsis(String text, String fallback, int maxWidth) {
        Font font = Minecraft.getInstance().font;
        text = Language.getInstance().getOrDefault(text, GenericUtils.getFallbackText(fallback));
        if (font.width(text) > maxWidth) {
            int index = 20;
            while (font.width(text.substring(0, index + 1) + DOTS_WIDTH) <= maxWidth) {
                ++index;
            }
            return Component.literal((String)(text.substring(0, index) + "..."));
        }
        return Component.literal((String)text);
    }

    public static void renderEntityInInventoryFollowsMouse(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int size, float scale, float mouseX, float mouseY, LivingEntity entity) {
        float hCenter = (float)(left + right) / 2.0f;
        float vCenter = (float)(top + bottom) / 2.0f;
        float xRotation = (float)Math.atan((hCenter - mouseX) / 40.0f);
        float yRotation = (float)Math.atan((vCenter - mouseY) / 40.0f);
        float yBodyRot = entity.yBodyRot;
        float entityYRot = entity.getYRot();
        float entityXRot = entity.getXRot();
        float yHeadRotO = entity.yHeadRotO;
        float yHeadRot = entity.yHeadRot;
        Quaternionf rotateZ = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf rotateX = new Quaternionf().rotateX(yRotation * 20.0f * ((float)Math.PI / 180));
        rotateZ.mul((Quaternionfc)rotateX);
        guiGraphics.enableScissor(left, top, right, bottom);
        entity.yBodyRot = 180.0f + xRotation * 20.0f;
        entity.setYRot(180.0f + xRotation * 40.0f);
        entity.setXRot(-yRotation * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        float entityScale = entity.getScale();
        Vector3f $$22 = new Vector3f(0.0f, entity.getBbHeight() / 2.0f + scale * entityScale, 0.0f);
        float $$23 = (float)size / entityScale;
        int x = (int)guiGraphics.pose().m20();
        int y = (int)guiGraphics.pose().m21();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (int)(left + x), (int)(top + y), (int)(right + x), (int)(bottom + y), (float)$$23, (Vector3f)$$22, (Quaternionf)rotateZ, (Quaternionf)rotateX, (LivingEntity)entity);
        entity.yBodyRot = yBodyRot;
        entity.setYRot(entityYRot);
        entity.setXRot(entityXRot);
        entity.yHeadRotO = yHeadRotO;
        entity.yHeadRot = yHeadRot;
        guiGraphics.disableScissor();
    }

    public static void processData(ClientLevel level, AliClientRegistry clientRegistry, Map<ResourceLocation, IDataNode> lootData, Map<ResourceLocation, IDataNode> tradeData, QuadConsumer<IDataNode, ResourceLocation, Block, List<ItemStack>> blockConsumer, QuadConsumer<IDataNode, ResourceLocation, EntityType<?>, List<ItemStack>> entityConsumer, TriConsumer<IDataNode, ResourceLocation, List<ItemStack>> gameplayConsumer, QuadConsumer<IDataNode, ResourceLocation, List<ItemStack>, List<ItemStack>> traderConsumer, QuadConsumer<IDataNode, ResourceLocation, List<ItemStack>, List<ItemStack>> wanderingTraderConsumer) {
        List<ItemStack> outputs;
        List<ItemStack> inputs;
        IDataNode tradeEntry;
        ResourceLocation location;
        for (Block block : BuiltInRegistries.BLOCK) {
            block.getLootTable().ifPresent(resourceKey -> {
                ResourceLocation location = resourceKey.location();
                IDataNode lootEntry = (IDataNode)lootData.get(location);
                if (lootEntry != null) {
                    List<ItemStack> outputs = clientRegistry.getLootItems(location);
                    blockConsumer.accept(lootEntry, location, block, outputs);
                    lootData.remove(location);
                }
            });
        }
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            List<Entity> list = clientRegistry.createEntities(entityType, (Level)level);
            for (Entity entity : list) {
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                mob.getLootTable().ifPresent(resourceKey -> {
                    List<ItemStack> outputs;
                    ResourceLocation location = resourceKey.location();
                    IDataNode lootEntry = (IDataNode)lootData.get(location);
                    if (lootEntry != null && (outputs = clientRegistry.getLootItems(location)) != null) {
                        entityConsumer.accept(lootEntry, location, entityType, outputs);
                    }
                    lootData.remove(location);
                });
            }
        }
        for (Map.Entry<ResourceLocation, IDataNode> entry : lootData.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            List<ItemStack> outputs2 = clientRegistry.getLootItems(resourceLocation);
            if (outputs2 == null) continue;
            gameplayConsumer.accept(entry.getValue(), entry.getKey(), outputs2);
        }
        lootData.clear();
        List<Map.Entry> entries = BuiltInRegistries.VILLAGER_PROFESSION.entrySet().stream().sorted(Comparator.comparing(a -> ((ResourceKey)a.getKey()).location().getPath())).toList();
        for (Map.Entry entry : entries) {
            location = ((ResourceKey)entry.getKey()).location();
            tradeEntry = tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = clientRegistry.getTradeInputItems(location).stream().map(Item::getDefaultInstance).toList();
            outputs = clientRegistry.getTradeOutputItems(location).stream().map(Item::getDefaultInstance).toList();
            traderConsumer.accept(tradeEntry, location, inputs, outputs);
            tradeData.remove(location);
        }
        for (Map.Entry entry : tradeData.entrySet()) {
            location = (ResourceLocation)entry.getKey();
            tradeEntry = tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = clientRegistry.getTradeInputItems(location).stream().map(Item::getDefaultInstance).toList();
            outputs = clientRegistry.getTradeOutputItems(location).stream().map(Item::getDefaultInstance).toList();
            wanderingTraderConsumer.accept(tradeEntry, location, inputs, outputs);
        }
        tradeData.clear();
    }

    private static String getFallbackText(String fallback) {
        List pathSegments = Pattern.compile("/").splitAsStream(fallback).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        Collections.reverse(pathSegments);
        return pathSegments.stream().flatMap(segment -> Arrays.stream(segment.split("_"))).filter(s -> !s.isEmpty()).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining(" "));
    }
}

