/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ClassKeyedMap<T> {
    private static final Class<?> NOT_FOUND_MARKER = Void.class;
    private final Map<Class<?>, T> exactMatchMap = new HashMap();
    private final Set<Class<?>> subTypeSupportedKeys = new HashSet();
    private final Map<Class<?>, Class<?>> closestKeyCache = new HashMap();

    public void put(Class<?> key, T value) {
        this.exactMatchMap.put(key, value);
        this.subTypeSupportedKeys.add(key);
    }

    @Nullable
    public T get(Class<?> requestedType) {
        if (this.exactMatchMap.containsKey(requestedType)) {
            return this.exactMatchMap.get(requestedType);
        }
        Class<?> closestKey = this.closestKeyCache.get(requestedType);
        if (closestKey != null) {
            if (closestKey == NOT_FOUND_MARKER) {
                return null;
            }
            return this.exactMatchMap.get(closestKey);
        }
        closestKey = this.findClosestSupertypeKey(requestedType);
        if (closestKey != null) {
            this.closestKeyCache.put(requestedType, closestKey);
            return this.exactMatchMap.get(closestKey);
        }
        this.closestKeyCache.put(requestedType, NOT_FOUND_MARKER);
        return null;
    }

    private Class<?> findClosestSupertypeKey(Class<?> requestedType) {
        for (Class<?> current = requestedType.getSuperclass(); current != null; current = current.getSuperclass()) {
            if (!this.subTypeSupportedKeys.contains(current)) continue;
            return current;
        }
        return this.findClosestInterfaceKey(requestedType, this.subTypeSupportedKeys);
    }

    @Nullable
    private Class<?> findClosestInterfaceKey(Class<?> clazz, Set<Class<?>> targetKeys) {
        for (Class<?> iface : clazz.getInterfaces()) {
            if (targetKeys.contains(iface)) {
                return iface;
            }
            Class<?> found = this.findClosestInterfaceKey(iface, targetKeys);
            if (found == null) continue;
            return found;
        }
        if (!clazz.isInterface() && clazz.getSuperclass() != null) {
            return this.findClosestInterfaceKey(clazz.getSuperclass(), targetKeys);
        }
        return null;
    }
}

