/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_85;

public class ItemNode
implements IDataNode,
IItemNode {
    public static final class_2960 ID = new class_2960("ali", "item");
    private final ITooltipNode tooltip;
    private final List<class_5341> conditions;
    private final List<class_117> functions;
    private final class_1799 itemStack;
    private final RangeValue count;
    private final float chance;

    public ItemNode(IServerUtils utils, class_77 entry, float chance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        this.conditions = Stream.concat(conditions.stream(), entry.field_988.stream()).toList();
        this.functions = Stream.concat(functions.stream(), entry.field_996.stream()).toList();
        this.chance = chance * (float)entry.field_995 / (float)sumWeight;
        this.itemStack = TooltipUtils.getItemStack(utils, ((class_1792)entry.field_987.comp_349()).method_7854(), this.functions);
        this.tooltip = EntryTooltipUtils.getSingletonTooltip(utils, (class_85)entry, chance, sumWeight, functions, conditions);
        this.count = TooltipUtils.getCount(utils, this.functions).get(null).get(0);
    }

    public ItemNode(IServerUtils utils, class_1792 item, RangeValue count) {
        this(utils, item, count, EmptyTooltipNode.EMPTY);
    }

    public ItemNode(IServerUtils ignoredUtils, class_1792 item, RangeValue count, ITooltipNode tooltip) {
        this.conditions = Collections.emptyList();
        this.functions = Collections.emptyList();
        this.chance = 1.0f;
        this.itemStack = item.method_7854();
        this.tooltip = tooltip;
        this.count = count;
    }

    public ItemNode(IClientUtils utils, class_2540 buf) {
        this.itemStack = buf.method_10819();
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
        this.count = new RangeValue(buf);
        this.chance = buf.readFloat();
        this.conditions = Collections.emptyList();
        this.functions = Collections.emptyList();
    }

    @Override
    public Either<class_1799, class_6862<? extends class_1935>> getModifiedItem() {
        return Either.left((Object)this.itemStack);
    }

    @Override
    public List<class_5341> getConditions() {
        return this.conditions;
    }

    @Override
    public List<class_117> getFunctions() {
        return this.functions;
    }

    @Override
    public RangeValue getCount() {
        return this.count;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public void encode(IServerUtils utils, class_2540 buf) {
        buf.method_10793(this.itemStack);
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
        this.count.encode(buf);
        buf.method_52941(this.chance);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }
}

