/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.emi;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.client.EntryTooltipUtils;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.Nullable;

public class EmiLootSlotWidget
extends SlotWidget {
    @Nullable
    private Component count;
    private boolean isRange = false;

    public EmiLootSlotWidget(IClientUtils utils, LootPoolEntryContainer entry, EmiIngredient ingredient, int x, int y, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        super(ingredient, x, y);
        EntryTooltipUtils.getTooltip(utils, entry, chance, count, functions, conditions).forEach(arg_0 -> ((EmiLootSlotWidget)this).appendTooltip(arg_0));
        this.setCount(count.get(null).get(0));
    }

    public void drawOverlay(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        if (this.count != null) {
            Font font = Minecraft.getInstance().font;
            PoseStack stack = draw.pose();
            stack.pushPose();
            if (this.isRange) {
                stack.translate((float)(this.x + 17), (float)(this.y + 13), 200.0f);
                stack.pushPose();
                stack.scale(0.5f, 0.5f, 0.5f);
                draw.drawString(font, this.count, -font.width((FormattedText)this.count), 0, 0xFFFFFF, false);
                stack.popPose();
            } else {
                stack.translate((float)(this.x + 18), (float)(this.y + 10), 200.0f);
                draw.drawString(font, this.count, -font.width((FormattedText)this.count), 0, 0xFFFFFF, true);
            }
            stack.popPose();
        }
        super.drawOverlay(draw, mouseX, mouseY, delta);
    }

    private void setCount(RangeValue count) {
        if (count.isRange() || count.min() > 1.0f) {
            this.count = Component.literal((String)count.toIntString());
            this.isRange = count.isRange();
        }
    }
}

