/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.yanny.ali.network.AbstractClient;
import com.yanny.ali.network.AbstractServer;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.Client;
import com.yanny.ali.network.DistHolder;
import com.yanny.ali.network.InfoSyncLootTableMessage;
import com.yanny.ali.network.Server;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public class NetworkUtils {
    public static DistHolder<AbstractClient, AbstractServer> registerLootInfoPropagator(PayloadRegistrar registrar) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return NetworkUtils.registerClientLootInfoPropagator(registrar);
        }
        return NetworkUtils.registerServerLootInfoPropagator(registrar);
    }

    @NotNull
    private static DistHolder<AbstractClient, AbstractServer> registerClientLootInfoPropagator(PayloadRegistrar registrar) {
        Client client = new Client();
        Server server = new Server();
        registrar.executesOn(HandlerThread.NETWORK).playToClient(InfoSyncLootTableMessage.TYPE, InfoSyncLootTableMessage.CODEC, client::onLootInfo);
        registrar.executesOn(HandlerThread.NETWORK).playToClient(ClearMessage.TYPE, ClearMessage.CODEC, client::onClear);
        return new DistHolder<AbstractClient, AbstractServer>(client, server);
    }

    @NotNull
    private static DistHolder<AbstractClient, AbstractServer> registerServerLootInfoPropagator(PayloadRegistrar registrar) {
        Server server = new Server();
        registrar.playToClient(InfoSyncLootTableMessage.TYPE, InfoSyncLootTableMessage.CODEC, (a, b) -> {});
        registrar.playToClient(ClearMessage.TYPE, ClearMessage.CODEC, (a, b) -> {});
        return new DistHolder<Object, Server>(null, server);
    }
}

