/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.client.GenericTooltipUtils;
import com.yanny.ali.plugin.client.TooltipUtils;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class EntryTooltipUtils {
    @NotNull
    public static List<Component> getLootTableTooltip(int pad, int quality, float chance) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.enum.group_type.all", new Object[0])));
        components.addAll(EntryTooltipUtils.getQualityTooltip(quality));
        components.addAll(EntryTooltipUtils.getChanceTooltip(EntryTooltipUtils.getBaseMap(chance)));
        return components;
    }

    @NotNull
    public static List<Component> getLootPoolTooltip(int pad, RangeValue rolls, RangeValue bonusRolls) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.enum.group_type.random", new Object[0])));
        components.add(EntryTooltipUtils.getRolls(rolls, bonusRolls));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getAlternativesTooltip(int pad) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.enum.group_type.alternatives", new Object[0])));
    }

    @NotNull
    public static List<Component> getDynamicTooltip(int pad, DynamicLoot entry, int sumWeight) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.enum.group_type.dynamic", new Object[0])));
        components.addAll(EntryTooltipUtils.getQualityTooltip(entry.quality));
        components.addAll(EntryTooltipUtils.getChanceTooltip(EntryTooltipUtils.getBaseMap((float)entry.weight / (float)sumWeight * 100.0f)));
        return components;
    }

    @NotNull
    public static List<Component> getEmptyTooltip(IClientUtils utils, EmptyLootItem entry, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        LinkedList<LootItemFunction> allFunctions = new LinkedList<LootItemFunction>(functions);
        LinkedList<LootItemCondition> allConditions = new LinkedList<LootItemCondition>(conditions);
        allFunctions.addAll(entry.functions);
        allConditions.addAll(entry.conditions);
        float rawChance = (float)entry.weight / (float)sumWeight;
        Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance = TooltipUtils.getChance(utils, allConditions, rawChance);
        return EntryTooltipUtils.getTooltip(utils, (LootPoolEntryContainer)entry, chance, EntryTooltipUtils.getBaseMap(1.0f), allFunctions, allConditions);
    }

    public static @Unmodifiable @NotNull List<Component> getGroupTooltip(int pad) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.enum.group_type.all", new Object[0])));
    }

    public static @Unmodifiable @NotNull List<Component> getSequentialTooltip(int pad) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.enum.group_type.sequence", new Object[0])));
    }

    @NotNull
    public static List<Component> getTooltip(IClientUtils utils, LootPoolEntryContainer entry, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (entry instanceof LootPoolSingletonContainer) {
            LootPoolSingletonContainer singletonEntry = (LootPoolSingletonContainer)entry;
            components.addAll(EntryTooltipUtils.getQualityTooltip(singletonEntry.quality));
        }
        components.addAll(EntryTooltipUtils.getChanceTooltip(chance));
        components.addAll(EntryTooltipUtils.getCountTooltip(count));
        if (!conditions.isEmpty()) {
            components.add(GenericTooltipUtils.translatable("ali.util.advanced_loot_info.delimiter.conditions", new Object[0]));
            components.addAll(GenericTooltipUtils.getConditionsTooltip(utils, 0, conditions));
        }
        if (!functions.isEmpty()) {
            components.add(GenericTooltipUtils.translatable("ali.util.advanced_loot_info.delimiter.functions", new Object[0]));
            components.addAll(GenericTooltipUtils.getFunctionsTooltip(utils, 0, functions));
        }
        return components;
    }

    @NotNull
    public static @Unmodifiable List<Component> getQualityTooltip(int quality) {
        if (quality != 0) {
            return List.of(GenericTooltipUtils.translatable("ali.description.quality", GenericTooltipUtils.value(quality)));
        }
        return List.of();
    }

    @NotNull
    public static List<Component> getChanceTooltip(Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.translatable("ali.description.chance", GenericTooltipUtils.value(chance.get(null).get(0), "%")));
        for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> chanceEntry : chance.entrySet()) {
            Holder<Enchantment> enchantment = chanceEntry.getKey();
            Map<Integer, RangeValue> levelMap = chanceEntry.getValue();
            if (enchantment == null) continue;
            for (Map.Entry<Integer, RangeValue> levelEntry : levelMap.entrySet()) {
                int level = levelEntry.getKey();
                RangeValue value = levelEntry.getValue();
                components.add(GenericTooltipUtils.pad(1, GenericTooltipUtils.translatable("ali.description.chance_bonus", GenericTooltipUtils.value(value, "%"), Component.translatable((String)((Enchantment)enchantment.value()).getDescriptionId()), Component.translatable((String)("enchantment.level." + level)))));
            }
        }
        return components;
    }

    @NotNull
    public static List<Component> getCountTooltip(Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.translatable("ali.description.count", GenericTooltipUtils.value(count.get(null).get(0))));
        for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> chanceEntry : count.entrySet()) {
            Holder<Enchantment> enchantment = chanceEntry.getKey();
            Map<Integer, RangeValue> levelMap = chanceEntry.getValue();
            if (enchantment == null) continue;
            for (Map.Entry<Integer, RangeValue> levelEntry : levelMap.entrySet()) {
                int level = levelEntry.getKey();
                RangeValue value = levelEntry.getValue();
                components.add(GenericTooltipUtils.pad(1, GenericTooltipUtils.translatable("ali.description.count_bonus", GenericTooltipUtils.value(value), Component.translatable((String)((Enchantment)enchantment.value()).getDescriptionId()), Component.translatable((String)("enchantment.level." + level)))));
            }
        }
        return components;
    }

    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getBaseMap(float value) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> map = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        map.put(null, Map.of(0, new RangeValue(value)));
        return map;
    }

    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getBaseMap(float min, float max) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> map = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        map.put(null, Map.of(0, new RangeValue(min, max)));
        return map;
    }

    @NotNull
    private static Component getRolls(RangeValue rolls, RangeValue bonusRolls) {
        return GenericTooltipUtils.translatable("ali.description.rolls", GenericTooltipUtils.value(EntryTooltipUtils.getTotalRolls(rolls, bonusRolls).toIntString(), "x"));
    }

    private static RangeValue getTotalRolls(RangeValue rolls, RangeValue bonusRolls) {
        if (bonusRolls.min() > 0.0f || bonusRolls.max() > 0.0f) {
            return new RangeValue(bonusRolls).add(rolls);
        }
        return rolls;
    }
}

