/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.RangeValue;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.CollectionPredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.ItemAttributeModifiersPredicate;
import net.minecraft.advancements.critereon.ItemFireworkExplosionPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemWritableBookPredicate;
import net.minecraft.advancements.critereon.ItemWrittenBookPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.Filterable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.storage.loot.ContainerComponentManipulator;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyCustomDataFunction;
import net.minecraft.world.level.storage.loot.functions.ListOperation;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class GenericTooltipUtils {
    private static final ChatFormatting TEXT_STYLE = ChatFormatting.GOLD;
    private static final ChatFormatting PARAM_STYLE = ChatFormatting.AQUA;

    @NotNull
    public static List<Component> getConditionsTooltip(IClientUtils utils, int pad, List<LootItemCondition> conditions) {
        return conditions.stream().map(condition -> utils.getConditionTooltip(utils, pad, condition)).flatMap(Collection::stream).toList();
    }

    @NotNull
    public static List<Component> getFunctionsTooltip(IClientUtils utils, int pad, List<LootItemFunction> functions) {
        return functions.stream().map(function -> {
            LinkedList<Component> components = new LinkedList<Component>(utils.getFunctionTooltip(utils, pad, function));
            if (function instanceof LootItemConditionalFunction) {
                LootItemConditionalFunction conditionalFunction = (LootItemConditionalFunction)function;
                if (!conditionalFunction.predicates.isEmpty()) {
                    components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.translatable("ali.property.branch.conditions", new Object[0])));
                    components.addAll(GenericTooltipUtils.getConditionsTooltip(utils, pad + 2, conditionalFunction.predicates));
                }
            }
            return components;
        }).flatMap(Collection::stream).toList();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<Component> getFormulaTooltip(IClientUtils utils, int pad, ApplyBonusCount.Formula formula) {
        LinkedList<Component> components = new LinkedList<Component>(GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.formula", formula.getType().id()));
        if (formula instanceof ApplyBonusCount.BinomialWithBonusCount) {
            float probability;
            ApplyBonusCount.BinomialWithBonusCount binomialWithBonusCount = (ApplyBonusCount.BinomialWithBonusCount)formula;
            try {
                float f;
                int n;
                int extraRounds = n = binomialWithBonusCount.extraRounds();
                probability = f = binomialWithBonusCount.probability();
                components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad + 1, "ali.property.value.extra_rounds", extraRounds));
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            components.addAll(GenericTooltipUtils.getFloatTooltip(utils, pad + 1, "ali.property.value.probability", Float.valueOf(probability)));
            return components;
        }
        if (!(formula instanceof ApplyBonusCount.UniformBonusCount)) return components;
        ApplyBonusCount.UniformBonusCount uniformBonusCount = (ApplyBonusCount.UniformBonusCount)formula;
        {
            int n;
            int bonusMultiplier = n = uniformBonusCount.bonusMultiplier();
            components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad + 1, "ali.property.value.bonus_multiplier", bonusMultiplier));
        }
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getBlockTooltip(IClientUtils ignoredUtils, int pad, Block block) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.block", GenericTooltipUtils.value(GenericTooltipUtils.translatable(block.getDescriptionId(), new Object[0])))));
    }

    public static @Unmodifiable @NotNull List<Component> getPropertyTooltip(IClientUtils ignoredUtils, int pad, Property<?> property) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.pair(property.getName(), property.getPossibleValues().toString()))));
    }

    public static @Unmodifiable @NotNull List<Component> getEnchantmentTooltip(IClientUtils utils, int pad, Enchantment enchantment) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.enchantment", GenericTooltipUtils.value(GenericTooltipUtils.translatable(enchantment.getDescriptionId(), new Object[0])))));
    }

    @NotNull
    public static List<Component> getModifierTooltip(IClientUtils utils, int pad, SetAttributesFunction.Modifier modifier) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.modifier", new Object[0])));
        components.addAll(GenericTooltipUtils.getStringTooltip(utils, pad + 1, "ali.property.value.name", modifier.name()));
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, modifier.attribute(), GenericTooltipUtils::getAttributeTooltip));
        components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad + 1, "ali.property.value.operation", modifier.operation()));
        components.addAll(GenericTooltipUtils.getNumberProviderTooltip(utils, pad + 1, "ali.property.value.amount", modifier.amount()));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, modifier.id(), GenericTooltipUtils::getUUIDTooltip));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad + 1, "ali.property.branch.equipment_slots", modifier.slots(), GenericTooltipUtils::getEnumTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getAttributeTooltip(IClientUtils ignoredUtils, int pad, Attribute attribute) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.attribute", GenericTooltipUtils.value(GenericTooltipUtils.translatable(attribute.getDescriptionId(), new Object[0])))));
    }

    public static @Unmodifiable @NotNull List<Component> getUUIDTooltip(IClientUtils utils, int pad, UUID uuid) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.uuid", GenericTooltipUtils.value(uuid))));
    }

    @NotNull
    public static List<Component> getBannerPatternLayersTooltip(IClientUtils utils, int pad, BannerPatternLayers bannerPatternLayers) {
        return GenericTooltipUtils.getCollectionTooltip(utils, pad, "ali.property.branch.banner_patterns", bannerPatternLayers.layers(), GenericTooltipUtils::getBannerPatternLayerTooltip);
    }

    @NotNull
    public static List<Component> getBannerPatternLayerTooltip(IClientUtils utils, int pad, BannerPatternLayers.Layer layer) {
        return GenericTooltipUtils.getHolderTooltip(utils, pad, layer.pattern(), (u, p, b) -> GenericTooltipUtils.getBannerPatternTooltip(u, p, b, layer.color()));
    }

    public static @Unmodifiable @NotNull List<Component> getBannerPatternTooltip(IClientUtils ignoredUtils, int pad, BannerPattern bannerPattern, DyeColor color) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.banner_pattern", GenericTooltipUtils.value(GenericTooltipUtils.translatable(bannerPattern.translationKey() + "." + color.getName(), new Object[0])))));
    }

    public static @Unmodifiable @NotNull List<Component> getBlockEntityTypeTooltip(IClientUtils ignoredUtils, int pad, BlockEntityType<?> blockEntityType) {
        ResourceLocation location = ((ResourceKey)Objects.requireNonNull(blockEntityType.builtInRegistryHolder()).unwrapKey().orElseThrow()).location();
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.block_entity_type", GenericTooltipUtils.value(location))));
    }

    @NotNull
    public static List<Component> getPotionTooltip(IClientUtils utils, int pad, Potion potion) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.potion", Objects.requireNonNull(BuiltInRegistries.POTION.getKey((Object)potion)));
    }

    public static @Unmodifiable @NotNull List<Component> getMobEffectTooltip(IClientUtils utils, int pad, MobEffect mobEffect) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.mob_effect", GenericTooltipUtils.value(Objects.requireNonNull(BuiltInRegistries.MOB_EFFECT.getKey((Object)mobEffect))))));
    }

    @NotNull
    public static List<Component> getStatePropertiesPredicateTooltip(IClientUtils utils, int pad, StatePropertiesPredicate propertiesPredicate) {
        return GenericTooltipUtils.getCollectionTooltip(utils, pad, "ali.property.branch.state_properties_predicate", propertiesPredicate.properties(), GenericTooltipUtils::getPropertyMatcherTooltip);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static List<Component> getPropertyMatcherTooltip(IClientUtils utils, int pad, StatePropertiesPredicate.PropertyMatcher propertyMatcher) {
        Optional maxValue;
        String name;
        LinkedList<Component> components;
        block7: {
            Optional minValue;
            block8: {
                Optional optional;
                Object object;
                StatePropertiesPredicate.ExactMatcher exactMatcher;
                components = new LinkedList<Component>();
                name = propertyMatcher.name();
                StatePropertiesPredicate.ValueMatcher valueMatcher = propertyMatcher.valueMatcher();
                if (valueMatcher instanceof StatePropertiesPredicate.ExactMatcher) {
                    exactMatcher = (StatePropertiesPredicate.ExactMatcher)valueMatcher;
                    Object value = object = exactMatcher.value();
                    components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.keyValue(name, value)));
                }
                if (!((object = propertyMatcher.valueMatcher()) instanceof StatePropertiesPredicate.RangedMatcher)) return components;
                exactMatcher = (StatePropertiesPredicate.RangedMatcher)object;
                try {
                    minValue = optional = exactMatcher.minValue();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                maxValue = optional = exactMatcher.maxValue();
                if (!minValue.isPresent()) break block7;
                if (!maxValue.isPresent()) break block8;
                components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_both", name, minValue.get(), maxValue.get()))));
                return components;
            }
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_gte", name, minValue.get()))));
            return components;
        }
        if (maxValue.isPresent()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_lte", name, maxValue.get()))));
            return components;
        } else {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_any", name))));
        }
        return components;
    }

    @NotNull
    public static List<Component> getDamageSourcePredicateTooltip(IClientUtils utils, int pad, DamageSourcePredicate damagePredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.damage_source_predicate", new Object[0])));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad + 1, "ali.property.branch.tag_predicates", damagePredicate.tags(), GenericTooltipUtils::getTagPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.direct_entity", damagePredicate.directEntity(), GenericTooltipUtils::getEntityPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.source_entity", damagePredicate.sourceEntity(), GenericTooltipUtils::getEntityPredicateTooltip));
        return components;
    }

    public static <T> @Unmodifiable @NotNull List<Component> getTagPredicateTooltip(IClientUtils utils, int pad, TagPredicate<T> tagPredicate) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.keyValue(tagPredicate.tag().location(), tagPredicate.expected())));
    }

    @NotNull
    public static List<Component> getEntityPredicateTooltip(IClientUtils utils, int pad, EntityPredicate entityPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.entityType(), GenericTooltipUtils::getEntityTypePredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.distance_to_player", entityPredicate.distanceToPlayer(), GenericTooltipUtils::getDistancePredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.location", entityPredicate.location(), GenericTooltipUtils::getLocationPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.stepping_on_location", entityPredicate.steppingOnLocation(), GenericTooltipUtils::getLocationPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.effects(), GenericTooltipUtils::getMobEffectPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.nbt(), GenericTooltipUtils::getNbtPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.flags(), GenericTooltipUtils::getEntityFlagsPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.equipment(), GenericTooltipUtils::getEntityEquipmentPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.entity_sub_predicate", entityPredicate.subPredicate(), utils::getEntitySubPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.vehicle", entityPredicate.vehicle(), GenericTooltipUtils::getEntityPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.passenger", entityPredicate.passenger(), GenericTooltipUtils::getEntityPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.targeted_entity", entityPredicate.targetedEntity(), GenericTooltipUtils::getEntityPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.team", entityPredicate.team(), GenericTooltipUtils::getStringTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getEntityTypePredicateTooltip(IClientUtils utils, int pad, EntityTypePredicate entityTypePredicate) {
        return GenericTooltipUtils.getHolderSetTooltip(utils, pad, "ali.property.branch.entity_types", entityTypePredicate.types(), GenericTooltipUtils::getEntityTypeTooltip);
    }

    public static @Unmodifiable @NotNull List<Component> getEntityTypeTooltip(IClientUtils utils, int pad, EntityType<?> entityType) {
        return GenericTooltipUtils.getComponentTooltip(utils, pad, "ali.property.value.entity_type", GenericTooltipUtils.value(GenericTooltipUtils.translatable(entityType.getDescriptionId(), new Object[0])));
    }

    @NotNull
    public static List<Component> getDistancePredicateTooltip(IClientUtils utils, int pad, DistancePredicate distancePredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.x", distancePredicate.x()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.y", distancePredicate.y()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.z", distancePredicate.z()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.horizontal", distancePredicate.horizontal()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.absolute", distancePredicate.absolute()));
        return components;
    }

    @NotNull
    public static List<Component> getLocationPredicateTooltip(IClientUtils utils, int pad, LocationPredicate locationPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, locationPredicate.position(), GenericTooltipUtils::getPositionPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.branch.biomes", locationPredicate.biomes(), (u, p, s, h) -> GenericTooltipUtils.getHolderSetTooltip(u, (int)p, s, h, "ali.property.value.biome")));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.branch.structures", locationPredicate.structures(), (u, p, s, h) -> GenericTooltipUtils.getHolderSetTooltip(u, (int)p, s, h, "ali.property.value.structure")));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.dimension", locationPredicate.dimension(), GenericTooltipUtils::getResourceKeyTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.smokey", locationPredicate.smokey(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, locationPredicate.light(), GenericTooltipUtils::getLightPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, locationPredicate.block(), GenericTooltipUtils::getBlockPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, locationPredicate.fluid(), GenericTooltipUtils::getFluidPredicateTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getPositionPredicateTooltip(IClientUtils utils, int pad, LocationPredicate.PositionPredicate positionPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.position", new Object[0])));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.x", positionPredicate.x()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.y", positionPredicate.y()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.z", positionPredicate.z()));
        return components;
    }

    @NotNull
    public static List<Component> getLightPredicateTooltip(IClientUtils utils, int pad, LightPredicate lightPredicate) {
        return GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.light", lightPredicate.composite());
    }

    @NotNull
    public static List<Component> getBlockPredicateTooltip(IClientUtils utils, int pad, BlockPredicate blockPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.block_predicate", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, pad + 1, "ali.property.branch.blocks", blockPredicate.blocks(), GenericTooltipUtils::getBlockTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, blockPredicate.properties(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, blockPredicate.nbt(), GenericTooltipUtils::getNbtPredicateTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getNbtPredicateTooltip(IClientUtils utils, int pad, NbtPredicate nbtPredicate) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.nbt", GenericTooltipUtils.value(nbtPredicate.tag()))));
    }

    @NotNull
    public static List<Component> getFluidPredicateTooltip(IClientUtils utils, int pad, FluidPredicate fluidPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.fluid_predicate", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, pad + 1, "ali.property.branch.fluids", fluidPredicate.fluids(), GenericTooltipUtils::getFluidTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, fluidPredicate.properties(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getFluidTooltip(IClientUtils utils, int pad, Fluid fluid) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.fluid", BuiltInRegistries.FLUID.getKey((Object)fluid));
    }

    @NotNull
    public static List<Component> getMobEffectPredicateTooltip(IClientUtils utils, int pad, MobEffectsPredicate mobEffectsPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.mob_effects", new Object[0])));
        mobEffectsPredicate.effectMap().forEach((effect, instancePredicate) -> {
            components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, effect, GenericTooltipUtils::getMobEffectTooltip));
            components.addAll(GenericTooltipUtils.getMobEffectInstancePredicateTooltip(utils, pad + 2, instancePredicate));
        });
        return components;
    }

    @NotNull
    public static List<Component> getMobEffectInstancePredicateTooltip(IClientUtils utils, int pad, MobEffectsPredicate.MobEffectInstancePredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.amplifier", predicate.amplifier()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.duration", predicate.duration()));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.is_ambient", predicate.ambient(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.is_visible", predicate.visible(), GenericTooltipUtils::getBooleanTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getEntityFlagsPredicateTooltip(IClientUtils utils, int pad, EntityFlagsPredicate entityFlagsPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.entity_flags", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_on_fire", entityFlagsPredicate.isOnFire(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_baby", entityFlagsPredicate.isBaby(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_crouching", entityFlagsPredicate.isCrouching(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_sprinting", entityFlagsPredicate.isSprinting(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_swimming", entityFlagsPredicate.isSwimming(), GenericTooltipUtils::getBooleanTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getEntityEquipmentPredicateTooltip(IClientUtils utils, int pad, EntityEquipmentPredicate entityEquipmentPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.entity_equipment", new Object[0])));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.head", entityEquipmentPredicate.head(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.chest", entityEquipmentPredicate.chest(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.legs", entityEquipmentPredicate.legs(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.feet", entityEquipmentPredicate.feet(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.mainhand", entityEquipmentPredicate.mainhand(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.offhand", entityEquipmentPredicate.offhand(), GenericTooltipUtils::getItemPredicateTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getItemPredicateTooltip(IClientUtils utils, int pad, ItemPredicate itemPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, pad, "ali.property.branch.items", itemPredicate.items(), GenericTooltipUtils::getItemTooltip));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.count", itemPredicate.count()));
        components.addAll(GenericTooltipUtils.getDataComponentPredicateTooltip(utils, pad, itemPredicate.components()));
        if (!itemPredicate.subPredicates().isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.item_predicates", new Object[0])));
            itemPredicate.subPredicates().forEach((type, predicate) -> components.addAll(utils.getItemSubPredicateTooltip(utils, pad + 1, (ItemSubPredicate.Type<?>)type, predicate)));
        }
        return components;
    }

    @NotNull
    public static List<Component> getEnchantmentPredicateTooltip(IClientUtils utils, int pad, EnchantmentPredicate enchantmentPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalHolderTooltip(utils, pad, enchantmentPredicate.enchantment(), GenericTooltipUtils::getEnchantmentTooltip));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.level", enchantmentPredicate.level()));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getItemTooltip(IClientUtils utils, int pad, Item item) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.item", GenericTooltipUtils.value(GenericTooltipUtils.translatable(item.getDescriptionId(), new Object[0])))));
    }

    public static @Unmodifiable @NotNull List<Component> getGameTypeTooltip(IClientUtils ignoredUtils, int pad, GameType gameType) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.game_type", gameType.getShortDisplayName()))));
    }

    @NotNull
    public static List<Component> getStatMatcherTooltip(IClientUtils utils, int pad, PlayerPredicate.StatMatcher<?> stat) {
        LinkedList<Component> components = new LinkedList<Component>();
        Holder value = stat.value();
        Object object = value.value();
        if (object instanceof Item) {
            Item item = (Item)object;
            components.addAll(GenericTooltipUtils.getItemTooltip(utils, pad, item));
        } else {
            object = value.value();
            if (object instanceof Block) {
                Block block = (Block)object;
                components.addAll(GenericTooltipUtils.getBlockTooltip(utils, pad, block));
            } else {
                components.add(GenericTooltipUtils.pad(pad, value.value().toString()));
            }
        }
        components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.keyValue(stat.type().getDisplayName(), GenericTooltipUtils.toString(stat.range()))));
        return components;
    }

    @NotNull
    public static List<Component> getRecipesTooltip(IClientUtils ignoredUtils, int pad, Object2BooleanMap<ResourceLocation> recipes) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (!recipes.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.recipes", new Object[0])));
            recipes.forEach((recipe, required) -> components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.keyValue(recipe.toString(), required))));
        }
        return components;
    }

    @NotNull
    public static List<Component> getAdvancementsTooltip(IClientUtils ignoredUtils, int pad, Map<ResourceLocation, PlayerPredicate.AdvancementPredicate> predicateMap) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (!predicateMap.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.advancements", new Object[0])));
            predicateMap.forEach((advancement, predicate) -> {
                Object2BooleanMap criterions;
                components.add(GenericTooltipUtils.pad(pad + 1, advancement.toString()));
                if (predicate instanceof PlayerPredicate.AdvancementDonePredicate) {
                    boolean state2;
                    PlayerPredicate.AdvancementDonePredicate $b$0 = (PlayerPredicate.AdvancementDonePredicate)predicate;
                    try {
                        boolean patt1$temp;
                        state2 = patt1$temp = $b$0.state();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    components.add(GenericTooltipUtils.pad(pad + 2, GenericTooltipUtils.translatable("ali.property.value.done", state2)));
                    return;
                }
                if (!(predicate instanceof PlayerPredicate.AdvancementCriterionsPredicate)) return;
                PlayerPredicate.AdvancementCriterionsPredicate $b$2 = (PlayerPredicate.AdvancementCriterionsPredicate)predicate;
                {
                    Object2BooleanMap patt3$temp;
                    criterions = patt3$temp = $b$2.criterions();
                }
                criterions.forEach((criterion, state) -> components.add(GenericTooltipUtils.pad(pad + 2, GenericTooltipUtils.keyValue(criterion, state))));
            });
        }
        return components;
    }

    @NotNull
    public static List<Component> getBlockPosTooltip(IClientUtils utils, int pad, BlockPos pos) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad, "ali.property.value.x", pos.getX()));
        components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad, "ali.property.value.y", pos.getY()));
        components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad, "ali.property.value.z", pos.getZ()));
        return components;
    }

    @NotNull
    public static List<Component> getMapDecorationTypeTooltip(IClientUtils utils, int pad, MapDecorationType decorationType) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.asset_id", decorationType.assetId()));
        components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad, "ali.property.value.color", decorationType.mapColor()));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad, "ali.property.value.show_on_item_frame", decorationType.showOnItemFrame()));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad, "ali.property.value.exploration_map_element", decorationType.explorationMapElement()));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad, "ali.property.value.track_count", decorationType.trackCount()));
        return components;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<Component> getListOperationTooltip(IClientUtils utils, int pad, ListOperation operation) {
        Optional size;
        LinkedList<Component> components = new LinkedList<Component>(GenericTooltipUtils.getEnumTooltip(utils, pad, "ali.property.value.list_operation", operation.mode()));
        if (operation instanceof ListOperation.Insert) {
            ListOperation.Insert insert = (ListOperation.Insert)operation;
            try {
                int n;
                int offset = n = insert.offset();
                components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad + 1, "ali.property.value.offset", offset));
                return components;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (!(operation instanceof ListOperation.ReplaceSection)) return components;
        ListOperation.ReplaceSection replaceSection = (ListOperation.ReplaceSection)operation;
        {
            Optional optional;
            int n;
            int offset = n = replaceSection.offset();
            size = optional = replaceSection.size();
            components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad + 1, "ali.property.value.offset", offset));
        }
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.size", size, GenericTooltipUtils::getIntegerTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getContainerComponentManipulatorTooltip(IClientUtils utils, int pad, ContainerComponentManipulator<?> component) {
        return GenericTooltipUtils.getDataComponentTypeTooltip(utils, pad, component.type());
    }

    @NotNull
    public static List<Component> getCopyOperationTooltip(IClientUtils utils, int pad, CopyCustomDataFunction.CopyOperation copyOperation) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getNbtPathTooltip(utils, pad, "ali.property.value.source_path", copyOperation.sourcePath()));
        components.addAll(GenericTooltipUtils.getNbtPathTooltip(utils, pad, "ali.property.value.target_path", copyOperation.targetPath()));
        components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad, "ali.property.value.merge_strategy", copyOperation.op()));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getNbtPathTooltip(IClientUtils utils, int pad, String key, NbtPathArgument.NbtPath provider) {
        return GenericTooltipUtils.getStringTooltip(utils, pad, key, provider.asString());
    }

    @NotNull
    public static List<Component> getDataComponentPredicateTooltip(IClientUtils utils, int pad, DataComponentPredicate dataComponentPredicate) {
        if (dataComponentPredicate != DataComponentPredicate.EMPTY) {
            return GenericTooltipUtils.getCollectionTooltip(utils, pad, "ali.property.branch.component_predicates", dataComponentPredicate.expectedComponents, GenericTooltipUtils::getTypedDataComponentTooltip);
        }
        return List.of();
    }

    public static @Unmodifiable @NotNull List<Component> getTypedDataComponentTooltip(IClientUtils utils, int pad, TypedDataComponent<?> typedDataComponent) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.component", GenericTooltipUtils.keyValue(typedDataComponent.type().toString(), typedDataComponent.value()))));
    }

    @NotNull
    public static <A, B extends Predicate<A>> List<Component> getCollectionPredicateTooltip(IClientUtils utils, int pad, String key, CollectionPredicate<A, B> predicate, TriFunction<IClientUtils, Integer, B, List<Component>> subPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.branch.contains", predicate.contains(), (u, i, s, c) -> GenericTooltipUtils.getCollectionTooltip(u, (int)i, s, c.unpack(), subPredicate)));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.branch.counts", predicate.counts(), (u, i, s, c) -> GenericTooltipUtils.getCollectionTooltip(u, (int)i, s, c.unpack(), (u1, i1, s1) -> {
            LinkedList<Component> comps = new LinkedList<Component>();
            comps.addAll((Collection)subPredicate.apply(u1, i1, (Object)s1.test()));
            comps.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(u1, (int)i1, "ali.property.value.count", s1.count()));
            return comps;
        })));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.size", predicate.size(), GenericTooltipUtils::getMinMaxBoundsTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getFireworkPredicateTooltip(IClientUtils utils, int pad, ItemFireworkExplosionPredicate.FireworkPredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.shape", predicate.shape(), GenericTooltipUtils::getEnumTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.trail", predicate.trail(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.twinkle", predicate.twinkle(), GenericTooltipUtils::getBooleanTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getPagePredicateTooltip(IClientUtils ignoredUtils, int pad, ItemWritableBookPredicate.PagePredicate predicate) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.page", GenericTooltipUtils.value(predicate.contents()))));
    }

    public static @Unmodifiable @NotNull List<Component> getPagePredicateTooltip(IClientUtils ignoredUtils, int pad, ItemWrittenBookPredicate.PagePredicate predicate) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.page", GenericTooltipUtils.value(predicate.contents()))));
    }

    @NotNull
    public static List<Component> getEntryPredicateTooltip(IClientUtils utils, int pad, ItemAttributeModifiersPredicate.EntryPredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, pad, "ali.property.branch.attributes", predicate.attribute(), GenericTooltipUtils::getAttributeTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, predicate.id(), GenericTooltipUtils::getUUIDTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.name", predicate.name(), GenericTooltipUtils::getStringTooltip));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.amount", predicate.amount()));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.operation", predicate.operation(), GenericTooltipUtils::getEnumTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.slot", predicate.slot(), GenericTooltipUtils::getEnumTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getTrimMaterialTooltip(IClientUtils utils, int pad, TrimMaterial material) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getStringTooltip(utils, pad, "ali.property.value.asset_name", material.assetName()));
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad, material.ingredient(), GenericTooltipUtils::getItemTooltip));
        components.addAll(GenericTooltipUtils.getFloatTooltip(utils, pad, "ali.property.value.model_index", Float.valueOf(material.itemModelIndex())));
        components.addAll(GenericTooltipUtils.getComponentTooltip(utils, pad, "ali.property.value.description", material.description()));
        return components;
    }

    @NotNull
    public static List<Component> getTrimPatternTooltip(IClientUtils utils, int pad, TrimPattern material) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.asset_id", material.assetId()));
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad, material.templateItem(), GenericTooltipUtils::getItemTooltip));
        components.addAll(GenericTooltipUtils.getComponentTooltip(utils, pad, "ali.property.value.description", material.description()));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad, "ali.property.value.decal", material.decal()));
        return components;
    }

    @NotNull
    public static List<Component> getDataComponentPatchTooltip(IClientUtils utils, int pad, DataComponentPatch data) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (!data.map.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.components", new Object[0])));
            data.map.forEach((type, value) -> components.addAll(GenericTooltipUtils.getDataComponentTypeTooltip(utils, pad + 1, type)));
        }
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getDataComponentTypeTooltip(IClientUtils utils, int pad, DataComponentType<?> data) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.type", Objects.requireNonNull(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(data)));
    }

    @NotNull
    public static List<Component> getFireworkExplosionTooltip(IClientUtils utils, int pad, FireworkExplosion data) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.explosion", new Object[0])));
        components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad + 1, "ali.property.value.shape", data.shape()));
        components.addAll(GenericTooltipUtils.getIntListTooltip(utils, pad + 1, "ali.property.value.colors", data.colors()));
        components.addAll(GenericTooltipUtils.getIntListTooltip(utils, pad + 1, "ali.property.value.fade_colors", data.fadeColors()));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.has_trail", data.hasTrail()));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.has_twinkle", data.hasTwinkle()));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getIntListTooltip(IClientUtils utils, int pad, String key, IntList data) {
        return GenericTooltipUtils.getStringTooltip(utils, pad, key, data.toString());
    }

    @NotNull
    public static <T> List<Component> getFilterableTooltip(IClientUtils utils, int pad, String key, Filterable<T> data, QuadFunction<IClientUtils, Integer, String, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
        components.addAll((Collection)mapper.apply(utils, pad + 1, "ali.property.value.raw", data.raw()));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.filtered", data.filtered(), mapper));
        return components;
    }

    @NotNull
    public static Component translatable(String key, Object ... args) {
        return Component.translatable((String)key, (Object[])Arrays.stream(args).map(GenericTooltipUtils::convertObject).toArray()).withStyle(TEXT_STYLE);
    }

    @NotNull
    public static Component value(Object value) {
        return GenericTooltipUtils.convertObject(value).withStyle(new ChatFormatting[]{PARAM_STYLE, ChatFormatting.BOLD});
    }

    @NotNull
    public static Component value(Object value, String unit) {
        return Component.translatable((String)"ali.util.advanced_loot_info.two_values", (Object[])new Object[]{GenericTooltipUtils.convertObject(value), unit}).withStyle(new ChatFormatting[]{PARAM_STYLE, ChatFormatting.BOLD});
    }

    @NotNull
    public static Component pair(Object value1, Object value2) {
        return Component.translatable((String)"ali.util.advanced_loot_info.two_values_with_space", (Object[])new Object[]{GenericTooltipUtils.convertObject(value1), GenericTooltipUtils.convertObject(value2)});
    }

    @NotNull
    public static Component pad(int count, Object arg) {
        if (count > 0) {
            return GenericTooltipUtils.pair(Component.translatable((String)("ali.util.advanced_loot_info.pad." + count)), GenericTooltipUtils.convertObject(arg));
        }
        return GenericTooltipUtils.convertObject(arg);
    }

    @NotNull
    public static Component keyValue(Object key, Object value) {
        return GenericTooltipUtils.translatable("ali.util.advanced_loot_info.key_value", GenericTooltipUtils.convertObject(key), GenericTooltipUtils.value(value));
    }

    public static @Unmodifiable @NotNull List<Component> getNumberProviderTooltip(IClientUtils utils, int pad, String key, NumberProvider value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(utils.convertNumber(utils, value)))));
    }

    @NotNull
    public static List<Component> getIntRangeTooltip(IClientUtils utils, int pad, String key, IntRange range) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(RangeValue.rangeToString(utils.convertNumber(utils, range.min), utils.convertNumber(utils, range.max))))));
    }

    public static @Unmodifiable @NotNull List<Component> getBooleanTooltip(IClientUtils utils, int pad, String key, Boolean value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getIntegerTooltip(IClientUtils utils, int pad, String key, Integer value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getLongTooltip(IClientUtils utils, int pad, String key, Long value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getStringTooltip(IClientUtils utils, int pad, String key, String value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getFloatTooltip(IClientUtils ignoredUtils, int pad, String key, Float value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getEnumTooltip(IClientUtils ignoredUtils, int pad, String key, Enum<?> value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value.name()))));
    }

    public static @Unmodifiable @NotNull List<Component> getEnumTooltip(IClientUtils utils, int pad, Enum<?> value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(value.name())));
    }

    public static @Unmodifiable @NotNull List<Component> getResourceLocationTooltip(IClientUtils ignoredUtils, int pad, String key, ResourceLocation value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static <T> @Unmodifiable @NotNull List<Component> getResourceKeyTooltip(IClientUtils utils, int pad, String key, ResourceKey<T> value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value.location()))));
    }

    public static <T> @Unmodifiable @NotNull List<Component> getTagKeyTooltip(IClientUtils utils, int pad, String key, TagKey<T> value) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, pad, key, value.location());
    }

    public static @Unmodifiable @NotNull List<Component> getComponentTooltip(IClientUtils ignoredUtils, int pad, String key, Component component) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(component))));
    }

    @NotNull
    public static <T> List<Component> getComponentsTooltip(IClientUtils utils, int pad, String key, T value, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        List componentList = (List)mapper.apply((Object)utils, (Object)(pad + 1), value);
        if (!componentList.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
            components.addAll(componentList);
        }
        return components;
    }

    @NotNull
    public static <T> List<Component> getComponentsTooltip(IClientUtils utils, int pad, String key, Optional<T> value, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        List<Component> componentList = GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, value, mapper);
        if (!componentList.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
            components.addAll(componentList);
        }
        return components;
    }

    @NotNull
    public static List<Component> getMinMaxBoundsTooltip(IClientUtils utils, int pad, String key, MinMaxBounds.Ints ints) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (ints != MinMaxBounds.Ints.ANY) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(GenericTooltipUtils.toString(ints)))));
        }
        return components;
    }

    @NotNull
    public static List<Component> getMinMaxBoundsTooltip(IClientUtils ignoredUtils, int pad, String key, MinMaxBounds.Doubles doubles) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (doubles != MinMaxBounds.Doubles.ANY) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(GenericTooltipUtils.toString(doubles)))));
        }
        return components;
    }

    @NotNull
    public static <T> List<Component> getOptionalTooltip(IClientUtils utils, int pad, Optional<T> optional, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        return optional.map(value -> (List)mapper.apply((Object)utils, (Object)pad, value)).orElse(List.of());
    }

    @NotNull
    public static <T> List<Component> getOptionalTooltip(IClientUtils utils, int pad, String key, Optional<T> optional, QuadFunction<IClientUtils, Integer, String, T, List<Component>> mapper) {
        return optional.map(value -> (List)mapper.apply(utils, pad, key, value)).orElse(List.of());
    }

    @NotNull
    public static <T> List<Component> getOptionalHolderTooltip(IClientUtils utils, int pad, Optional<Holder<T>> optional, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        return optional.map(holder -> GenericTooltipUtils.getHolderTooltip(utils, pad, holder, mapper)).orElse(List.of());
    }

    @NotNull
    public static <T> List<Component> getOptionalHolderSetTooltip(IClientUtils utils, int pad, String key, Optional<HolderSet<T>> optional, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        return optional.map(holderSet -> GenericTooltipUtils.getHolderSetTooltip(utils, pad, key, holderSet, mapper)).orElse(List.of());
    }

    @NotNull
    public static <T> List<Component> getHolderTooltip(IClientUtils utils, int pad, Holder<T> holder, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        return (List)mapper.apply((Object)utils, (Object)pad, holder.value());
    }

    @NotNull
    public static <T> List<Component> getHolderSetTooltip(IClientUtils utils, int pad, String key, HolderSet<T> holderSet, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        Either either = holderSet.unwrap();
        Optional left = either.left();
        Optional right = either.right();
        if (left.isPresent() || !right.orElse(List.of()).isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
        }
        left.ifPresent(tagKey -> components.addAll(GenericTooltipUtils.getTagKeyTooltip(utils, pad + 1, "ali.property.value.tag", tagKey)));
        right.ifPresent(list -> {
            if (!list.isEmpty()) {
                holderSet.forEach(holder -> components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, holder, mapper)));
            }
        });
        return components;
    }

    @NotNull
    public static <T> List<Component> getHolderSetTooltip(IClientUtils utils, int pad, String key, HolderSet<T> holderSet, String value) {
        LinkedList<Component> components = new LinkedList<Component>();
        Either either = holderSet.unwrap();
        Optional left = either.left();
        Optional right = either.right();
        if (left.isPresent() || !right.orElse(List.of()).isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
        }
        left.ifPresent(tagKey -> components.addAll(GenericTooltipUtils.getTagKeyTooltip(utils, pad + 1, "ali.property.value.tag", tagKey)));
        right.ifPresent(list -> {
            if (!list.isEmpty()) {
                holderSet.forEach(holder -> components.addAll(GenericTooltipUtils.getResourceKeyTooltip(utils, pad + 1, value, (ResourceKey)holder.unwrapKey().orElseThrow())));
            }
        });
        return components;
    }

    @NotNull
    public static <T> List<Component> getCollectionTooltip(IClientUtils utils, int pad, String key, Collection<T> values, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (!values.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
            values.forEach(value -> components.addAll((Collection)mapper.apply((Object)utils, (Object)(pad + 1), value)));
        }
        return components;
    }

    @NotNull
    public static <T, P extends Collection<T>> List<Component> getCollectionTooltip(IClientUtils utils, int pad, String key, Optional<P> values, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        values.ifPresent(v -> {
            if (!v.isEmpty()) {
                components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
                v.forEach(value -> components.addAll((Collection)mapper.apply((Object)utils, (Object)(pad + 1), value)));
            }
        });
        return components;
    }

    @NotNull
    private static String toString(MinMaxBounds.Doubles doubles) {
        Optional min = doubles.min();
        Optional max = doubles.max();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min, max)) {
                    return String.format("%.1f-%.1f", min.get(), max.get());
                }
                return String.format("=%.1f", min.get());
            }
            return String.format("\u2265%.1f", min.get());
        }
        return max.map(aDouble -> String.format("\u2264%.1f", aDouble)).orElse("???");
    }

    @NotNull
    private static String toString(MinMaxBounds.Ints ints) {
        Optional min = ints.min();
        Optional max = ints.max();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min, max)) {
                    return String.format("%d-%d", min.get(), max.get());
                }
                return String.format("=%d", min.get());
            }
            return String.format("\u2265%d", min.get());
        }
        return max.map(integer -> String.format("\u2264%d", integer)).orElse("???");
    }

    @NotNull
    private static MutableComponent convertObject(@Nullable Object object) {
        if (object instanceof MutableComponent) {
            MutableComponent component = (MutableComponent)object;
            return component;
        }
        if (object != null) {
            return Component.literal((String)object.toString());
        }
        return Component.literal((String)"null");
    }

    @FunctionalInterface
    public static interface QuadFunction<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }
}

