/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.configuration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public abstract class LootCategory<T> {
    private final ResourceLocation key;
    private final Item icon;
    private final Type type;
    private final boolean hide;

    public LootCategory(ResourceLocation key, Item icon, Type type, boolean hide) {
        this.key = key;
        this.icon = icon;
        this.type = type;
        this.hide = hide;
    }

    public LootCategory(Type type, JsonObject jsonObject) {
        this.type = type;
        this.key = ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)jsonObject, (String)"key"));
        this.icon = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(GsonHelper.getAsString((JsonObject)jsonObject, (String)"icon")));
        this.hide = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"hide");
    }

    protected abstract void toJson(JsonObject var1);

    public abstract boolean validate(T var1);

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LootCategory that = (LootCategory)o;
        return Objects.equals(this.key, that.key) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.type});
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public Item getIcon() {
        return this.icon;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isHidden() {
        return this.hide;
    }

    @NotNull
    public final JsonElement toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("key", this.key.toString());
        object.addProperty("type", this.type.name());
        object.addProperty("icon", BuiltInRegistries.ITEM.getKey((Object)this.icon).toString());
        object.addProperty("hide", Boolean.valueOf(this.hide));
        this.toJson(object);
        return object;
    }

    public static enum Type {
        BLOCK,
        ENTITY,
        GAMEPLAY,
        TRADE;

    }
}

