/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.tooltip;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.plugin.common.tooltip.ListTooltipNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ComponentTooltipNode
extends ListTooltipNode
implements ITooltipNode {
    public static final ResourceLocation ID = new ResourceLocation("ali", "component");
    private static final LoadingCache<CacheKey, ComponentTooltipNode> CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(data -> data != null ? new ComponentTooltipNode((CacheKey)data) : null));
    private final List<Component> values;
    private final String key;

    private ComponentTooltipNode(CacheKey cacheKey) {
        super(cacheKey.children);
        this.key = cacheKey.key;
        this.values = cacheKey.values;
    }

    @Override
    public void encodeNode(FriendlyByteBuf buf) {
        buf.writeInt(this.values.size());
        for (Component value : this.values) {
            buf.writeComponent(value);
        }
        buf.writeUtf(this.key);
    }

    @Override
    public List<Component> getComponents(int pad, boolean showAdvancedTooltip) {
        if (this.key == null) {
            throw new IllegalStateException("Key was not set!");
        }
        List<Component> children = super.getComponents(pad + 1, showAdvancedTooltip);
        ArrayList<Component> components = new ArrayList<Component>(children.size() + 1);
        Object[] values = this.values.stream().map(ComponentTooltipNode::transform).toArray();
        components.add(ITooltipNode.pad(pad, Component.translatable((String)this.key, (Object[])values).withStyle(TEXT_STYLE)));
        components.addAll(children);
        return components;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentTooltipNode that = (ComponentTooltipNode)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.values, this.key);
    }

    public String toString() {
        return "ComponentTooltipNode{key='" + this.key + "', values=" + String.valueOf(this.values) + ", children=" + String.valueOf(this.getChildren()) + "}";
    }

    @NotNull
    public static Builder values(Component ... values) {
        return new Builder(Arrays.asList(values));
    }

    @NotNull
    public static ComponentTooltipNode decode(IClientUtils utils, FriendlyByteBuf buf) {
        List<Component> values;
        List<ITooltipNode> children = ListTooltipNode.decodeChildren(utils, buf);
        int size = buf.readInt();
        if (size == 1) {
            values = Collections.singletonList(buf.readComponent());
        } else {
            values = new ArrayList<Component>();
            for (int i = 0; i < size; ++i) {
                values.add(buf.readComponent());
            }
        }
        String key = buf.readUtf();
        CacheKey cacheKey = new CacheKey(children, key, values);
        try {
            return (ComponentTooltipNode)CACHE.get((Object)cacheKey);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static Component transform(Component component) {
        if (component instanceof MutableComponent) {
            MutableComponent mutableComponent = (MutableComponent)component;
            return mutableComponent.copy().withStyle(ITooltipNode.PARAM_STYLE);
        }
        return component;
    }

    private record CacheKey(List<ITooltipNode> children, String key, List<Component> values) {
        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.key, cacheKey.key) && Objects.equals(this.values, cacheKey.values) && Objects.equals(this.children, cacheKey.children);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.children, this.key, this.values);
        }
    }

    public static class Builder
    extends ListTooltipNode.Builder {
        private final List<Component> values;

        public Builder(List<Component> values) {
            this.values = values;
        }

        @Override
        public ComponentTooltipNode build(String key) {
            String internKey = key.intern();
            CacheKey cacheKey = new CacheKey((List<ITooltipNode>)ImmutableList.copyOf((Collection)this.children), internKey, (List<Component>)ImmutableList.copyOf(this.values));
            try {
                return (ComponentTooltipNode)CACHE.get((Object)cacheKey);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

