/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yanny.ali.api.Rect;
import com.yanny.ali.mixin.MixinBushBlock;
import java.util.Optional;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class JeiBlockSlotWidget
implements ISlottedRecipeWidget {
    private final BlockState blockState;
    private final Block block;
    private final boolean isPlant;
    private final ScreenPosition position;
    private final Rect rect;
    private final ClientLevel level;
    private final IRecipeSlotDrawable slotDrawable;

    public JeiBlockSlotWidget(IRecipeSlotDrawable slotDrawable, Block block, int x, int y) {
        this.slotDrawable = slotDrawable;
        this.block = block;
        this.blockState = block.defaultBlockState();
        this.isPlant = block instanceof BushBlock;
        this.position = new ScreenPosition(x, y);
        this.rect = new Rect(x - 4, y - 4, 24, 24);
        this.level = Minecraft.getInstance().level;
    }

    @NotNull
    public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double v, double v1) {
        return Optional.empty();
    }

    @NotNull
    public ScreenPosition getPosition() {
        return this.position;
    }

    public void drawWidget(GuiGraphics guiGraphics, double mouseX, double mouseY) {
        PoseStack poseStack = guiGraphics.pose();
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        poseStack.pushPose();
        this.slotDrawable.draw(guiGraphics);
        if (this.block.asItem() == Items.AIR) {
            poseStack.translate((float)this.rect.x(), (float)this.rect.y(), 0.0f);
            if (this.isPlant) {
                MixinBushBlock bushBlock;
                poseStack.translate(18.0f, 10.0f, 100.0f);
                poseStack.scale(9.0f, -9.0f, 9.0f);
                poseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(225.0f));
                guiGraphics.drawSpecial(bufferSource -> blockRenderer.renderSingleBlock(this.blockState, poseStack, bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY));
                BlockState farmland = Blocks.FARMLAND.defaultBlockState();
                Block block = this.block;
                BlockState base = block instanceof MixinBushBlock && (bushBlock = (MixinBushBlock)block).invokeMayPlaceOn(farmland, (BlockGetter)this.level, BlockPos.ZERO) ? farmland : Blocks.GRASS_BLOCK.defaultBlockState();
                poseStack.translate(0.0f, -1.0f, 0.0f);
                guiGraphics.drawSpecial(bufferSource -> blockRenderer.renderSingleBlock(base, poseStack, bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY));
            } else {
                poseStack.translate(25.5, 21.0, 100.0);
                poseStack.scale(18.0f, -18.0f, 18.0f);
                poseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(225.0f));
                guiGraphics.drawSpecial(bufferSource -> blockRenderer.renderSingleBlock(this.blockState, poseStack, bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY));
                poseStack.translate(0.0f, -1.0f, 0.0f);
            }
        }
        poseStack.popPose();
    }

    public void getTooltip(ITooltipBuilder tooltip, double mouseX, double mouseY) {
        if (this.slotDrawable.isMouseOver(mouseX, mouseY)) {
            if (this.isPlant) {
                tooltip.add((FormattedText)this.block.getName());
            } else {
                this.slotDrawable.getTooltip(tooltip);
            }
        }
    }
}

