/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.compatibility.common.BlockLootType;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.GameplayLootType;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.rei.ReiBaseCategory;
import com.yanny.ali.compatibility.rei.ReiBaseDisplay;
import com.yanny.ali.compatibility.rei.ReiBlockCategory;
import com.yanny.ali.compatibility.rei.ReiBlockDisplay;
import com.yanny.ali.compatibility.rei.ReiEntityCategory;
import com.yanny.ali.compatibility.rei.ReiEntityDisplay;
import com.yanny.ali.compatibility.rei.ReiGameplayCategory;
import com.yanny.ali.compatibility.rei.ReiGameplayDisplay;
import com.yanny.ali.network.AbstractClient;
import com.yanny.ali.platform.Services;
import com.yanny.ali.registries.LootCategories;
import com.yanny.ali.registries.LootCategory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReasons;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ReiCompatibility
implements REIClientPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Holder<ReiBlockDisplay, BlockLootType, Block>> blockCategoryList = new LinkedList<Holder<ReiBlockDisplay, BlockLootType, Block>>();
    private final List<Holder<ReiEntityDisplay, EntityLootType, Entity>> entityCategoryList = new LinkedList<Holder<ReiEntityDisplay, EntityLootType, Entity>>();
    private final List<Holder<ReiGameplayDisplay, GameplayLootType, String>> gameplayCategoryList = new LinkedList<Holder<ReiGameplayDisplay, GameplayLootType, String>>();

    public void registerCategories(CategoryRegistry registry) {
        this.blockCategoryList.clear();
        this.entityCategoryList.clear();
        this.gameplayCategoryList.clear();
        this.blockCategoryList.add(this.createCategory(LootCategories.PLANT_LOOT, ReiBlockDisplay::new, ReiBlockCategory::new));
        this.blockCategoryList.addAll(LootCategories.BLOCK_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiBlockDisplay::new, ReiBlockCategory::new)).collect(Collectors.toSet()));
        this.blockCategoryList.add(this.createCategory(LootCategories.BLOCK_LOOT, ReiBlockDisplay::new, ReiBlockCategory::new));
        this.entityCategoryList.addAll(LootCategories.ENTITY_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiEntityDisplay::new, ReiEntityCategory::new)).collect(Collectors.toSet()));
        this.entityCategoryList.add(this.createCategory(LootCategories.ENTITY_LOOT, ReiEntityDisplay::new, ReiEntityCategory::new));
        this.gameplayCategoryList.addAll(LootCategories.GAMEPLAY_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiGameplayDisplay::new, ReiGameplayCategory::new)).collect(Collectors.toSet()));
        this.gameplayCategoryList.add(this.createCategory(LootCategories.GAMEPLAY_LOOT, ReiGameplayDisplay::new, ReiGameplayCategory::new));
        for (Holder<ReiBlockDisplay, BlockLootType, Block> holder : this.blockCategoryList) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.entityCategoryList) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.gameplayCategoryList) {
            registry.add(holder.category);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void registerDisplays(DisplayRegistry registry) {
        AbstractClient client = Services.PLATFORM.getInfoPropagator().client();
        ClientLevel level = Minecraft.getInstance().level;
        if (client != null && level != null) {
            Map<ResourceKey<LootTable>, LootTable> map = GenericUtils.getLootTables();
            HashMap blockRecipeTypes = new HashMap();
            HashMap entityRecipeTypes = new HashMap();
            HashMap<Holder, List> gameplayRecipeTypes = new HashMap<Holder, List>();
            map.entrySet().stream().sorted(Comparator.comparing(s -> ((ResourceKey)s.getKey()).location().getPath())).forEach(f -> LOGGER.warn(((ResourceKey)f.getKey()).location().getPath()));
            for (Block block : BuiltInRegistries.BLOCK) {
                block.getLootTable().ifPresent(location -> {
                    LootTable lootEntry = (LootTable)map.get(location);
                    if (lootEntry != null) {
                        for (Holder<ReiBlockDisplay, BlockLootType, Block> holder : this.blockCategoryList) {
                            if (!holder.category.getLootCategory().validate(block)) continue;
                            blockRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new BlockLootType(block, lootEntry, GenericUtils.getItems((ResourceKey<LootTable>)location)));
                            break;
                        }
                        map.remove(location);
                    }
                });
            }
            for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
                LinkedList<Object> entityList = new LinkedList<Object>();
                if (entityType == EntityType.SHEEP) {
                    Sheep sheep;
                    for (DyeColor color : DyeColor.values()) {
                        void sheep2;
                        try {
                            Sheep sheep22 = (Sheep)entityType.create((Level)level, EntitySpawnReason.LOAD);
                        }
                        catch (Throwable e) {
                            LOGGER.warn("Failed to create colored sheep with color {}: {}", (Object)color.getSerializedName(), (Object)e.getMessage());
                            continue;
                        }
                        if (sheep2 == null) continue;
                        sheep2.setColor(color);
                        entityList.add(sheep2);
                    }
                    try {
                        sheep = (Sheep)entityType.create((Level)level, EntitySpawnReason.LOAD);
                    }
                    catch (Throwable throwable) {
                        LOGGER.warn("Failed to create sheep: {}", (Object)throwable.getMessage());
                        continue;
                    }
                    if (sheep != null) {
                        sheep.setSheared(true);
                        entityList.add(sheep);
                    }
                } else {
                    Entity entity;
                    try {
                        entity = entityType.create((Level)level, EntitySpawnReason.LOAD);
                    }
                    catch (Throwable throwable) {
                        LOGGER.warn("Failed to create entity {}: {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType), (Object)throwable.getMessage());
                        continue;
                    }
                    entityList.add(entity);
                }
                for (Entity entity : entityList) {
                    if (!(entity instanceof Mob)) continue;
                    Mob mob = (Mob)entity;
                    mob.getLootTable().ifPresent(location -> {
                        LootTable lootEntry = (LootTable)map.get(location);
                        if (lootEntry != null) {
                            for (Holder<ReiEntityDisplay, EntityLootType, Entity> holder : this.entityCategoryList) {
                                if (!holder.category.getLootCategory().validate(entity)) continue;
                                entityRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new EntityLootType(entity, lootEntry, GenericUtils.getItems((ResourceKey<LootTable>)location)));
                                break;
                            }
                            map.remove(location);
                        }
                    });
                }
            }
            for (Map.Entry<ResourceKey<LootTable>, LootTable> entry : new HashMap<ResourceKey<LootTable>, LootTable>(map).entrySet()) {
                ResourceKey<LootTable> location2 = entry.getKey();
                for (Holder holder : this.gameplayCategoryList) {
                    if (!holder.category.getLootCategory().validate(location2.location().getPath())) continue;
                    gameplayRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new GameplayLootType(entry.getValue(), "/" + location2.location().getPath(), GenericUtils.getItems(location2)));
                    break;
                }
                map.remove(location2);
            }
            for (Map.Entry<Object, Object> entry : blockRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.blockPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry<Object, Object> entry : entityRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.entityPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry<Object, Object> entry : gameplayRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.gameplayPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
        }
    }

    @NotNull
    private <D extends ReiBaseDisplay, T, U> Holder<D, T, U> createCategory(Map.Entry<ResourceLocation, LootCategory<U>> e, BiFunction<T, CategoryIdentifier<D>, D> displayFactory, TriFunction<CategoryIdentifier<D>, Component, LootCategory<U>, ReiBaseCategory<D, U>> categoryFactory) {
        ResourceLocation id = e.getKey();
        CategoryIdentifier identifier = CategoryIdentifier.of((String)id.getNamespace(), (String)id.getPath());
        MutableComponent title = Component.translatable((String)("emi.category." + id.getNamespace() + "." + id.getPath().replace('/', '.')));
        BiFunction<Object, DisplayAdditionReasons, ReiBaseDisplay> filler = (type, r) -> (ReiBaseDisplay)((Object)((Object)displayFactory.apply(type, identifier)));
        return new Holder(identifier, (ReiBaseCategory)categoryFactory.apply((Object)identifier, (Object)title, e.getValue()), filler);
    }

    @NotNull
    private <D extends ReiBaseDisplay, T, U> Holder<D, T, U> createCategory(LootCategory<U> lootCategory, BiFunction<T, CategoryIdentifier<D>, D> displayFactory, TriFunction<CategoryIdentifier<D>, Component, LootCategory<U>, ReiBaseCategory<D, U>> categoryFactory) {
        CategoryIdentifier identifier = CategoryIdentifier.of((String)"ali", (String)lootCategory.getKey());
        MutableComponent title = Component.translatable((String)("emi.category.ali." + lootCategory.getKey().replace('/', '.')));
        BiFunction<Object, DisplayAdditionReasons, ReiBaseDisplay> filler = (type, r) -> (ReiBaseDisplay)((Object)((Object)displayFactory.apply(type, identifier)));
        return new Holder(identifier, (ReiBaseCategory)categoryFactory.apply((Object)identifier, (Object)title, lootCategory), filler);
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> blockPredicate(List<BlockLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof BlockLootType) {
                BlockLootType type = (BlockLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> entityPredicate(List<EntityLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof EntityLootType) {
                EntityLootType type = (EntityLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> gameplayPredicate(List<GameplayLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof GameplayLootType) {
                GameplayLootType type = (GameplayLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    private record Holder<D extends ReiBaseDisplay, T, U>(CategoryIdentifier<D> identifier, ReiBaseCategory<D, U> category, BiFunction<T, DisplayAdditionReasons, D> filler) {
    }
}

